/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.generation.algebra.SQLFlattenExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class DremioSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    private DremioSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            public String serialize(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
                return super.serialize(term, columnIDs);
            }

            @Override
            protected String serializeDatetimeConstant(String datetime, DBTermType dbType) {
                return String.format("CAST(%s AS %s)", this.serializeStringConstant(datetime), dbType.getCastName());
            }
        });
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("LIMIT %d OFFSET %d", limit, offset);
            }

            @Override
            protected String serializeValuesEntry(Constant constant, ImmutableMap<Variable, QualifiedAttributeID> childColumnIDs) {
                String serialization = DremioSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)constant, childColumnIDs);
                if (constant instanceof DBConstant && ((DBConstant)constant).getType().getCategory() == DBTermType.Category.INTEGER) {
                    return String.format("CAST(%s as INTEGER)", serialization);
                }
                return serialization;
            }

            @Override
            protected SelectFromWhereSerializer.QuerySerialization serializeFlatten(SQLFlattenExpression sqlFlattenExpression, Variable flattenedVar, Variable outputVar, Optional<Variable> indexVar, DBTermType flattenedType, ImmutableMap<Variable, QualifiedAttributeID> allColumnIDs, SelectFromWhereSerializer.QuerySerialization subQuerySerialization) {
                if (indexVar.isPresent()) {
                    throw new SQLSerializationException("Dremio does not support FLATTEN with position arguments.");
                }
                String expression = flattenedType.getCategory() == DBTermType.Category.ARRAY ? ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering() : String.format("CONVERT_FROM(%s, 'json')", ((QualifiedAttributeID)allColumnIDs.get((Object)flattenedVar)).getSQLRendering());
                String alias = this.generateFreshViewAlias().getSQLRendering();
                ImmutableMap variableAliases = (ImmutableMap)allColumnIDs.entrySet().stream().filter(e -> e.getKey() != flattenedVar).collect(ImmutableCollectors.toMap(v -> (Variable)v.getKey(), v -> new QualifiedAttributeID(this.idFactory.createRelationID(alias), ((QualifiedAttributeID)v.getValue()).getAttribute())));
                Object subProjection = subQuerySerialization.getColumnIDs().keySet().stream().filter(v -> variableAliases.containsKey(v)).map(v -> ((QualifiedAttributeID)subQuerySerialization.getColumnIDs().get(v)).getSQLRendering() + " AS " + this.idFactory.createAttributeID(v.getName()).getSQLRendering()).collect(Collectors.joining(", "));
                if (((String)subProjection).length() > 0) {
                    subProjection = (String)subProjection + ",";
                }
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("(SELECT %s CASE WHEN RAND() > 1 THEN NULL ELSE FLATTEN(%s) END AS %s FROM %s LIMIT 99999999999999) %s", subProjection, expression, ((QualifiedAttributeID)allColumnIDs.get((Object)outputVar)).getSQLRendering(), subQuerySerialization.getString(), alias));
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(builder.toString(), (ImmutableMap<Variable, QualifiedAttributeID>)variableAliases);
            }
        });
    }
}

