/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.generation.normalization.impl.AbstractTypingNullsDialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

public class TypingNullsInConstructionNodeDialectExtraNormalizer
extends AbstractTypingNullsDialectExtraNormalizer {
    private final DBTermType defaultType;

    @Inject
    protected TypingNullsInConstructionNodeDialectExtraNormalizer(CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.defaultType = coreSingletons.getTypeFactory().getDBTypeFactory().getDBStringType();
    }

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
        IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
        ImmutableSet<Variable> nullVariables = this.extractNullVariables(rootNode);
        if (nullVariables.isEmpty()) {
            return newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
        }
        ImmutableMap typedNullMap = (ImmutableMap)nullVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.termFactory.getTypedNull(this.defaultType)));
        return this.updateSubQuery((IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, newChild), (ImmutableMap<Variable, ImmutableFunctionalTerm>)typedNullMap);
    }
}

