/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;

@Singleton
public class SubQueryFromComplexJoinExtraNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    @Inject
    protected SubQueryFromComplexJoinExtraNormalizer(CoreSingletons coreSingletons) {
        super(coreSingletons);
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.transform(tree);
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        IQTree newLeftChild = this.createSubQueryIfJoin(leftChild);
        IQTree newRightChild = this.createSubQueryIfJoin(rightChild);
        return newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeftChild, newRightChild);
    }

    private IQTree createSubQueryIfJoin(IQTree child) {
        IQTree transformedChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
        if (transformedChild.getRootNode() instanceof JoinLikeNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(transformedChild.getVariables()), transformedChild);
        }
        return transformedChild;
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(this::createSubQueryIfJoin).collect(ImmutableCollectors.toList());
        return newChildren.equals(children) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
    }
}

