/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeExtendedTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.NonDeterministicDBFunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ProjectOrderByTermsNormalizer
extends DefaultRecursiveIQTreeExtendedTransformer<VariableGenerator>
implements DialectExtraNormalizer {
    private final boolean onlyInPresenceOfDistinct;
    private final SubstitutionFactory substitutionFactory;

    protected ProjectOrderByTermsNormalizer(boolean onlyInPresenceOfDistinct, CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.onlyInPresenceOfDistinct = onlyInPresenceOfDistinct;
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return tree.acceptTransformer((IQTreeExtendedTransformer)this, (Object)variableGenerator);
    }

    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child, VariableGenerator variableGenerator) {
        return this.transformConstructionSliceDistinctOrOrderByTree(tree, variableGenerator);
    }

    public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child, VariableGenerator variableGenerator) {
        return this.transformConstructionSliceDistinctOrOrderByTree(tree, variableGenerator);
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child, VariableGenerator variableGenerator) {
        return this.transformConstructionSliceDistinctOrOrderByTree(tree, variableGenerator);
    }

    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child, VariableGenerator variableGenerator) {
        return this.transformConstructionSliceDistinctOrOrderByTree(tree, variableGenerator);
    }

    protected IQTree transformConstructionSliceDistinctOrOrderByTree(IQTree tree, VariableGenerator variableGenerator) {
        IQTree newTree = this.applyTransformerToDescendantTree(tree, variableGenerator);
        Decomposition decomposition = Decomposition.decomposeTree(newTree);
        return decomposition.orderByNode.filter(o -> decomposition.distinctNode.isPresent() || !this.onlyInPresenceOfDistinct).map(o -> new Analysis(decomposition.distinctNode.isPresent(), decomposition.constructionNode, (ImmutableList<OrderByNode.OrderComparator>)o.getComparators(), decomposition.distinctNode.isPresent() ? decomposition.descendantTree.normalizeForOptimization(variableGenerator).inferFunctionalDependencies() : FunctionalDependencies.empty())).map(a -> this.normalize(newTree, (Analysis)a, variableGenerator)).orElse(newTree);
    }

    private IQTree applyTransformerToDescendantTree(IQTree tree, VariableGenerator variableGenerator) {
        Decomposition decomposition = Decomposition.decomposeTree(tree);
        IQTree newDescendantTree = this.transform(decomposition.descendantTree, variableGenerator);
        return decomposition.descendantTree.equals(newDescendantTree) ? tree : decomposition.rebuildWithNewDescendantTree(newDescendantTree, this.iqFactory);
    }

    private IQTree normalize(IQTree tree, Analysis analysis, VariableGenerator variableGenerator) {
        ImmutableSet projectedVariables = tree.getVariables();
        ImmutableSet alreadyDefinedTerms = Sets.union((Set)projectedVariables, (Set)analysis.getSubstitution().getRangeSet()).immutableCopy();
        ImmutableMap newBindings = (ImmutableMap)analysis.sortConditions.stream().map(OrderByNode.OrderComparator::getTerm).filter(t -> !alreadyDefinedTerms.contains(t)).distinct().map(t -> Maps.immutableEntry((Object)(t instanceof Variable ? (Variable)t : variableGenerator.generateNewVariable()), (Object)t)).collect(ImmutableCollectors.toMap());
        if (newBindings.isEmpty()) {
            return tree;
        }
        if (analysis.hasDistinct && newBindings.values().stream().anyMatch(t -> this.mayImpactDistinct((ImmutableTerm)t, (ImmutableSet<ImmutableTerm>)alreadyDefinedTerms, analysis.descendantTreeFunctionalDependencies))) {
            throw new DistinctOrderByDialectLimitationException();
        }
        ImmutableSet newProjectedVariables = Sets.union((Set)projectedVariables, (Set)newBindings.keySet()).immutableCopy();
        Substitution newSubstitution = this.substitutionFactory.union((Substitution)newBindings.entrySet().stream().collect(this.substitutionFactory.toSubstitutionSkippingIdentityEntries()), analysis.getSubstitution());
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(newProjectedVariables, newSubstitution);
        return analysis.constructionNode.map(n -> this.updateTopConstructionNode(tree, newConstructionNode)).orElseGet(() -> this.insertConstructionNode(tree, newConstructionNode));
    }

    protected boolean mayImpactDistinct(ImmutableTerm term, ImmutableSet<ImmutableTerm> alreadyProjectedTerms, FunctionalDependencies descendantTreeFunctionalDependencies) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            if (functionalTerm.getFunctionSymbol() instanceof NonDeterministicDBFunctionSymbol) {
                return true;
            }
            if (alreadyProjectedTerms.contains((Object)term)) {
                return false;
            }
            return functionalTerm.getTerms().stream().anyMatch(t -> this.mayImpactDistinct((ImmutableTerm)t, alreadyProjectedTerms, descendantTreeFunctionalDependencies));
        }
        if (term instanceof Variable) {
            if (alreadyProjectedTerms.contains((Object)term)) {
                return false;
            }
            return descendantTreeFunctionalDependencies.getDeterminantsOf((Variable)term).stream().noneMatch(arg_0 -> alreadyProjectedTerms.containsAll(arg_0));
        }
        return false;
    }

    private IQTree updateTopConstructionNode(IQTree tree, ConstructionNode newConstructionNode) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, ((UnaryIQTree)tree).getChild());
        }
        if (rootNode instanceof UnaryOperatorNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, this.updateTopConstructionNode(((UnaryIQTree)tree).getChild(), newConstructionNode));
        }
        throw new MinorOntopInternalBugException("Was expected to reach a ConstructionNode before a non-unary node");
    }

    private IQTree insertConstructionNode(IQTree tree, ConstructionNode newConstructionNode) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof DistinctNode || rootNode instanceof SliceNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, this.insertConstructionNode(((UnaryIQTree)tree).getChild(), newConstructionNode));
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, tree);
    }

    protected static class Decomposition {
        final Optional<SliceNode> sliceNode;
        final Optional<DistinctNode> distinctNode;
        final Optional<ConstructionNode> constructionNode;
        final Optional<OrderByNode> orderByNode;
        final IQTree descendantTree;

        private Decomposition(Optional<SliceNode> sliceNode, Optional<DistinctNode> distinctNode, Optional<ConstructionNode> constructionNode, Optional<OrderByNode> orderByNode, IQTree descendantTree) {
            this.sliceNode = sliceNode;
            this.distinctNode = distinctNode;
            this.constructionNode = constructionNode;
            this.orderByNode = orderByNode;
            this.descendantTree = descendantTree;
        }

        IQTree rebuildWithNewDescendantTree(IQTree newDescendantTree, IntermediateQueryFactory iqFactory) {
            return Stream.of(this.orderByNode, this.constructionNode, this.distinctNode, this.sliceNode).flatMap(Optional::stream).reduce(newDescendantTree, (t, n) -> iqFactory.createUnaryIQTree(n, t), (t1, t2) -> {
                throw new MinorOntopInternalBugException("Must not be run in parallel");
            });
        }

        static Decomposition decomposeTree(IQTree tree) {
            QueryNode rootNode = tree.getRootNode();
            Optional<SliceNode> sliceNode = Optional.of(rootNode).filter(n -> n instanceof SliceNode).map(n -> (SliceNode)n);
            IQTree firstNonSliceTree = sliceNode.map(n -> ((UnaryIQTree)tree).getChild()).orElse(tree);
            Optional<DistinctNode> distinctNode = Optional.of(firstNonSliceTree).map(IQTree::getRootNode).filter(n -> n instanceof DistinctNode).map(n -> (DistinctNode)n);
            IQTree firstNonSliceDistinctTree = distinctNode.map(n -> ((UnaryIQTree)firstNonSliceTree).getChild()).orElse(firstNonSliceTree);
            Optional<ConstructionNode> constructionNode = Optional.of(firstNonSliceDistinctTree).map(IQTree::getRootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
            IQTree firstNonSliceDistinctConstructionTree = constructionNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctTree).getChild()).orElse(firstNonSliceDistinctTree);
            Optional<OrderByNode> orderByNode = Optional.of(firstNonSliceDistinctConstructionTree).map(IQTree::getRootNode).filter(n -> n instanceof OrderByNode).map(n -> (OrderByNode)n);
            IQTree descendantTree = orderByNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctConstructionTree).getChild()).orElse(firstNonSliceDistinctConstructionTree);
            return new Decomposition(sliceNode, distinctNode, constructionNode, orderByNode, descendantTree);
        }
    }

    private static class DistinctOrderByDialectLimitationException
    extends OntopInternalBugException {
        protected DistinctOrderByDialectLimitationException() {
            super("The dialect requires ORDER BY conditions to be projected but a DISTINCT prevents some of them");
        }
    }

    private final class Analysis {
        final boolean hasDistinct;
        final Optional<ConstructionNode> constructionNode;
        final ImmutableList<OrderByNode.OrderComparator> sortConditions;
        final FunctionalDependencies descendantTreeFunctionalDependencies;

        private Analysis(boolean hasDistinct, Optional<ConstructionNode> constructionNode, ImmutableList<OrderByNode.OrderComparator> sortConditions, FunctionalDependencies descendantTreeFunctionalDependencies) {
            this.hasDistinct = hasDistinct;
            this.constructionNode = constructionNode;
            this.sortConditions = sortConditions;
            this.descendantTreeFunctionalDependencies = descendantTreeFunctionalDependencies;
        }

        Substitution<ImmutableTerm> getSubstitution() {
            return this.constructionNode.map(ConstructionNode::getSubstitution).orElseGet(() -> ((SubstitutionFactory)ProjectOrderByTermsNormalizer.this.substitutionFactory).getSubstitution());
        }
    }
}

