/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonFlattenLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonJoinLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonSQLLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonUnionLens;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.IRISafenessDeclarationFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import it.unibz.inf.ontop.utils.impl.VariableGeneratorImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonDeserialize(using=JSONLensDeserializer.class)
public abstract class JsonLens
extends JsonOpenObject {
    public final @Nonnull List<String> name;
    public final @Nullable UniqueConstraints uniqueConstraints;
    public final @Nullable OtherFunctionalDependencies otherFunctionalDependencies;
    public final @Nullable ForeignKeys foreignKeys;
    public final @Nullable NonNullConstraints nonNullConstraints;
    public final @Nullable IRISafeConstraints iriSafeConstraints;

    public JsonLens(List<String> name, @Nullable UniqueConstraints uniqueConstraints, @Nullable OtherFunctionalDependencies otherFunctionalDependencies, @Nullable ForeignKeys foreignKeys, @Nullable NonNullConstraints nonNullConstraints, @Nullable IRISafeConstraints iriSafeConstraints) {
        this.name = name;
        this.uniqueConstraints = uniqueConstraints;
        this.otherFunctionalDependencies = otherFunctionalDependencies;
        this.foreignKeys = foreignKeys;
        this.nonNullConstraints = nonNullConstraints;
        this.iriSafeConstraints = iriSafeConstraints;
    }

    public abstract Lens createViewDefinition(DBParameters var1, MetadataLookup var2) throws MetadataExtractionException;

    public abstract void insertIntegrityConstraints(Lens var1, ImmutableList<NamedRelationDefinition> var2, MetadataLookup var3, DBParameters var4) throws MetadataExtractionException;

    public boolean propagateUniqueConstraintsUp(Lens relation, ImmutableList<NamedRelationDefinition> parents, QuotedIDFactory idFactory) throws MetadataExtractionException {
        return false;
    }

    public boolean propagateForeignKeyConstraintsUp(Lens relation, ImmutableList<NamedRelationDefinition> parents, QuotedIDFactory idFactory) throws MetadataExtractionException {
        return false;
    }

    public abstract ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(Lens var1, ImmutableList<Attribute> var2);

    protected RelationDefinition.AttributeListBuilder createAttributeBuilder(IQ iq, DBParameters dbParameters) {
        SingleTermTypeExtractor uniqueTermTypeExtractor = dbParameters.getCoreSingletons().getUniqueTermTypeExtractor();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
        IQTree iqTree = iq.getTree();
        ImmutableSet addedNonNullAttributes = this.nonNullConstraints == null ? ImmutableSet.of() : (ImmutableSet)this.nonNullConstraints.added.stream().map(arg_0 -> ((QuotedIDFactory)quotedIdFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        RawQuotedIDFactory rawQuotedIqFactory = new RawQuotedIDFactory(quotedIdFactory);
        for (Variable v : iq.getProjectionAtom().getVariables()) {
            QuotedID attributeId = rawQuotedIqFactory.createAttributeID(v.getName());
            boolean isNullable = !addedNonNullAttributes.contains((Object)attributeId) && iqTree.getVariableNullability().isPossiblyNullable(v);
            builder.addAttribute(attributeId, (DBTermType)uniqueTermTypeExtractor.extractSingleTermType((ImmutableTerm)v, iqTree).orElseGet(() -> dbParameters.getDBTypeFactory().getAbstractRootDBType()), isNullable);
        }
        return builder;
    }

    protected IQTree addIRISafeConstraints(IQTree iqTreeBeforeIRISafeConstraints, DBParameters dbParameters) {
        if (this.iriSafeConstraints == null || this.iriSafeConstraints.added.isEmpty()) {
            return iqTreeBeforeIRISafeConstraints;
        }
        ImmutableSet initialProjectedVariables = iqTreeBeforeIRISafeConstraints.getVariables();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        RawQuotedIDFactory rawQuotedIqFactory = new RawQuotedIDFactory(quotedIdFactory);
        ImmutableSet iriSafeVariables = (ImmutableSet)this.iriSafeConstraints.added.stream().map(arg_0 -> ((QuotedIDFactory)quotedIdFactory).createAttributeID(arg_0)).map(a -> initialProjectedVariables.stream().filter(v -> rawQuotedIqFactory.createAttributeID(v.getName()).equals(a)).findAny()).flatMap(Optional::stream).collect(ImmutableCollectors.toSet());
        if (iriSafeVariables.isEmpty()) {
            return iqTreeBeforeIRISafeConstraints;
        }
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        VariableGenerator variableGenerator = coreSingletons.getCoreUtilsFactory().createVariableGenerator((Collection)iqTreeBeforeIRISafeConstraints.getKnownVariables());
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        InjectiveSubstitution renaming = (InjectiveSubstitution)iriSafeVariables.stream().collect(substitutionFactory.toFreshRenamingSubstitution(variableGenerator));
        IRISafenessDeclarationFunctionSymbol iriSafenessDeclarationFunctionSymbol = coreSingletons.getDBFunctionsymbolFactory().getIRISafenessDeclaration();
        Substitution substitution = (Substitution)iriSafeVariables.stream().collect(substitutionFactory.toSubstitution(v -> termFactory.getImmutableFunctionalTerm((FunctionSymbol)iriSafenessDeclarationFunctionSymbol, new ImmutableTerm[]{renaming.get(v)})));
        ConstructionNode newConstructionNode = iqFactory.createConstructionNode(initialProjectedVariables, substitution);
        return iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, iqTreeBeforeIRISafeConstraints.applyFreshRenaming(renaming)).normalizeForOptimization(variableGenerator);
    }

    protected void insertTransitiveFunctionalDependencies(ImmutableSet<FunctionalDependencyConstruct> previousDependencies, NamedRelationDefinition relation, CoreSingletons coreSingletons) throws AttributeNotFoundException, MetadataExtractionException {
        VariableGeneratorImpl uselessVariableGenerator = new VariableGeneratorImpl((Collection)ImmutableSet.of(), coreSingletons.getTermFactory());
        ImmutableMap var2Attr = (ImmutableMap)relation.getAttributes().stream().collect(ImmutableCollectors.toMap(attr -> uselessVariableGenerator.generateNewVariable(attr.getID().getName()), attr -> attr));
        ImmutableMap id2Var = (ImmutableMap)var2Attr.entrySet().stream().collect(ImmutableCollectors.toMap(entry -> ((Attribute)entry.getValue()).getID(), Map.Entry::getKey));
        if (previousDependencies.stream().anyMatch(fd -> fd.getDeterminants().stream().anyMatch(id -> !id2Var.containsKey(id)) || fd.getDeterminants().stream().anyMatch(id -> !id2Var.containsKey(id)))) {
            throw new MetadataExtractionException(String.format("Cannot find attribute for Functional Dependency of %s.", relation.getID()));
        }
        FunctionalDependencies allDependencies = (FunctionalDependencies)previousDependencies.stream().map(fd -> Maps.immutableEntry((Object)((ImmutableSet)fd.getDeterminants().stream().map(arg_0 -> ((ImmutableMap)id2Var).get(arg_0)).collect(ImmutableCollectors.toSet())), (Object)((ImmutableSet)fd.getDependents().stream().map(arg_0 -> ((ImmutableMap)id2Var).get(arg_0)).collect(ImmutableCollectors.toSet())))).collect(FunctionalDependencies.toFunctionalDependencies());
        for (Map.Entry entry2 : (ImmutableList)allDependencies.stream().collect(ImmutableCollectors.toList())) {
            this.addTransitiveDependency(relation, (ImmutableSet<Attribute>)((ImmutableSet)((ImmutableSet)entry2.getKey()).stream().map(arg_0 -> ((ImmutableMap)var2Attr).get(arg_0)).collect(ImmutableCollectors.toSet())), (Set)((ImmutableSet)entry2.getValue()).stream().map(arg_0 -> ((ImmutableMap)var2Attr).get(arg_0)).collect(ImmutableCollectors.toSet()));
        }
    }

    private void addTransitiveDependency(NamedRelationDefinition relation, ImmutableSet<Attribute> determinants, Set<Attribute> dependents) throws AttributeNotFoundException {
        FunctionalDependency.Builder builder = FunctionalDependency.defaultBuilder((NamedRelationDefinition)relation);
        for (Attribute determinant : determinants) {
            builder.addDeterminant(determinant.getID());
        }
        for (Attribute attribute : dependents) {
            builder.addDependent(attribute.getID());
        }
        builder.build();
    }

    protected static class IRISafeConstraints
    extends JsonOpenObject {
        public final @Nonnull List<String> added;

        @JsonCreator
        public IRISafeConstraints(@JsonProperty(value="added") List<String> added) {
            this.added = added;
        }
    }

    protected static class NonNullConstraints
    extends JsonOpenObject {
        public final @Nonnull List<String> added;

        @JsonCreator
        public NonNullConstraints(@JsonProperty(value="added") List<String> added) {
            this.added = added;
        }
    }

    public static class JSONLensDeserializer
    extends JsonDeserializer<JsonLens> {
        public JsonLens deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Class instanceClass;
            String type;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode node = (JsonNode)mapper.readTree(jp);
            switch (type = node.get("type").asText()) {
                case "BasicLens": 
                case "BasicViewDefinition": {
                    instanceClass = JsonBasicLens.class;
                    break;
                }
                case "SQLLens": 
                case "SQLViewDefinition": {
                    instanceClass = JsonSQLLens.class;
                    break;
                }
                case "JoinLens": 
                case "JoinViewDefinition": {
                    instanceClass = JsonJoinLens.class;
                    break;
                }
                case "FlattenLens": 
                case "FlattenedViewDefinition": {
                    instanceClass = JsonFlattenLens.class;
                    break;
                }
                case "UnionLens": {
                    instanceClass = JsonUnionLens.class;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type of lens: " + type);
                }
            }
            return (JsonLens)mapper.treeToValue((TreeNode)node, instanceClass);
        }
    }

    protected static class TemporaryLensPredicate
    extends AtomPredicateImpl {
        protected TemporaryLensPredicate(String name, ImmutableList<TermType> baseTypesForValidation) {
            super(name, baseTypesForValidation);
        }
    }

    public static class ForeignKeyPart
    extends JsonOpenObject {
        public final List<String> relation;
        public final List<String> columns;

        @JsonCreator
        public ForeignKeyPart(@JsonProperty(value="relation") List<String> relation, @JsonProperty(value="columns") List<String> columns) {
            this.relation = relation;
            this.columns = columns;
        }
    }

    protected static class AddForeignKey
    extends JsonOpenObject {
        public final @Nonnull String name;
        public final @Nonnull List<String> from;
        public final @Nonnull ForeignKeyPart to;

        public AddForeignKey(@JsonProperty(value="name") String name, @JsonProperty(value="from") List<String> from, @JsonProperty(value="to") ForeignKeyPart to) {
            this.name = name;
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddForeignKey that = (AddForeignKey)o;
            return this.from.equals(that.from) && this.to.equals(that.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }

    protected static class ForeignKeys
    extends JsonOpenObject {
        public final @Nonnull List<AddForeignKey> added;

        @JsonCreator
        public ForeignKeys(@JsonProperty(value="added") List<AddForeignKey> added) {
            this.added = added;
        }
    }

    protected static class AddFunctionalDependency
    extends JsonOpenObject {
        public final @Nonnull List<String> determinants;
        public final @Nonnull List<String> dependents;

        public AddFunctionalDependency(@JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="dependents") List<String> dependents) {
            this.determinants = determinants;
            this.dependents = dependents;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFunctionalDependency other = (AddFunctionalDependency)obj;
            return Objects.equals(ImmutableMap.of(this.determinants, this.dependents), ImmutableMap.of(other.determinants, other.dependents));
        }

        public int hashCode() {
            return Objects.hash(ImmutableMap.of(this.determinants, this.dependents));
        }
    }

    protected static class OtherFunctionalDependencies
    extends JsonOpenObject {
        public final @Nonnull List<AddFunctionalDependency> added;

        @JsonCreator
        public OtherFunctionalDependencies(@JsonProperty(value="added") List<AddFunctionalDependency> added) {
            this.added = added;
        }
    }

    protected static class AddUniqueConstraints
    extends JsonOpenObject {
        public final @Nonnull String name;
        public final @Nonnull List<String> determinants;
        public final Boolean isPrimaryKey;

        @JsonCreator
        public AddUniqueConstraints(@JsonProperty(value="name") String name, @JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="isPrimaryKey") Boolean isPrimaryKey) {
            this.name = name;
            this.determinants = determinants;
            this.isPrimaryKey = isPrimaryKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddUniqueConstraints other = (AddUniqueConstraints)obj;
            return Objects.equals(this.determinants, other.determinants);
        }

        public int hashCode() {
            return Objects.hash(this.determinants);
        }
    }

    protected static class UniqueConstraints
    extends JsonOpenObject {
        public final @Nonnull List<AddUniqueConstraints> added;

        @JsonCreator
        public UniqueConstraints(@JsonProperty(value="added") List<AddUniqueConstraints> added) {
            this.added = added;
        }
    }
}

