/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visit.impl.RelationExtractor;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonBasicOrJoinOrNestedLens
extends JsonLens {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonBasicOrJoinOrNestedLens.class);

    protected JsonBasicOrJoinOrNestedLens(List<String> name, @Nullable JsonLens.UniqueConstraints uniqueConstraints, @Nullable JsonLens.OtherFunctionalDependencies otherFunctionalDependencies, @Nullable JsonLens.ForeignKeys foreignKeys, @Nullable JsonLens.NonNullConstraints nonNullConstraints, @Nullable JsonLens.IRISafeConstraints iriSafeConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, iriSafeConstraints);
    }

    protected String normalizeAttributeName(String attributeName, QuotedIDFactory quotedIdFactory) {
        return quotedIdFactory.createAttributeID(attributeName).getName();
    }

    protected AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
        DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
        return new JsonLens.TemporaryLensPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> dbRootType).collect(ImmutableCollectors.toList())));
    }

    protected void insertUniqueConstraints(Lens relation, QuotedIDFactory idFactory, List<JsonLens.AddUniqueConstraints> addUniqueConstraints, ImmutableList<NamedRelationDefinition> baseRelations, CoreSingletons coreSingletons) throws MetadataExtractionException {
        List<JsonLens.AddUniqueConstraints> list = this.extractUniqueConstraints(relation, addUniqueConstraints, baseRelations, idFactory, coreSingletons);
        for (JsonLens.AddUniqueConstraints addUC : list) {
            if (addUC.isPrimaryKey != null && addUC.isPrimaryKey.booleanValue()) {
                LOGGER.warn("Primary key set in the view file for " + addUC.name);
            }
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)addUC.name);
            JsonMetadata.deserializeAttributeList(idFactory, addUC.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }
    }

    private List<JsonLens.AddUniqueConstraints> extractUniqueConstraints(Lens relation, List<JsonLens.AddUniqueConstraints> addUniqueConstraints, ImmutableList<NamedRelationDefinition> baseRelations, QuotedIDFactory idFactory, CoreSingletons coreSingletons) {
        ImmutableList addedConstraintsColumns = this.uniqueConstraints == null ? ImmutableList.of() : (ImmutableList)this.uniqueConstraints.added.stream().map(a -> a.determinants).flatMap(Collection::stream).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toList());
        ImmutableList<JsonLens.AddUniqueConstraints> inheritedConstraints = this.inferInheritedUniqueConstraints(relation, baseRelations, (ImmutableList<QuotedID>)addedConstraintsColumns, idFactory, coreSingletons);
        if (!addUniqueConstraints.stream().allMatch(new HashSet()::add)) {
            LOGGER.warn("Duplicate unique constraints found in the viewfile");
        }
        return Stream.concat(addUniqueConstraints.stream(), inheritedConstraints.stream()).distinct().collect(Collectors.toList());
    }

    protected ImmutableList<JsonLens.AddUniqueConstraints> inferInheritedUniqueConstraints(Lens relation, ImmutableList<NamedRelationDefinition> baseRelations, ImmutableList<QuotedID> addedConstraintsColumns, QuotedIDFactory idFactory, CoreSingletons coreSingletons) {
        IQ relationIQ = relation.getIQ();
        NotYetTypedEqualityTransformer eqTransformer = coreSingletons.getNotYetTypedEqualityTransformer();
        IQTree tree = eqTransformer.transform(relationIQ.getTree()).normalizeForOptimization(relationIQ.getVariableGenerator());
        ImmutableSet variableUniqueConstraints = tree.inferUniqueConstraints();
        DistinctVariableOnlyDataAtom projectedAtom = relationIQ.getProjectionAtom();
        ImmutableMap variableIds = (ImmutableMap)relation.getAttributes().stream().collect(ImmutableCollectors.toMap(a -> projectedAtom.getTerm(a.getIndex() - 1), Attribute::getID));
        return (ImmutableList)variableUniqueConstraints.stream().filter(vs -> !vs.isEmpty()).map(vs -> new JsonLens.AddUniqueConstraints(UUID.randomUUID().toString(), (List)vs.stream().map(v -> Optional.ofNullable((QuotedID)variableIds.get(v)).orElseThrow(() -> new MinorOntopInternalBugException("The variables of the unique constraints should be projected"))).map(QuotedID::getSQLRendering).collect(ImmutableCollectors.toList()), false)).collect(ImmutableCollectors.toList());
    }

    protected void insertFunctionalDependencies(NamedRelationDefinition relation, QuotedIDFactory idFactory, ImmutableSet<QuotedID> hiddenColumns, ImmutableSet<QuotedID> addedColumns, List<JsonLens.AddFunctionalDependency> addFunctionalDependencies, List<FunctionalDependencyConstruct> inferredFunctionalDependencies, ImmutableList<NamedRelationDefinition> baseRelations, CoreSingletons coreSingletons) throws MetadataExtractionException {
        Stream<FunctionalDependencyConstruct> inheritedFDConstructs = baseRelations.stream().map(RelationDefinition::getOtherFunctionalDependencies).flatMap(Collection::stream).filter(f -> this.canFDBeInherited((FunctionalDependency)f, hiddenColumns, addedColumns)).map(f -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)f.getDeterminants().stream().map(Attribute::getID).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)f.getDependents().stream().map(Attribute::getID).flatMap(d -> this.extractNewDependents((QuotedID)d, addedColumns, hiddenColumns)).collect(ImmutableCollectors.toSet()))));
        Stream<FunctionalDependencyConstruct> declaredFdDependencies = addFunctionalDependencies.stream().map(jsonFD -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.determinants.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.dependents.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet()))));
        ImmutableMultimap fdMultimap = (ImmutableMultimap)Stream.concat(Stream.concat(declaredFdDependencies, inheritedFDConstructs), inferredFunctionalDependencies.stream()).collect(ImmutableCollectors.toMultimap(FunctionalDependencyConstruct::getDeterminants, fd -> fd));
        ImmutableSet fdConstructs = (ImmutableSet)fdMultimap.asMap().values().stream().map(fds -> (FunctionalDependencyConstruct)fds.stream().reduce((f1, f2) -> f1.merge((FunctionalDependencyConstruct)f2).orElseThrow(() -> new MinorOntopInternalBugException("Should be mergeable as they are having the same determinants"))).get()).collect(ImmutableCollectors.toSet());
        try {
            this.insertTransitiveFunctionalDependencies((ImmutableSet<FunctionalDependencyConstruct>)fdConstructs, relation, coreSingletons);
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException(String.format("Cannot find attribute %s for Functional Dependency.", e.getAttributeID()));
        }
    }

    private Stream<QuotedID> extractNewDependents(QuotedID parentDependentId, ImmutableSet<QuotedID> addedColumns, ImmutableSet<QuotedID> hiddenColumns) {
        return this.isInherited(parentDependentId, addedColumns, hiddenColumns) ? Stream.of(parentDependentId) : Stream.empty();
    }

    private boolean canFDBeInherited(FunctionalDependency fd, ImmutableSet<QuotedID> hiddenColumns, ImmutableSet<QuotedID> addedColumns) {
        return fd.getDeterminants().stream().map(Attribute::getID).allMatch(d -> this.isInherited((QuotedID)d, addedColumns, hiddenColumns));
    }

    private boolean isInherited(QuotedID id, ImmutableSet<QuotedID> addedColumns, ImmutableSet<QuotedID> hiddenColumns) {
        return !addedColumns.contains((Object)id) && !hiddenColumns.contains((Object)id);
    }

    protected void insertForeignKeys(Lens relation, MetadataLookup lookup, List<JsonLens.AddForeignKey> addForeignKeys, ImmutableList<NamedRelationDefinition> baseRelations) throws MetadataExtractionException {
        ImmutableList<JsonLens.AddForeignKey> list = this.extractForeignKeys(relation, addForeignKeys, baseRelations);
        for (JsonLens.AddForeignKey fk : list) {
            this.insertForeignKey((NamedRelationDefinition)relation, lookup, fk);
        }
    }

    private ImmutableList<JsonLens.AddForeignKey> extractForeignKeys(Lens relation, List<JsonLens.AddForeignKey> addForeignKeys, ImmutableList<NamedRelationDefinition> baseRelations) {
        return (ImmutableList)Stream.concat(addForeignKeys.stream(), this.inferForeignKeys(relation, baseRelations)).distinct().collect(ImmutableCollectors.toList());
    }

    protected Stream<JsonLens.AddForeignKey> inferForeignKeys(Lens relation, ImmutableList<NamedRelationDefinition> baseRelations) {
        return baseRelations.stream().flatMap(p -> this.inferForeignKeysFromParent(relation, (NamedRelationDefinition)p));
    }

    protected Stream<JsonLens.AddForeignKey> inferForeignKeysFromParent(Lens relation, NamedRelationDefinition baseRelation) {
        return baseRelation.getForeignKeys().stream().flatMap(fk -> this.getDerivedFromParentAttributes(relation, (ImmutableList<Attribute>)((ImmutableList)fk.getComponents().stream().map(ForeignKeyConstraint.Component::getAttribute).collect(ImmutableCollectors.toList()))).stream().map(as -> new JsonLens.AddForeignKey(UUID.randomUUID().toString(), JsonMetadata.serializeAttributeList(as.stream()), new JsonLens.ForeignKeyPart((List<String>)JsonMetadata.serializeRelationID(fk.getReferencedRelation().getID()), JsonMetadata.serializeAttributeList(fk.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute))))));
    }

    protected void insertForeignKey(NamedRelationDefinition relation, MetadataLookup lookup, JsonLens.AddForeignKey addForeignKey) throws MetadataExtractionException {
        NamedRelationDefinition targetRelation;
        QuotedIDFactory idFactory = lookup.getQuotedIDFactory();
        RelationID targetRelationId = JsonMetadata.deserializeRelationID(idFactory, addForeignKey.to.relation);
        try {
            targetRelation = lookup.getRelation(targetRelationId);
        }
        catch (MetadataExtractionException e) {
            LOGGER.info("Cannot find relation {} for FK {}", (Object)targetRelationId, (Object)addForeignKey.name);
            return;
        }
        int columnCount = addForeignKey.to.columns.size();
        if (addForeignKey.from.size() != columnCount) {
            throw new MetadataExtractionException("Not the same number of from and to columns in FK definition");
        }
        try {
            ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)addForeignKey.name, (NamedRelationDefinition)relation, (NamedRelationDefinition)targetRelation);
            for (int i = 0; i < columnCount; ++i) {
                builder.add(idFactory.createAttributeID(addForeignKey.from.get(i)), idFactory.createAttributeID(addForeignKey.to.columns.get(i)));
            }
            builder.build();
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
    }

    protected ImmutableList<ImmutableList<Attribute>> getDerivedFromParentAttributes(Lens lens, ImmutableList<Attribute> parentAttributes) {
        RelationDefinition parentRelation;
        IQ viewIQ = lens.getIQ();
        ImmutableList parentRelations = (ImmutableList)parentAttributes.stream().map(Attribute::getRelation).distinct().collect(ImmutableCollectors.toList());
        switch (parentRelations.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                parentRelation = (RelationDefinition)parentRelations.get(0);
                break;
            }
            default: {
                throw new MinorOntopInternalBugException("Was expecting all the attributes to come from the same parent");
            }
        }
        Optional<ExtensionalDataNode> optionalParentNode = ((Stream)viewIQ.getTree().acceptVisitor((IQVisitor)new RelationExtractor())).filter(n -> n.getRelationDefinition().equals(parentRelation)).findAny();
        if (!optionalParentNode.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableMap parentNodeArgumentMap = optionalParentNode.get().getArgumentMap();
        ImmutableList.Builder parentVariableBuilder = ImmutableList.builder();
        for (Attribute parentAttribute : parentAttributes) {
            ImmutableTerm argument = (ImmutableTerm)parentNodeArgumentMap.get((Object)(parentAttribute.getIndex() - 1));
            if (!(argument instanceof Variable)) {
                return ImmutableList.of();
            }
            parentVariableBuilder.add((Object)((Variable)argument));
        }
        ImmutableList parentVariables = parentVariableBuilder.build();
        ImmutableList projectedVariables = viewIQ.getProjectionAtom().getArguments();
        ImmutableList parentVariableIndexes = (ImmutableList)parentVariables.stream().map(arg_0 -> ((ImmutableList)projectedVariables).indexOf(arg_0)).collect(ImmutableCollectors.toList());
        if (parentVariableIndexes.stream().anyMatch(i -> i < 0)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)((ImmutableList)parentVariableIndexes.stream().map(i -> lens.getAttribute(i + 1)).collect(ImmutableCollectors.toList())));
    }
}

