/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.LensImpl;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.ConflictingVariableInJoinViewException;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicOrJoinOrNestedLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.sqlparser.ExpressionParser;
import it.unibz.inf.ontop.spec.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonBasicOrJoinLens
extends JsonBasicOrJoinOrNestedLens {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonBasicOrJoinLens.class);
    public final @Nonnull Columns columns;
    public final @Nonnull String filterExpression;

    protected JsonBasicOrJoinLens(List<String> name, @Nullable JsonLens.UniqueConstraints uniqueConstraints, @Nullable JsonLens.OtherFunctionalDependencies otherFunctionalDependencies, @Nullable JsonLens.ForeignKeys foreignKeys, @Nullable JsonLens.NonNullConstraints nonNullConstraints, @Nullable JsonLens.IRISafeConstraints iriSafeConstraints, @Nullable Columns columns, @Nonnull String filterExpression) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, iriSafeConstraints);
        this.columns = columns == null ? new Columns(new ArrayList<AddColumns>(), new ArrayList<String>()) : columns;
        this.filterExpression = filterExpression;
    }

    @Override
    public Lens createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        ImmutableList<ParentDefinition> parentDefinitions = this.extractParentDefinitions(dbParameters, parentCacheMetadataLookup);
        Integer maxParentLevel = parentDefinitions.stream().map(p -> p.relation).filter(r -> r instanceof Lens).map(r -> (Lens)r).map(Lens::getLevel).reduce(0, Math::max, Math::max);
        QuotedIDFactory idFactory = dbParameters.getQuotedIDFactory();
        RelationID relationId = idFactory.createRelationID(this.name.toArray(new String[0]));
        IQ iq = this.createIQ(relationId, parentDefinitions, dbParameters);
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new LensImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, maxParentLevel + 1, dbParameters.getCoreSingletons());
    }

    @Override
    public void insertIntegrityConstraints(Lens relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        this.insertUniqueConstraints(relation, idFactory, this.uniqueConstraints != null ? this.uniqueConstraints.added : ImmutableList.of(), baseRelations, coreSingletons);
        ImmutableSet hiddenColumns = (ImmutableSet)this.columns.hidden.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        ImmutableSet addedColumns = (ImmutableSet)this.columns.added.stream().map(a -> a.name).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        this.insertFunctionalDependencies((NamedRelationDefinition)relation, idFactory, (ImmutableSet<QuotedID>)hiddenColumns, (ImmutableSet<QuotedID>)addedColumns, this.otherFunctionalDependencies != null ? this.otherFunctionalDependencies.added : ImmutableList.of(), (List<FunctionalDependencyConstruct>)ImmutableList.of(), baseRelations, coreSingletons);
        this.insertForeignKeys(relation, metadataLookupForFK, this.foreignKeys != null ? this.foreignKeys.added : ImmutableList.of(), baseRelations);
    }

    private IQ createIQ(RelationID relationId, ImmutableList<ParentDefinition> parentDefinitions, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = dbParameters.getQuotedIDFactory();
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        AtomFactory atomFactory = coreSingletons.getAtomFactory();
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        ImmutableSet addedVariables = (ImmutableSet)this.columns.added.stream().map(a -> this.getVariable(a.name, idFactory, termFactory)).collect(ImmutableCollectors.toSet());
        VariableGenerator variableGenerator = coreSingletons.getCoreUtilsFactory().createVariableGenerator((Collection)addedVariables);
        parentDefinitions.forEach(p -> p.createAttributeVariableMap(variableGenerator));
        RAExpressionAttributes parentAttributeMap = this.extractParentAttributeMap(parentDefinitions, idFactory);
        Substitution substitution = substitutionFactory.getSubstitutionThrowsExceptions(this.columns.added, a -> this.getVariable(a.name, idFactory, termFactory), a -> this.extractExpression((AddColumns)a, parentAttributeMap, idFactory, coreSingletons));
        ConstructionSubstitutionNormalizer substitutionNormalizer = dbParameters.getCoreSingletons().getConstructionSubstitutionNormalizer();
        ImmutableSet hiddenVariables = (ImmutableSet)this.columns.hidden.stream().map(a -> this.getVariable((String)a, idFactory, termFactory)).collect(ImmutableCollectors.toSet());
        ImmutableList<Variable> projectedVariables = this.extractRelationVariables((ImmutableSet<Variable>)addedVariables, (ImmutableSet<Variable>)hiddenVariables, parentDefinitions, termFactory);
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = substitutionNormalizer.normalizeSubstitution(substitution, ImmutableSet.copyOf(projectedVariables));
        IQTree parentTree = this.createParentTree((Collection<ParentDefinition>)parentDefinitions, iqFactory);
        ConstructionNode constructionNode = normalization.generateTopConstructionNode().orElseGet(() -> iqFactory.createConstructionNode(ImmutableSet.copyOf((Collection)projectedVariables)));
        ImmutableList<ImmutableExpression> filterConditions = this.extractFilter(parentAttributeMap, idFactory, coreSingletons);
        IQTree updatedParentDataNode = filterConditions.stream().reduce((x$0, xva$1) -> termFactory.getConjunction(x$0, new ImmutableExpression[]{xva$1})).map(arg_0 -> ((IntermediateQueryFactory)iqFactory).createFilterNode(arg_0)).map(f -> normalization.updateChild((IQTree)iqFactory.createUnaryIQTree((UnaryOperatorNode)f, parentTree), variableGenerator)).orElse(normalization.updateChild(parentTree, variableGenerator));
        UnaryIQTree iqTreeBeforeIRISafeConstraints = iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, updatedParentDataNode);
        IQTree iqTree = this.addIRISafeConstraints((IQTree)iqTreeBeforeIRISafeConstraints, dbParameters);
        AtomPredicate tmpPredicate = this.createTemporaryPredicate(relationId, projectedVariables.size(), coreSingletons);
        DistinctVariableOnlyDataAtom projectionAtom = atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, projectedVariables);
        return iqFactory.createIQ(projectionAtom, iqTree).normalizeForOptimization();
    }

    protected abstract ImmutableList<ParentDefinition> extractParentDefinitions(DBParameters var1, MetadataLookup var2) throws MetadataExtractionException;

    private IQTree createParentTree(Collection<ParentDefinition> parentArgumentTable, IntermediateQueryFactory iqFactory) throws MetadataExtractionException {
        ImmutableList parents = (ImmutableList)parentArgumentTable.stream().map(p -> iqFactory.createExtensionalDataNode((RelationDefinition)p.relation, p.getArgumentMap())).collect(ImmutableCollectors.toList());
        switch (parents.size()) {
            case 0: {
                throw new MetadataExtractionException("At least one base relation was expected");
            }
            case 1: {
                return (IQTree)parents.get(0);
            }
        }
        return iqFactory.createNaryIQTree((NaryOperatorNode)iqFactory.createInnerJoinNode(), parents);
    }

    private ImmutableList<Variable> extractRelationVariables(ImmutableSet<Variable> addedVariables, ImmutableSet<Variable> hiddenVariables, ImmutableList<ParentDefinition> parentDefinitions, TermFactory termFactory) {
        Stream<Variable> inheritedVariableStream = parentDefinitions.stream().flatMap(p -> p.relation.getAttributes().stream().map(p::getPrefixedAttributeName)).map(arg_0 -> ((TermFactory)termFactory).getVariable(arg_0)).filter(v -> !hiddenVariables.contains(v)).filter(v -> !addedVariables.contains(v));
        return (ImmutableList)Stream.concat(addedVariables.stream(), inheritedVariableStream).collect(ImmutableCollectors.toList());
    }

    private RAExpressionAttributes extractParentAttributeMap(ImmutableList<ParentDefinition> parentDefinitionMap, QuotedIDFactory quotedIdFactory) throws MetadataExtractionException {
        RawQuotedIDFactory idFactory = new RawQuotedIDFactory(quotedIdFactory);
        ImmutableMap map = ((ImmutableMultimap)parentDefinitionMap.stream().flatMap(p -> p.attributeVariableMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)idFactory.createAttributeID(p.getPrefixedAttributeName((Attribute)e.getKey())), (Object)((Variable)e.getValue())))).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableSet conflictingAttributeIds = (ImmutableSet)map.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        if (!conflictingAttributeIds.isEmpty()) {
            throw new ConflictingVariableInJoinViewException((ImmutableSet<QuotedID>)conflictingAttributeIds);
        }
        return new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)map.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, (QuotedID)e.getKey()), e -> (ImmutableTerm)((Collection)e.getValue()).iterator().next()))), null);
    }

    private ImmutableTerm extractExpression(AddColumns column, RAExpressionAttributes parentAttributeMap, QuotedIDFactory quotedIdFactory, CoreSingletons coreSingletons) throws MetadataExtractionException {
        try {
            ExpressionParser parser = new ExpressionParser(quotedIdFactory, coreSingletons);
            String sqlQuery = "SELECT " + column.expression + " FROM fakeTable";
            Select statement = JSqlParserTools.parse(sqlQuery, !quotedIdFactory.supportsSquareBracketQuotation());
            SelectItem si = (SelectItem)((PlainSelect)statement.getSelectBody()).getSelectItems().get(0);
            Expression exp = ((SelectExpressionItem)si).getExpression();
            return parser.parseTerm(exp, parentAttributeMap);
        }
        catch (Exception e) {
            throw new MetadataExtractionException("Unsupported expression for " + column.name + " in " + this.name + ":\n" + e, e);
        }
    }

    private ImmutableList<ImmutableExpression> extractFilter(RAExpressionAttributes parentAttributeMap, QuotedIDFactory quotedIdFactory, CoreSingletons coreSingletons) throws MetadataExtractionException {
        if (this.filterExpression == null || this.filterExpression.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            String sqlQuery = "SELECT * FROM fakeTable WHERE " + this.filterExpression;
            ExpressionParser parser = new ExpressionParser(quotedIdFactory, coreSingletons);
            Select statement = JSqlParserTools.parse(sqlQuery, !quotedIdFactory.supportsSquareBracketQuotation());
            PlainSelect plainSelect = (PlainSelect)statement.getSelectBody();
            return plainSelect.getWhere() == null ? ImmutableList.of() : parser.parseBooleanExpression(plainSelect.getWhere(), parentAttributeMap);
        }
        catch (InvalidQueryException | JSQLParserException e) {
            throw new MetadataExtractionException("Unsupported filter expression for :\n" + (Exception)e);
        }
    }

    protected Variable getVariable(String attributeName, QuotedIDFactory quotedIdFactory, TermFactory termFactory) {
        return termFactory.getVariable(quotedIdFactory.createAttributeID(attributeName).getName());
    }

    protected static class AddColumns
    extends JsonOpenObject {
        public final @Nonnull String name;
        public final @Nonnull String expression;

        @JsonCreator
        public AddColumns(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression) {
            this.name = name;
            this.expression = expression;
        }
    }

    protected static class Columns
    extends JsonOpenObject {
        public final @Nonnull List<AddColumns> added;
        public final @Nonnull List<String> hidden;

        @JsonCreator
        public Columns(@JsonProperty(value="added") List<AddColumns> added, @JsonProperty(value="hidden") List<String> hidden) {
            this.added = added;
            this.hidden = hidden;
        }
    }

    protected static class ParentDefinition {
        private final String prefix;
        private final NamedRelationDefinition relation;
        private @Nullable ImmutableMap<Attribute, Variable> attributeVariableMap;

        public ParentDefinition(NamedRelationDefinition relation, String prefix) {
            this.relation = relation;
            this.prefix = prefix;
        }

        public String getPrefixedAttributeName(Attribute a) {
            return this.prefix + a.getID().getName();
        }

        public void createAttributeVariableMap(VariableGenerator variableGenerator) {
            this.attributeVariableMap = (ImmutableMap)this.relation.getAttributes().stream().collect(ImmutableCollectors.toMap(a -> a, a -> variableGenerator.generateNewVariable(this.getPrefixedAttributeName((Attribute)a))));
        }

        public ImmutableMap<Integer, Variable> getArgumentMap() {
            return (ImmutableMap)this.attributeVariableMap.entrySet().stream().collect(ImmutableCollectors.toMap(ae -> ((Attribute)ae.getKey()).getIndex() - 1, Map.Entry::getValue));
        }
    }
}

