/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicOrJoinLens;
import it.unibz.inf.ontop.dbschema.impl.json.JsonLens;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@JsonDeserialize(as=JsonBasicLens.class)
public class JsonBasicLens
extends JsonBasicOrJoinLens {
    public final @Nonnull List<String> baseRelation;

    @JsonCreator
    public JsonBasicLens(@JsonProperty(value="columns") JsonBasicOrJoinLens.Columns columns, @JsonProperty(value="name") List<String> name, @JsonProperty(value="baseRelation") List<String> baseRelation, @JsonProperty(value="filterExpression") String filterExpression, @JsonProperty(value="uniqueConstraints") JsonLens.UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") JsonLens.OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") JsonLens.ForeignKeys foreignKeys, @JsonProperty(value="nonNullConstraints") JsonLens.NonNullConstraints nonNullConstraints, @JsonProperty(value="iriSafeConstraints") JsonLens.IRISafeConstraints iriSafeConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, iriSafeConstraints, columns, filterExpression);
        this.baseRelation = baseRelation;
    }

    @Override
    protected ImmutableList<JsonBasicOrJoinLens.ParentDefinition> extractParentDefinitions(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        NamedRelationDefinition parentDefinition = parentCacheMetadataLookup.getRelation(quotedIDFactory.createRelationID(this.baseRelation.toArray(new String[0])));
        return ImmutableList.of((Object)new JsonBasicOrJoinLens.ParentDefinition(parentDefinition, ""));
    }

    @Override
    public ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(Lens lens, ImmutableList<Attribute> parentAttributes) {
        if (this.filterExpression != null && !this.filterExpression.isEmpty()) {
            return ImmutableList.of();
        }
        return this.getDerivedFromParentAttributes(lens, parentAttributes);
    }

    @Override
    public boolean propagateUniqueConstraintsUp(Lens relation, ImmutableList<NamedRelationDefinition> parents, QuotedIDFactory idFactory) throws MetadataExtractionException {
        if (this.filterExpression != null && !this.filterExpression.isEmpty()) {
            return false;
        }
        ImmutableList ucs = relation.getUniqueConstraints();
        ImmutableList propagableConstraints = (ImmutableList)ucs.stream().filter(u -> this.hasNoDeterminantOverridden((UniqueConstraint)u, idFactory)).filter(u -> this.isUcNotInParent((UniqueConstraint)u, (NamedRelationDefinition)parents.get(0))).collect(ImmutableCollectors.toList());
        if (propagableConstraints.isEmpty()) {
            return false;
        }
        for (UniqueConstraint uc : propagableConstraints) {
            try {
                FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)((NamedRelationDefinition)parents.get(0)), (String)uc.getName());
                for (Attribute attribute : uc.getDeterminants()) {
                    builder.addDeterminant(attribute.getID());
                }
                builder.build();
            }
            catch (AttributeNotFoundException e) {
                throw new MetadataExtractionException((Exception)((Object)e));
            }
        }
        return true;
    }

    private boolean hasNoAttributeSetOverridden(ImmutableSet<Attribute> attributes, QuotedIDFactory idFactory) {
        return attributes.stream().noneMatch(a -> this.columns.added.stream().anyMatch(c -> a.getID().equals(idFactory.createAttributeID(c.name))));
    }

    private boolean hasNoDeterminantOverridden(UniqueConstraint uc, QuotedIDFactory idFactory) {
        return this.hasNoAttributeSetOverridden((ImmutableSet<Attribute>)uc.getDeterminants(), idFactory);
    }

    private boolean isUcNotInParent(UniqueConstraint uc, NamedRelationDefinition parent) {
        return parent.getUniqueConstraints().stream().noneMatch(u -> this.ucEquals(uc, (UniqueConstraint)u));
    }

    private boolean ucEquals(UniqueConstraint uc1, UniqueConstraint uc2) {
        ImmutableList determinants = (ImmutableList)Stream.of(uc1, uc2).map(uc -> (ImmutableSet)uc.getDeterminants().stream().map(Attribute::getID).collect(ImmutableCollectors.toSet())).collect(ImmutableCollectors.toList());
        return ((ImmutableSet)determinants.get(0)).equals(determinants.get(1));
    }

    @Override
    public boolean propagateForeignKeyConstraintsUp(Lens relation, ImmutableList<NamedRelationDefinition> parents, QuotedIDFactory idFactory) throws MetadataExtractionException {
        ImmutableList fks = relation.getForeignKeys();
        ImmutableList propagableConstraints = (ImmutableList)fks.stream().filter(fk -> this.hasNoAttributeSetOverridden((ImmutableSet<Attribute>)((ImmutableSet)fk.getComponents().stream().map(ForeignKeyConstraint.Component::getAttribute).collect(ImmutableCollectors.toSet())), idFactory)).filter(fk -> this.isFkNotInParent((ForeignKeyConstraint)fk, (NamedRelationDefinition)parents.get(0))).filter(fk -> fk.getReferencedRelation() != parents.get(0)).collect(ImmutableCollectors.toList());
        if (propagableConstraints.isEmpty()) {
            return false;
        }
        for (ForeignKeyConstraint fk2 : propagableConstraints) {
            try {
                ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)fk2.getName(), (NamedRelationDefinition)((NamedRelationDefinition)parents.get(0)), (NamedRelationDefinition)fk2.getReferencedRelation());
                for (ForeignKeyConstraint.Component component : fk2.getComponents()) {
                    builder.add(component.getAttribute().getID(), component.getReferencedAttribute().getID());
                }
                builder.build();
            }
            catch (AttributeNotFoundException e) {
                throw new MetadataExtractionException((Exception)((Object)e));
            }
        }
        return true;
    }

    private boolean isFkNotInParent(ForeignKeyConstraint fk, NamedRelationDefinition parent) {
        return parent.getForeignKeys().stream().noneMatch(f -> this.fkEquals((ForeignKeyConstraint)f, fk));
    }

    private boolean fkEquals(ForeignKeyConstraint fk1, ForeignKeyConstraint fk2) {
        return Optional.of(fk1).filter(f -> f.getReferencedRelation().equals(fk2.getReferencedRelation())).filter(f -> f.getComponents().stream().allMatch(c1 -> fk2.getComponents().stream().anyMatch(c2 -> c1.getAttribute().getID().equals(c2.getAttribute().getID()) && c1.getReferencedAttribute().equals(c2.getReferencedAttribute())))).isPresent();
    }
}

