/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import it.unibz.inf.ontop.dbschema.impl.SQLServerQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.Nullable;

public class SQLServerDBMetadataProvider
extends AbstractDBMetadataProvider {
    protected static final int SCHEMA_INDEX = 1;
    protected static final int CATALOG_INDEX = 2;
    private final QuotedID defaultCatalog;
    private final Optional<QuotedID> defaultSchema;
    private static final ImmutableSet<String> IGNORED_SCHEMAS = ImmutableSet.of((Object)"sys", (Object)"INFORMATION_SCHEMA");

    @AssistedInject
    SQLServerDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new SQLServerQuotedIDFactory(), coreSingletons);
        try {
            String defaultCatalogString = connection.getCatalog();
            String defaultSchemaString = connection.getSchema();
            if (defaultCatalogString == null) {
                throw new MetadataExtractionException("Unable to obtain the default catalog: make sure the connection URL is complete: " + defaultCatalogString + " " + defaultSchemaString);
            }
            RelationID id = this.rawIdFactory.createRelationID(new String[]{defaultCatalogString, defaultSchemaString, "DUMMY"});
            this.defaultCatalog = (QuotedID)id.getComponents().get(defaultSchemaString == null ? 1 : 2);
            this.defaultSchema = defaultSchemaString == null ? Optional.empty() : Optional.of((QuotedID)id.getComponents().get(1));
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    @Override
    protected boolean isRelationExcluded(RelationID id) {
        return IGNORED_SCHEMAS.contains((Object)this.getRelationSchema(id));
    }

    @Override
    protected @Nullable String escapeRelationIdComponentPattern(@Nullable String s) {
        return s;
    }

    @Override
    protected String makeQueryMinimizeResultSet(String query) {
        return String.format("SELECT * FROM (%s) subQ ORDER BY (SELECT NULL) OFFSET 0 ROWS FETCH NEXT 1 ROWS ONLY", query);
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID id) throws MetadataExtractionException {
        switch (id.getComponents().size()) {
            case 2: {
                return new RelationIDImpl(ImmutableList.of((Object)((QuotedID)id.getComponents().get(0)), (Object)((QuotedID)id.getComponents().get(1)), (Object)this.defaultCatalog));
            }
            case 1: {
                return new RelationIDImpl(ImmutableList.of((Object)((QuotedID)id.getComponents().get(0)), (Object)this.defaultSchema.orElseThrow(() -> new MetadataExtractionException("There is no default schema for " + id)), (Object)this.defaultCatalog));
            }
        }
        return id;
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        if (this.defaultCatalog.equals(id.getComponents().get(2))) {
            RelationIDImpl schemaTableId = new RelationIDImpl(id.getComponents().subList(0, 2));
            if (this.defaultSchema.filter(d -> d.equals(id.getComponents().get(1))).isPresent()) {
                return ImmutableList.of((Object)id.getTableOnlyID(), (Object)schemaTableId, (Object)id);
            }
            return ImmutableList.of((Object)schemaTableId, (Object)id);
        }
        return ImmutableList.of((Object)id);
    }

    @Override
    protected String getRelationCatalog(RelationID id) {
        return ((QuotedID)id.getComponents().get(2)).getName();
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return ((QuotedID)id.getComponents().get(1)).getName();
    }

    @Override
    protected String getRelationName(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).getName();
    }

    @Override
    protected RelationID getRelationID(ResultSet rs, String catalogNameColumn, String schemaNameColumn, String tableNameColumn) throws SQLException {
        return this.rawIdFactory.createRelationID(new String[]{rs.getString(catalogNameColumn), rs.getString(schemaNameColumn), rs.getString(tableNameColumn)});
    }
}

