/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DefaultSchemaDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.PostgreSQLQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PostgreSQLDBMetadataProvider
extends DefaultSchemaDBMetadataProvider {
    private static final ImmutableList<String> IGNORED_SCHEMAS = ImmutableList.of((Object)"_timescaledb_cache", (Object)"_timescaledb_catalog", (Object)"_timescaledb_internal", (Object)"_timescaledb_config");

    @AssistedInject
    PostgreSQLDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new PostgreSQLQuotedIDFactory(), coreSingletons);
    }

    @Override
    protected ResultSet getRelationIDsResultSet() throws SQLException {
        String[] stringArray;
        if (this.getSettings().exposeSystemTables()) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "TABLE";
            stringArray2[1] = "VIEW";
            stringArray2[2] = "MATERIALIZED VIEW";
            stringArray2[3] = "SYSTEM TABLE";
            stringArray2[4] = "SYSTEM VIEW";
            stringArray = stringArray2;
            stringArray2[5] = "TEMPORARY TABLE";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "TABLE";
            stringArray3[1] = "VIEW";
            stringArray = stringArray3;
            stringArray3[2] = "MATERIALIZED VIEW";
        }
        return this.metadata.getTables(null, null, null, stringArray);
    }

    @Override
    protected boolean isRelationExcluded(RelationID id) {
        return IGNORED_SCHEMAS.contains((Object)this.getRelationSchema(id));
    }
}

