/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchDriver;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchMappingGenerator;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchPlugin;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchRetrieve;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.plugin.externalsync.util.ValuesUtil;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ServerErrorException;
import com.ontotext.trree.sdk.Statements;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class ElasticsearchStore
extends AbstractExternalStore<Map<String, Object>> {
    static final String GEO_POINT_TYPE = "geo_point";
    static final String GEO_POINT_LAT = "lat";
    static final String GEO_POINT_LON = "lon";
    private ElasticsearchDriver driver;
    private ElasticsearchMappingGenerator mappingGenerator;
    private boolean hasNestedObjects;
    private boolean manageIndex;

    private ElasticsearchStore(String storeName, Options storeOptions, boolean wasJustCreated, long initialFingerprint, ElasticsearchPlugin elasticsearchPlugin, PluginConnection pluginConnection, Entities entities) {
        super(storeName, storeOptions, wasJustCreated, initialFingerprint, (ExternalSyncPlugin)elasticsearchPlugin, pluginConnection, entities);
        Boolean manageIndex = (Boolean)this.options.getValue(ElasticsearchPlugin.MANAGE_INDEX);
        assert (manageIndex != null);
        this.manageIndex = manageIndex;
    }

    static ExternalStore open(String storeName, Options storeOptions, ElasticsearchPlugin elasticsearchPlugin, PluginConnection pluginConnection) {
        return new ElasticsearchStore(storeName, storeOptions, false, 0L, elasticsearchPlugin, pluginConnection, pluginConnection.getEntities());
    }

    public static ExternalStore create(String storeName, Options options, ElasticsearchPlugin elasticsearchPlugin, PluginConnection pluginConnection, Entities entitiesForCreation) {
        ElasticsearchStore elasticsearchStore = new ElasticsearchStore(storeName, options, true, 0L, elasticsearchPlugin, pluginConnection, entitiesForCreation);
        elasticsearchStore.createIndex(true);
        return elasticsearchStore;
    }

    protected void createIndex(boolean cleanupAfterFailure) {
        try {
            this.init();
            if (this.isTestingTransaction()) {
                boolean indexExists = this.driver.indexExists();
                if (!this.manageIndex) {
                    if (!indexExists) {
                        throw new ConnectorUserException("Option manageIndex is false but the index " + this.driver.getIndexName() + " does not exist.");
                    }
                } else if (indexExists) {
                    if (cleanupAfterFailure) {
                        this.manageIndex = false;
                    }
                    throw new ConnectorUserException("Option manageIndex is true but the index " + this.driver.getIndexName() + " already exists.");
                }
            }
            this.driver.createIndex();
        }
        catch (Exception e) {
            if (cleanupAfterFailure) {
                try {
                    this.remove(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof ConnectorException) {
                throw e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteEntity(long subject, Value subjectValue) {
        this.driver.delete(EntitiesUtil.valueToString((Value)subjectValue));
    }

    protected boolean syncEntity(long subject, long predicate, long context, SyncDocument<Map<String, Object>> syncDoc, List<Property> propertiesToSync, Entities entities, Statements statements, boolean skip) {
        try {
            boolean anyProperty = this.syncEntityToDocument(syncDoc, subject, predicate, context, propertiesToSync, entities, statements);
            if (anyProperty && this.convertSyncDocumentToNativeDocument(syncDoc, propertiesToSync)) {
                if (!skip) {
                    this.mappingGenerator.putNewMappingsAsNeeded();
                    this.driver.index((Map)syncDoc.nativeDocument, EntitiesUtil.valueToString((Value)entities.get(subject)));
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new ServerErrorException("Couldn't index entity " + String.valueOf(entities.get(subject)), (Throwable)e);
        }
    }

    protected boolean writePropertyValueToNativeDocument(Map<String, Object> doc, Property property, String fieldName, Value value) {
        try {
            Object objValue;
            String type = this.mappingGenerator.generateFieldAsNeeded(fieldName, value, property);
            try {
                switch (type) {
                    case "byte": {
                        objValue = this.asLiteral(value).byteValue();
                        break;
                    }
                    case "long": {
                        objValue = this.asLiteral(value).longValue();
                        break;
                    }
                    case "integer": {
                        objValue = this.asLiteral(value).intValue();
                        break;
                    }
                    case "double": {
                        objValue = this.asLiteral(value).doubleValue();
                        break;
                    }
                    case "float": {
                        objValue = Float.valueOf(this.asLiteral(value).floatValue());
                        break;
                    }
                    case "boolean": {
                        objValue = this.asLiteral(value).booleanValue();
                        break;
                    }
                    case "date": {
                        objValue = EntitiesUtil.valueToString((Value)this.asLiteral(value));
                        IRI xsdType = property.getXsdType();
                        if (xsdType == null && !ValuesUtil.INSTANCE.isSupportedType(xsdType = this.asLiteral(value).getDatatype())) break;
                        objValue = ValuesUtil.INSTANCE.xsdTemporalAsISO((String)objValue, xsdType);
                        break;
                    }
                    default: {
                        objValue = EntitiesUtil.valueToString((Value)value);
                    }
                }
            }
            catch (RuntimeException e) {
                if (property.isIgnoreInvalidValues()) {
                    this.notifyIgnoreInvalidValue(fieldName, type, value);
                    return false;
                }
                throw e;
            }
            this.setFieldValue(property, doc, fieldName, objValue);
        }
        catch (IOException ex) {
            throw new ServerErrorException("Couldn't index " + fieldName + " with value " + String.valueOf(value), (Throwable)ex);
        }
        this.logger.debug("[{}] Indexing: '{}' = '{}'", new Object[]{this.name, fieldName, value});
        return true;
    }

    protected void addNativeNestedDocument(Map<String, Object> doc, Property property, Map<String, Object> nestedDoc) {
        if (GEO_POINT_TYPE.equals(property.getNativeType())) {
            Object lat = nestedDoc.get(GEO_POINT_LAT);
            Object lon = nestedDoc.get(GEO_POINT_LON);
            if (lat == null || lon == null || lat instanceof List || lon instanceof List) {
                return;
            }
        }
        this.setFieldValue(property, doc, property.getFieldNameWithoutSuffix(), nestedDoc);
    }

    protected Map<String, Object> newNativeDocument() {
        return new HashMap<String, Object>();
    }

    private void setFieldValue(Property property, Map<String, Object> doc, String key, Object value) {
        if (property.isArray()) {
            if (property.isMultivalued()) {
                ArrayList<Object> values = (ArrayList<Object>)doc.get(key);
                if (values == null) {
                    values = new ArrayList<Object>(2);
                    doc.put(key, values);
                }
                values.add(value);
            } else {
                doc.put(key, Collections.singletonList(value));
            }
        } else if (property.isMultivalued()) {
            Object oldValue = doc.get(key);
            if (oldValue == null) {
                doc.put(key, value);
            } else if (oldValue instanceof List) {
                List values = (List)oldValue;
                values.add(value);
            } else {
                ArrayList<Object> replacedValue = new ArrayList<Object>(2);
                replacedValue.add(oldValue);
                replacedValue.add(value);
                doc.put(key, replacedValue);
            }
        } else {
            doc.put(key, value);
        }
    }

    protected boolean isValidFieldNameImplementation(String fieldName, boolean isTopField) {
        return true;
    }

    public void drop(boolean force) throws Exception {
        block8: {
            block7: {
                if (this.manageIndex) {
                    try {
                        this.init();
                    }
                    catch (Exception e) {
                        if (force) break block7;
                        throw e;
                    }
                }
            }
            if (this.manageIndex && this.driver != null) {
                try {
                    if (this.driver.indexExists()) {
                        this.driver.dropIndex();
                    }
                }
                catch (Exception e) {
                    if (force) break block8;
                    throw e;
                }
            }
        }
        super.drop(force);
    }

    public ExternalRetrieve createRetrieve(MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        this.init();
        return new ElasticsearchRetrieve(this.logger, this, mri, requestContext, this.driver);
    }

    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        super.rollbackCurrent(pluginConnection);
        if (this.initialised.get()) {
            this.driver.rollback(pluginConnection.getEntities());
        }
    }

    public boolean transactionCompleted(PluginConnection pluginConnection) {
        if (this.initialised.get()) {
            this.driver.commit();
        }
        return super.transactionCompleted(pluginConnection);
    }

    @Nonnull
    public List<String> getSyncedFields() {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (String field : this.mappingGenerator.getExistingFields()) {
                if (!this.isValidFieldName(field, true)) continue;
                result.add(field);
            }
            return result;
        }
        catch (IOException e) {
            throw new ClientErrorException("Unable to get fields from Elasticsearch.", (Throwable)e);
        }
    }

    public void closeNetworkResources() {
        try {
            if (this.driver != null) {
                this.driver.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing ES connector driver.", (Throwable)e);
        }
    }

    protected String getNativeTypeFromDatatype(IRI datatype, boolean multivalued) {
        return ElasticsearchMappingGenerator.getTypeFromDatatype(datatype);
    }

    public void removeAllEntities() {
        this.init();
        this.driver.deleteAll();
        super.removeAllEntities();
    }

    protected void validateProperties() {
        Boolean[] result = new Boolean[]{false, false};
        this.checkDotsAndNestedProperties(null, this.getProperties(), result);
        if (result[0].booleanValue() && result[1].booleanValue()) {
            throw new ClientErrorException("Field names with dots and nested objects may not be used together.");
        }
        this.hasNestedObjects = result[1];
        this.validateNativeSettings(this.getProperties());
    }

    protected void initImpl() {
        this.driver = ElasticsearchDriver.from(this.logger, this.name, this.options);
        this.driver.setExternalStore((ExternalStore)this);
        Boolean generateMappings = (Boolean)this.options.getValue(ElasticsearchPlugin.MANAGE_MAPPING);
        assert (generateMappings != null);
        this.mappingGenerator = generateMappings != false ? new ElasticsearchMappingGenerator(this.driver, this.hasNestedObjects) : ElasticsearchMappingGenerator.getNoopInstance(this.driver, this.hasNestedObjects);
    }

    private void checkDotsAndNestedProperties(@Nullable Property parent, List<Property> properties, Boolean[] result) {
        for (Property p : properties) {
            boolean hasNested = !p.getObject().isEmpty();
            Boolean[] booleanArray = result;
            Boolean.valueOf(booleanArray[0] | p.getFieldNameWithSuffix().contains("."));
            booleanArray = result;
            Boolean.valueOf(booleanArray[1] | hasNested);
            if (hasNested) {
                String type = p.getNativeType();
                if (!(type == null || type.equals("nested") || type.equals(GEO_POINT_TYPE) || type.equals("object"))) {
                    throw new ClientErrorException("Fields with nested objects must be defined with datatype = object, datatype = nested or datatype = geo_point (object is the default).");
                }
                if (GEO_POINT_TYPE.equals(type)) {
                    List nestedFields = p.getObject();
                    if (nestedFields.size() > 0 && nestedFields.size() != 2) {
                        throw new ClientErrorException("Fields of type geo_point must have exactly two object fields named 'lat' and 'lon'.");
                    }
                    if (nestedFields.size() == 2) {
                        Property of1 = (Property)nestedFields.get(0);
                        Property of2 = (Property)nestedFields.get(1);
                        if (!of1.getFieldNameWithoutSuffix().equals(GEO_POINT_LAT) || !of2.getFieldNameWithoutSuffix().equals(GEO_POINT_LON)) {
                            throw new ClientErrorException("Fields of type geo_point must have exactly two object fields named 'lat' and 'lon'.");
                        }
                    }
                }
            }
            String fieldName = p.getFieldNameWithoutSuffix();
            if (parent != null && !this.isValidFieldName(fieldName, false)) {
                throw new ClientErrorException(String.format("Nested field name '%s' with parent '%s' may not be used.", fieldName, parent.getFieldNameWithoutSuffix()));
            }
            this.checkDotsAndNestedProperties(p, p.getObject(), result);
        }
    }

    private void validateNativeSettings(List<Property> properties) {
        for (Property property : properties) {
            Map nativeSettings = property.getNativeSettings();
            if (!(nativeSettings.isEmpty() || property.getNativeType() != null && property.getXsdType() == null)) {
                throw new ClientErrorException("Native field settings require an explicit native datatype");
            }
            for (String bannedNativeSetting : ElasticsearchMappingGenerator.BANNED_NATIVE_SETTINGS) {
                if (!nativeSettings.containsKey(bannedNativeSetting)) continue;
                throw new ClientErrorException("Native field settings may not contain 'type', 'index', 'store', 'analyzer' or 'fielddata'");
            }
            this.validateNativeSettings(property.getObject());
        }
    }

    public HealthResult runHealthCheckInternal() {
        return this.driver.runHealthCheck();
    }

    protected void applyUpdatedOptions() {
        try {
            this.driver.applyUpdatableOptions(this.options);
        }
        catch (UnknownHostException e) {
            throw new ConnectorUserException("Cannot apply updated options", (Throwable)e);
        }
    }
}

