/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.util;

import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;

class XsdTemporalAccessor
implements TemporalAccessor {
    private final TemporalAccessor delegate;
    private final boolean ignoreTimezoneWithoutTime;

    XsdTemporalAccessor(TemporalAccessor delegate, boolean ignoreTimezoneWithoutTime) {
        this.delegate = delegate;
        this.ignoreTimezoneWithoutTime = ignoreTimezoneWithoutTime;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return this.delegate.isSupported(field);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        return this.delegate.query(query);
    }

    @Override
    public long getLong(TemporalField field) {
        long value = this.delegate.getLong(field);
        if (field == ChronoField.YEAR) {
            if (value <= 0L) {
                --value;
            }
        } else if (this.ignoreTimezoneWithoutTime && field == ChronoField.OFFSET_SECONDS && !this.delegate.isSupported(ChronoField.HOUR_OF_DAY)) {
            return 0L;
        }
        return value;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

