/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.config.DynamicSettings;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.util.PropertyUtil;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.Statements;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TypeAndPropertyKeeper
implements DynamicSettings {
    public static final String CHAIN_TYPES_AND_PROPERTIES = "chainTypesAndProperties";
    private final long rdfTypeId;
    private boolean isTypeWildcard;
    private boolean hasPredicateTransform;
    private List<Property> properties;
    private Property thisProperty;
    private final Map<String, Set<Property>> fieldNameToPropertiesMap;
    private final TLongHashSet typeSet;
    private final TLongObjectHashMap<TLongHashSet> chainTypePropertyMap;
    private long[] directProperties;
    private long[] chainProperties;
    private long[] inverseProperties;
    private long[] inverseChainProperties;
    private boolean finalized;

    public TypeAndPropertyKeeper(long[] types, long rdfTypeId, ImmutableList<Property> properties) {
        this.properties = properties;
        this.fieldNameToPropertiesMap = new HashMap<String, Set<Property>>(2 * properties.size());
        for (Property p : properties) {
            this.processProperty(p);
        }
        for (Map.Entry e : this.fieldNameToPropertiesMap.entrySet()) {
            String prevOptionsPrint = null;
            Boolean prevLang = null;
            Boolean prevGraph = null;
            boolean foundDefault = false;
            for (Property p : (Set)e.getValue()) {
                if (p.getDefaultValue() != 0L) {
                    if (foundDefault) {
                        throw new ConnectorUserException("Only one default value can be defined for a group of suffixed field names.");
                    }
                    foundDefault = true;
                }
                String optionsPrint = p.getOptionsFingerprint();
                if (prevOptionsPrint != null && !prevOptionsPrint.equals(optionsPrint)) {
                    throw new ConnectorUserException("A group of suffixed field names must have the same options and type.");
                }
                boolean lang = p.isLang();
                if (prevLang != null && prevLang != lang) {
                    throw new ConnectorUserException("Suffixed field names must be both defined with lang() or both without lang().");
                }
                boolean graph = p.isGraph();
                if (prevGraph != null && prevGraph != graph) {
                    throw new ConnectorUserException("Suffixed field names must be both defined with graph() or both without graph().");
                }
                prevOptionsPrint = optionsPrint;
                prevLang = lang;
                prevGraph = graph;
            }
        }
        for (Property p : properties) {
            String referenceTo = p.getReferenceTo();
            if (referenceTo == null) continue;
            Set<Property> refProperties = this.fieldNameToPropertiesMap.get(referenceTo);
            if (refProperties != null) {
                for (Property refProperty : refProperties) {
                    if (refProperty.isReferenceTo()) {
                        throw new ConnectorUserException(String.format("Field %s refers to field %s, which in turn refers to another field. You may not refer to referring fields.", p.getFieldNameWithoutSuffix(), referenceTo));
                    }
                    if (p.getDefaultValue() != 0L) {
                        throw new ConnectorUserException(String.format("Field %s refers to field %s but has a default value. Referring fields may not have a default value.", p.getFieldNameWithoutSuffix(), referenceTo));
                    }
                    refProperty.addReferredFromProperty(p);
                }
                continue;
            }
            throw new ConnectorUserException(String.format("Field %s refers to unknown field %s", p.getFieldNameWithoutSuffix(), referenceTo));
        }
        this.rdfTypeId = rdfTypeId;
        this.isTypeWildcard = false;
        this.typeSet = new TLongHashSet();
        this.chainTypePropertyMap = new TLongObjectHashMap();
        if (types[0] == -2147483647L || types[0] == -2147483646L) {
            this.isTypeWildcard = true;
        }
        for (UnmodifiableIterator type : (UnmodifiableIterator)types) {
            this.typeSet.add((long)type);
        }
    }

    public void finalizeStructures() {
        int i;
        ArrayList<Long> lissyDirect = new ArrayList<Long>();
        ArrayList<Long> lissyChain = new ArrayList<Long>();
        ArrayList<Long> lissyInverse = new ArrayList<Long>();
        ArrayList<Long> lissyChainInverse = new ArrayList<Long>();
        ArrayList<Property> propertiesToProcess = new ArrayList<Property>();
        if (this.thisProperty != null) {
            this.thisProperty.finalizeStructures();
            propertiesToProcess.add(this.thisProperty);
        }
        propertiesToProcess.addAll(this.properties);
        for (Property p : propertiesToProcess) {
            int i2;
            p.finalizeStructures();
            if (!p.isSelf() && !p.isReferenceTo()) {
                if (!p.inverseIri[0]) {
                    lissyDirect.add(p.owlimIds[0]);
                } else {
                    lissyInverse.add(p.owlimIds[0]);
                }
                for (i2 = 1; i2 < p.owlimIds.length; ++i2) {
                    if (!p.inverseIri[i2]) {
                        lissyChain.add(p.owlimIds[i2]);
                        continue;
                    }
                    lissyChainInverse.add(p.owlimIds[i2]);
                }
                this.processNestedChains(lissyChain, p);
            }
            for (i2 = 0; i2 < p.nextHopIdsAtPosition.length; ++i2) {
                for (int k = 0; k < p.nextHopIdsAtPosition[i2].length; ++k) {
                    lissyChain.add(p.nextHopIdsAtPosition[i2][k]);
                }
            }
        }
        this.directProperties = new long[lissyDirect.size()];
        for (i = 0; i < this.directProperties.length; ++i) {
            this.directProperties[i] = (Long)lissyDirect.get(i);
        }
        this.chainProperties = new long[lissyChain.size()];
        for (i = 0; i < this.chainProperties.length; ++i) {
            this.chainProperties[i] = (Long)lissyChain.get(i);
        }
        this.inverseProperties = new long[lissyInverse.size()];
        for (i = 0; i < this.inverseProperties.length; ++i) {
            this.inverseProperties[i] = (Long)lissyInverse.get(i);
        }
        this.inverseChainProperties = new long[lissyChainInverse.size()];
        for (i = 0; i < this.inverseChainProperties.length; ++i) {
            this.inverseChainProperties[i] = (Long)lissyChainInverse.get(i);
        }
        this.properties = PropertyUtil.sortPropertiesForFiltering(this.properties);
        this.finalized = true;
    }

    private void processNestedChains(List<Long> chain, Property parent) {
        for (Property p : parent.getObject()) {
            if (p.isSelf() || p.isReferenceTo()) continue;
            for (int i = 0; i < p.owlimIds.length; ++i) {
                chain.add(p.owlimIds[i]);
            }
            this.processNestedChains(chain, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<Property> getEntityPropertyToIndex(long subject, Statements statements) {
        if (this.isTypeWildcard) {
            return this.properties;
        }
        try (StatementIterator typesIterator = statements.get(subject, this.rdfTypeId, 0L);){
            while (typesIterator.next()) {
                long type = typesIterator.object;
                if (!this.typeSet.contains(type)) continue;
                List<Property> list = this.properties;
                return list;
            }
            List<Property> list = null;
            return list;
        }
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean isTypeAndPropertyInAnyChain(long type, long property) {
        TLongHashSet propertySet = (TLongHashSet)this.chainTypePropertyMap.get(type);
        return propertySet != null && propertySet.contains(property);
    }

    public long[] getChainProperties() {
        return this.chainProperties;
    }

    public long[] getInverseProperties() {
        return this.inverseProperties;
    }

    public long[] getInverseChainProperties() {
        return this.inverseChainProperties;
    }

    public boolean addDependeeTypeAndProperty(long type, long property, long ... properties) {
        boolean result = false;
        TLongHashSet propertySet = (TLongHashSet)this.chainTypePropertyMap.get(type);
        if (propertySet == null) {
            propertySet = new TLongHashSet();
            this.chainTypePropertyMap.put(type, (Object)propertySet);
        }
        if (property != 0L) {
            result = propertySet.add(property);
        }
        for (long property1 : properties) {
            result |= propertySet.add(property1);
        }
        return result;
    }

    @Nonnull
    public long[] getDirectProperties() {
        return this.directProperties;
    }

    public boolean hasPredicateTransform() {
        return this.hasPredicateTransform;
    }

    @Override
    public JSONObject getSettingsAsJSON() {
        JSONObject settings = new JSONObject();
        final JSONArray chainTypes = new JSONArray();
        settings.put((Object)CHAIN_TYPES_AND_PROPERTIES, (Object)chainTypes);
        this.chainTypePropertyMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TLongHashSet>(){

            public boolean execute(final long a, TLongHashSet b) {
                b.forEach(new TLongProcedure(){

                    public boolean execute(long value) {
                        JSONArray pair = new JSONArray();
                        pair.add((Object)a);
                        pair.add((Object)value);
                        chainTypes.add((Object)pair);
                        return true;
                    }
                });
                return true;
            }
        });
        return settings;
    }

    @Override
    public void setSettingsFromJSON(JSONObject json) {
        this.chainTypePropertyMap.clear();
        JSONArray chainTypes = (JSONArray)json.get((Object)CHAIN_TYPES_AND_PROPERTIES);
        for (Object e : chainTypes) {
            JSONArray ea = (JSONArray)e;
            this.addDependeeTypeAndProperty((Long)ea.get(0), (Long)ea.get(1), new long[0]);
        }
    }

    @Override
    public boolean settingsHaveChanged() {
        return false;
    }

    public long[] getTypes() {
        return this.typeSet.toArray();
    }

    public boolean addChainTypes(TLongObjectHashMap<TLongHashSet> typeMap) {
        class BooleanHolder {
            boolean value = false;

            BooleanHolder() {
            }
        }
        final BooleanHolder result = new BooleanHolder();
        typeMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TLongHashSet>(){
            {
            }

            public boolean execute(final long oldType, TLongHashSet newTypes) {
                newTypes.forEach(new TLongProcedure(){

                    public boolean execute(long newType) {
                        TLongHashSet propertiesForOldType = (TLongHashSet)TypeAndPropertyKeeper.this.chainTypePropertyMap.get(oldType);
                        TLongHashSet propertiesForNewType = (TLongHashSet)TypeAndPropertyKeeper.this.chainTypePropertyMap.get(newType);
                        if (propertiesForNewType == null) {
                            propertiesForNewType = new TLongHashSet();
                            TypeAndPropertyKeeper.this.chainTypePropertyMap.put(newType, (Object)propertiesForNewType);
                        }
                        if (propertiesForOldType != null) {
                            result.value = true;
                            propertiesForNewType.addAll(propertiesForOldType.toArray());
                        }
                        return true;
                    }
                });
                return true;
            }
        });
        return result.value;
    }

    public Set<Property> getPropertiesByFieldName(String fieldName) {
        Set<Property> properties = this.fieldNameToPropertiesMap.get(fieldName);
        if (properties != null) {
            return properties;
        }
        return Collections.emptySet();
    }

    private void processProperty(Property p) {
        Set<String> prefixes = p.getParentProperty() != null ? p.getParentProperty().getAllPrefixesForChildren() : Collections.singleton("");
        prefixes.forEach(prefix -> List.of(p.getFieldName().fieldNameWithSuffix, p.getFieldName().fieldNameWithoutSuffix).forEach(fieldName -> this.fieldNameToPropertiesMap.computeIfAbsent(prefix + fieldName, k -> new HashSet(2)).add(p)));
        this.hasPredicateTransform |= p.getFieldNameTransform().isPredicateNeeded();
        for (Property op : p.getObject()) {
            this.processProperty(op);
        }
    }

    public Property getOrCreateThisProperty(Entities entities) {
        if (!this.finalized && this.thisProperty == null) {
            this.thisProperty = Property.createThisProperty(entities);
        }
        return this.thisProperty;
    }

    public Property getThisProperty() {
        return this.thisProperty;
    }
}

