/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl;

import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.FlexibleBucket;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InternalServerErrorException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.slf4j.Logger;

public abstract class AbstractExternalRetrieve
implements ExternalRetrieve {
    protected final MasterResultIterator mri;
    protected final ExternalSyncRequestContext requestContext;
    protected List<FlexibleBucket> faHolder = new ArrayList<FlexibleBucket>();
    protected ExternalStore externalStore;
    protected ValueFactory valueFactory;
    protected Logger logger;

    protected AbstractExternalRetrieve(Logger logger, ExternalStore externalStore, MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        this.logger = logger;
        this.externalStore = externalStore;
        this.valueFactory = externalStore.getValueFactory();
        this.mri = mri;
        this.requestContext = requestContext;
    }

    protected RuntimeException logErrorAndCreateException(String message, Exception reason) {
        this.logger.error("[{}] " + message, (Object)this.externalStore.getName(), (Object)reason);
        return new InternalServerErrorException(message, (Throwable)reason);
    }

    protected Literal createLiteralForNumber(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
            return this.valueFactory.createLiteral(number.longValue());
        }
        return this.valueFactory.createLiteral(number.doubleValue());
    }

    protected long createRequestEntity(Number number) {
        return this.mri.getEntities().put((Value)this.createLiteralForNumber(number), Entities.Scope.REQUEST);
    }

    protected long createRequestEntity(Object value) {
        if (value instanceof Number) {
            return this.createRequestEntity((Number)value);
        }
        if (value instanceof Date) {
            return this.createRequestEntity((Date)value);
        }
        return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value.toString()), Entities.Scope.REQUEST);
    }

    protected long createRequestEntity(Date date) {
        return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(DateFormatUtils.formatUTC((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), XMLSchema.DATETIME), Entities.Scope.REQUEST);
    }

    protected long createRequestEntity(Object value, IRI type) {
        return this.mri.getEntities().put((Value)this.valueFactory.createLiteral(value.toString(), type), Entities.Scope.REQUEST);
    }

    protected long createRequestBNode() {
        return this.mri.getEntities().put((Value)this.valueFactory.createBNode(), Entities.Scope.REQUEST);
    }

    protected long createRequestEntity(Value value) {
        return this.mri.getEntities().put(value, Entities.Scope.REQUEST);
    }

    protected FlexibleBucket createBucket(FlexibleBucket.FlexibleBucketType type, long bucketId, long nameId, long parentId, long levelId) {
        return new FlexibleBucket(bucketId, this.mri.getEntities().put((Value)this.valueFactory.createLiteral(type.toString()), Entities.Scope.REQUEST), nameId, parentId, levelId);
    }

    @Override
    public List<FlexibleBucket> getFlexibleBuckets() {
        return this.faHolder;
    }
}

