/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.FileImportRunnableTask;
import com.ontotext.forest.impex.ImportRunnableTask;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.impex.ImportTasksExecutor;
import com.ontotext.graphdb.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.springframework.stereotype.Component;

@Component
public class UserFileTasksExecutor
extends ImportTasksExecutor<File> {
    private Path uploadedFilesDirectory = Paths.get(Config.getWorkDirectory(), "workbench", "upload");

    public UserFileTasksExecutor() {
        super("import.local");
    }

    @Override
    protected ImportRunnableTask createTask(SemanticRepository repo, boolean isLocal, File importFile, String taskName, RDFFormat fileFormat, ImportSettings settings) {
        return new FileImportRunnableTask(repo, isLocal, importFile, taskName, fileFormat, settings, this.getStatusService(), this.tasks);
    }

    public void createUplodadeFilesDirectory() throws IOException {
        Files.createDirectories(this.uploadedFilesDirectory, new FileAttribute[0]);
    }

    public Path getPathForFilename(String filename) {
        return this.uploadedFilesDirectory.resolve(filename);
    }

    public String createFilename() {
        return UUID.randomUUID().toString();
    }

    @Override
    protected ImportSettings removeEntry(String repository, String name) {
        ImportSettings settings = this.getStatusService().getImportInfo(repository, name);
        String data = settings.getData();
        if (data != null && settings.getType().equals("file")) {
            Path fileToDelete = this.getPathForFilename(data);
            try {
                Files.deleteIfExists(fileToDelete);
            }
            catch (IOException e) {
                ImportStatusService.LOGGER.warn("Could not delete uploaded file on request: {}", (Object)fileToDelete);
            }
        }
        return super.removeEntry(repository, name);
    }
}

