/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.ImportFileLister;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.load.BlindZipParserFactory;
import com.ontotext.trree.ParallelImport;
import com.ontotext.trree.parallel.InterruptableConnectionWrapper;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.io.ZipUtil;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;

public class ParallelAwareImporter
implements Closeable,
AutoCloseable {
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private RepositoryConnection connection;
    private Adder extraOperationsAfterBegin = () -> {};
    private final TransactionSetting[] txSettings;
    private String userFilename;
    private final AtomicLong numberOfStatements = new AtomicLong(0L);
    private String persistFilename;
    private static final List<TransactionSetting> DEFAULT_TRANSACTION_SETTINGS = Arrays.asList(ShaclSail.TransactionSettings.ValidationApproach.Bulk);

    ParallelAwareImporter(SemanticRepository repository, ImportSettings importSettings) {
        ParserConfig parserConfig = importSettings.getParserConfig();
        this.connection = repository.getConnection();
        this.connection.setParserConfig(parserConfig);
        if (repository.isLocal()) {
            this.connection = new InterruptableConnectionWrapper(this.connection);
        }
        List<String> replaceGraphs = importSettings.getReplaceGraphs();
        ArrayList<TransactionSetting> txSettings = new ArrayList<TransactionSetting>(DEFAULT_TRANSACTION_SETTINGS);
        if (replaceGraphs != null && !replaceGraphs.isEmpty()) {
            TreeModel m = new TreeModel();
            for (String graph : replaceGraphs) {
                if ("default".equals(graph)) {
                    m.add((Resource)this.vf.createBNode(), this.vf.createIRI("http://www.ontotext.com/replaceGraph"), (Value)SESAME.NIL, new Resource[0]);
                    continue;
                }
                if (graph.endsWith("*")) {
                    m.add((Resource)this.vf.createBNode(), this.vf.createIRI("http://www.ontotext.com/replaceGraphPrefix"), (Value)this.vf.createIRI(graph.substring(0, graph.length() - 1)), new Resource[0]);
                    continue;
                }
                m.add((Resource)this.vf.createBNode(), this.vf.createIRI("http://www.ontotext.com/replaceGraph"), (Value)this.vf.createIRI(graph), new Resource[0]);
            }
            this.extraOperationsAfterBegin = () -> this.lambda$new$1((Model)m);
        } else if (!importSettings.isForceSerial() && !"SYSTEM".equals(repository.getRepositoryID()) && ParallelImport.IS_PARALLEL_MODE_ENABLED) {
            txSettings.add(ParallelImport.INSTANCE);
        }
        this.txSettings = txSettings.toArray(new TransactionSetting[0]);
    }

    public void interrupt() {
        if (this.connection instanceof InterruptableConnectionWrapper) {
            ((InterruptableConnectionWrapper)this.connection).interruptAllImports();
        }
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws Exception {
        this.wrapInBeginCommit(() -> this.connection.add(in, baseURI, dataFormat, contexts));
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws Exception {
        this.wrapInBeginCommit(() -> this.connection.add(reader, baseURI, dataFormat, contexts));
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws Exception {
        this.wrapInBeginCommit(() -> this.connection.add(url, baseURI, dataFormat, contexts));
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws Exception {
        this.wrapInBeginCommit(() -> {
            Map<Path, RDFFormat> filesToImport = Collections.singletonMap(file.toPath(), dataFormat);
            if (file.isDirectory()) {
                filesToImport = ImportFileLister.listRDFFiles(file.toPath(), false);
            }
            for (Map.Entry<Path, RDFFormat> e : filesToImport.entrySet()) {
                RDFFormat rdfFormat;
                File fileToImport = e.getKey().toFile();
                this.setUserFilename(fileToImport.getName());
                if (!file.getName().equals(fileToImport.getName())) {
                    this.persistFilename = file.getName() + "/" + fileToImport.getName();
                }
                if (BlindZipParserFactory.BLIND_ZIP_RDF_FORMAT.equals((Object)(rdfFormat = e.getValue()))) {
                    try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fileToImport));){
                        if (!ZipUtil.isZipStream((InputStream)fis)) {
                            throw new RDFParseException("File is not in ZIP format: " + this.userFilename);
                        }
                    }
                }
                try {
                    this.connection.add(fileToImport, baseURI, rdfFormat, contexts);
                }
                catch (NullPointerException npe) {
                    throw new RDFParseException("Invalid file format");
                }
            }
        });
    }

    public void setUserFilename(String userFilename) {
        this.userFilename = userFilename;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    private void wrapInBeginCommit(Adder adder) throws Exception {
        this.connection.begin(this.txSettings);
        long statementsBeforeUpdate = this.connection.size(new Resource[0]);
        try {
            this.extraOperationsAfterBegin.addData();
            adder.addData();
            this.connection.commit();
            this.numberOfStatements.set(this.connection.size(new Resource[0]) - statementsBeforeUpdate);
        }
        catch (Error | Exception e) {
            this.connection.rollback();
            throw e;
        }
    }

    public long getNumberOfStatements() {
        return this.numberOfStatements.get();
    }

    public String getPersistFilename() {
        return this.persistFilename;
    }

    private /* synthetic */ void lambda$new$1(Model m) throws Exception {
        this.connection.add((Iterable)m, new Resource[0]);
    }

    static interface Adder {
        public void addData() throws Exception;
    }
}

