/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.ExecutorProvider;
import com.ontotext.forest.impex.ImportRunnableTask;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.ServerMaintenanceListener;
import com.ontotext.trree.io.FileSystemHealth;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public abstract class ImportTasksExecutor<T>
implements ServerMaintenanceListener {
    @Autowired
    protected ExecutorProvider executorProvider;
    @Autowired
    protected SemanticDataManagement dataManagement;
    @Autowired
    protected PersistedConfig persistedConfig;
    protected final String dbKey;
    protected ImportStatusService statusService;
    protected final Map<String, Map<String, ImportRunnableTask>> tasks = new HashMap<String, Map<String, ImportRunnableTask>>();
    protected final AtomicBoolean inMaintenanceMode = new AtomicBoolean();
    private final Logger logger = LoggerFactory.getLogger(ImportTasksExecutor.class);
    private static final String ERROR_INTERRUPTING = "No running task for ";
    private static final String SUCCESS_INTERRUPTING = " interrupted!";
    private static final int INTERRUPT_WAITING_TIMEOUT = 1800;

    public ImportTasksExecutor(String dbKey) {
        this.dbKey = dbKey;
    }

    private synchronized ImportStatusService getLazyStatusServiceOrThrowIfInRecovery() {
        if (this.inMaintenanceMode.get()) {
            throw new RuntimeException("Cannot handle import status in maintenance mode.");
        }
        if (this.statusService == null) {
            this.statusService = new ImportStatusService(this.persistedConfig, this.dataManagement, this.dbKey);
        }
        return this.statusService;
    }

    protected synchronized ResponseEntity<String> submitTask(SemanticRepository repo, boolean isLocal, T importTask, String taskName, RDFFormat fileFormat, ImportSettings settings) throws GraphDBWorkbenchException {
        ImportStatusService importStatusService = this.getLazyStatusServiceOrThrowIfInRecovery();
        if (this.tasks.containsKey(repo.getRepositoryID()) && this.tasks.get(repo.getRepositoryID()).containsKey(taskName)) {
            return new ResponseEntity((Object)String.format("Task %s already scheduled for import.", taskName), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        FileSystemHealth.getInstance().canStartTransaction(repo.getRepositoryID());
        settings.setStatus(ImportStatusService.ImportStatus.PENDING);
        settings.setRequestIdHeadersToForward(MDC.get((String)"headers"));
        ImportRunnableTask stoppableImportTask = this.createTask(repo, isLocal, importTask, taskName, fileFormat, settings);
        importStatusService.saveImportFile(repo.getRepositoryID(), settings);
        Future<?> submit = this.executorProvider.submit(repo.getRepositoryID(), stoppableImportTask);
        stoppableImportTask.setFuture(submit);
        if (!this.tasks.containsKey(repo.getRepositoryID())) {
            this.tasks.put(repo.getRepositoryID(), new HashMap());
        }
        this.tasks.get(repo.getRepositoryID()).put(taskName, stoppableImportTask);
        return new ResponseEntity((Object)String.format("File %s sent for import.", taskName), (HttpStatusCode)HttpStatus.ACCEPTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseEntity<String> interruptTask(String repositoryId, String taskName) {
        Map<String, Map<String, ImportRunnableTask>> map = this.tasks;
        synchronized (map) {
            if (!this.tasks.containsKey(repositoryId) || !this.tasks.get(repositoryId).containsKey(taskName)) {
                return new ResponseEntity((Object)(ERROR_INTERRUPTING + taskName), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            this.tasks.get(repositoryId).get(taskName).interrupt();
        }
        return new ResponseEntity((Object)(taskName + SUCCESS_INTERRUPTING), (HttpStatusCode)HttpStatus.OK);
    }

    protected abstract ImportRunnableTask createTask(SemanticRepository var1, boolean var2, T var3, String var4, RDFFormat var5, ImportSettings var6);

    protected ImportStatusService getStatusService() {
        return this.getLazyStatusServiceOrThrowIfInRecovery();
    }

    public Map<String, Map<String, ImportRunnableTask>> getTasks() {
        return this.tasks;
    }

    protected void resetStatus(String repository, String name, String importDirectory) throws IOException {
        this.interruptImportTaskIfNeeded(repository, name);
        this.getLazyStatusServiceOrThrowIfInRecovery().reset(repository, name);
    }

    protected ImportSettings removeEntry(String repository, String name) {
        this.interruptImportTaskIfNeeded(repository, name);
        return this.getLazyStatusServiceOrThrowIfInRecovery().clear(repository, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptImportTaskIfNeeded(String repository, String name) {
        Map<String, Map<String, ImportRunnableTask>> map = this.tasks;
        synchronized (map) {
            if (this.tasks.containsKey(repository) && this.tasks.get(repository).containsKey(name)) {
                this.tasks.get(repository).get(name).interrupt();
                long startTime = System.currentTimeMillis();
                ImportStatusService importStatusService = this.getLazyStatusServiceOrThrowIfInRecovery();
                AtomicReference<ImportStatusService.ImportStatus> importStatus = new AtomicReference<ImportStatusService.ImportStatus>(ImportStatusService.ImportStatus.NONE);
                while (importStatus.get() != ImportStatusService.ImportStatus.ERROR) {
                    importStatus.set(importStatusService.getImportInfo(repository, name).getStatus());
                    if (System.currentTimeMillis() - startTime > TimeUnit.SECONDS.toMillis(1800L)) {
                        this.logger.warn("Interruption of task is taking more than 30 minutes and will continue while file will be removed from UI view.");
                    }
                    Thread.onSpinWait();
                }
            }
        }
    }

    public void lockForMaintenance() {
        this.inMaintenanceMode.set(true);
    }

    public void unlockAfterMaintenance() {
        if (this.inMaintenanceMode.compareAndSet(true, false)) {
            this.getLazyStatusServiceOrThrowIfInRecovery().updateInterrupted();
        }
    }

    public int getOrderIndex() {
        return 29;
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DaemonThreadFactory(String repository) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "import-task-" + repository + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

