/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.impex.ImportPersistenceUtils;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ParallelAwareImporter;
import com.ontotext.forest.persistence.PersistedConfig;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportStatusService {
    protected static Logger LOGGER = LoggerFactory.getLogger(ImportStatusService.class);
    protected final PersistedConfig persistedConfig;
    protected final String dbKey;
    private final SemanticDataManagement dataManagement;

    public ImportStatusService(PersistedConfig persistedConfig, SemanticDataManagement dataManagement, String dbKey) {
        this.persistedConfig = persistedConfig;
        this.dbKey = dbKey;
        this.dataManagement = dataManagement;
        this.updateInterrupted();
    }

    protected void update(String repositoryString, String fileName, ImportStatus status, ParallelAwareImporter parallelAwareImporter) {
        this.update(repositoryString, fileName, status, "", parallelAwareImporter);
    }

    protected void update(String repositoryString, String fileName, ImportStatus status, String message, ParallelAwareImporter parallelAwareImporter) {
        this.updateImportInfo(repositoryString, this.dataManagement.getCurrentLocationOrThrow(), fileName, status, message, parallelAwareImporter != null ? parallelAwareImporter.getNumberOfStatements() : 0L);
    }

    protected void save(String repository, ImportSettings settings) {
        SemanticLocation location = this.dataManagement.getCurrentLocationOrThrow();
        String compositeKey = ImportPersistenceUtils.getCompositeKey(repository, location, settings.getName());
        this.persistedConfig.updateMapEntry(this.dbKey, ImportSettings.class, compositeKey, (Object)settings, (oldValue, newValue) -> {
            if (oldValue != null) {
                newValue.setImported(oldValue.getImported());
            } else {
                newValue.setImported(System.currentTimeMillis());
            }
        });
    }

    protected void saveImportFile(String repository, ImportSettings settings) {
        SemanticLocation location = this.dataManagement.getCurrentLocationOrThrow();
        String compositeKey = ImportPersistenceUtils.getCompositeKey(repository, location, settings.getName());
        this.persistedConfig.updateMapEntry(this.dbKey, ImportSettings.class, compositeKey, (Object)settings);
    }

    protected ImportSettings clear(String repositoryId, String fileName) {
        SemanticLocation location = this.dataManagement.getCurrentLocationOrThrow();
        String compositeKey = ImportPersistenceUtils.getCompositeKey(repositoryId, location, fileName);
        return (ImportSettings)this.persistedConfig.deleteMapEntry(this.dbKey, ImportSettings.class, compositeKey);
    }

    protected synchronized boolean reset(String repositoryId, String fileName) {
        SemanticLocation location = this.dataManagement.getCurrentLocationOrThrow();
        ImportSettings importInfo = this.getImportInfo(repositoryId, location, fileName);
        if (importInfo != null) {
            importInfo.reset();
            String compositeKey = ImportPersistenceUtils.getCompositeKey(repositoryId, location, fileName);
            this.persistedConfig.updateMapEntry(this.dbKey, ImportSettings.class, compositeKey, (Object)importInfo);
            return true;
        }
        return false;
    }

    protected void renameRepository(String oldRepository, String newRepository) {
    }

    protected ImportSettings getImportInfo(String repositoryString, String fileName) {
        ImportSettings importInfo = this.getImportInfo(repositoryString, this.dataManagement.getCurrentLocationOrThrow(), fileName);
        if (importInfo == null) {
            importInfo = new ImportSettings();
            importInfo.setName(fileName);
        }
        return importInfo;
    }

    protected List<String> getFilesByStatus(String repositoryString, ImportStatus ... status) {
        List<ImportStatus> statusList = Arrays.asList(status);
        return this.getAllForRepository(repositoryString, this.dataManagement.getCurrentLocationOrThrow()).stream().filter(i -> statusList.contains((Object)i.getStatus())).map(ImportSettings::getName).collect(Collectors.toList());
    }

    protected List<ImportSettings> getAllForRepositorySortedByAge(String repositoryString) {
        List<ImportSettings> infosForRepo = this.getAllForRepository(repositoryString, this.dataManagement.getCurrentLocationOrThrow());
        infosForRepo.sort(Comparator.comparing(ImportSettings::getImported).reversed());
        return infosForRepo;
    }

    protected List<ImportSettings> getAllForRepository(String repositoryString) {
        return this.getAllForRepository(repositoryString, this.dataManagement.getCurrentLocationOrThrow());
    }

    protected void updateInterrupted() {
        Map map = this.persistedConfig.getMap(this.dbKey, ImportSettings.class);
        Iterator itty = map.keySet().iterator();
        HashMap<String, ImportSettings> updateEntries = new HashMap<String, ImportSettings>();
        while (itty.hasNext()) {
            String key = (String)itty.next();
            ImportSettings importInfo = (ImportSettings)map.get(key);
            if (ImportStatus.IMPORTING == importInfo.getStatus()) {
                importInfo.setStatus(ImportStatus.ERROR);
                importInfo.setMessage("Import was interrupted externally.");
                updateEntries.put(key, importInfo);
            }
            if (ImportStatus.PENDING != importInfo.getStatus()) continue;
            importInfo.setStatus(ImportStatus.ERROR);
            importInfo.setMessage("Import was not started because GraphDB was stopped.");
            updateEntries.put(key, importInfo);
        }
        this.persistedConfig.updateMapEntries(this.dbKey, ImportSettings.class, updateEntries);
    }

    private synchronized void updateImportInfo(String repositoryId, SemanticLocation location, String fileName, ImportStatus status, String message, long numberOfStatements) {
        ImportSettings importInfo = this.getImportInfo(repositoryId, location, fileName);
        if (importInfo == null) {
            importInfo = new ImportSettings();
            importInfo.setName(fileName);
        }
        importInfo.setStatus(status);
        importInfo.setMessage(message);
        importInfo.setAddedRemovedStatements(numberOfStatements);
        if (status == ImportStatus.DONE || status == ImportStatus.ERROR) {
            importInfo.setFileImported();
        }
        String compositeKey = ImportPersistenceUtils.getCompositeKey(repositoryId, location, fileName);
        this.persistedConfig.updateMapEntry(this.dbKey, ImportSettings.class, compositeKey, (Object)importInfo);
    }

    private ImportSettings getImportInfo(String repositoryId, SemanticLocation location, String fileName) {
        String compositeKey = ImportPersistenceUtils.getCompositeKey(repositoryId, location, fileName);
        Map map = this.persistedConfig.getMap(this.dbKey, ImportSettings.class);
        return (ImportSettings)map.get(compositeKey);
    }

    private List<ImportSettings> getAllForRepository(String repositoryId, SemanticLocation location) {
        String compositeKeyPrefix = ImportPersistenceUtils.getCompositeKey(repositoryId, location, "");
        Map map = this.persistedConfig.getMap(this.dbKey, ImportSettings.class);
        return map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(compositeKeyPrefix)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    protected static enum ImportStatus {
        PENDING,
        IMPORTING,
        DONE,
        ERROR,
        NONE,
        INTERRUPTING;

    }

    public static class DirectoryImportInfo {
        private final AtomicLong size = new AtomicLong(0L);
        private final AtomicLong lastModifiedTime = new AtomicLong(0L);

        public void setDirectoryImportInfo(Path path) throws IOException {
            Path effectivePath = path;
            if (Files.isSymbolicLink(path)) {
                effectivePath = Files.readSymbolicLink(path);
            }
            Files.walkFileTree(effectivePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    lastModifiedTime.updateAndGet(current -> Math.max(current, attrs.lastModifiedTime().toMillis()));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    lastModifiedTime.updateAndGet(current -> {
                        try {
                            return Math.max(current, Files.getLastModifiedTime(dir, new LinkOption[0]).toMillis());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        public long getSize() {
            return this.size.get();
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime.get();
        }
    }
}

