/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.impex.ParserSettings;
import com.ontotext.rio.jsonld.JsonLDUtils;
import com.ontotext.rio.jsonld.settings.GraphDBJSONLDSettings;
import com.ontotext.trree.GraphDBParserConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportSettings {
    private static final Logger logger = LoggerFactory.getLogger(ImportSettings.class);
    private String name;
    private ImportStatusService.ImportStatus status;
    private String message;
    private String context;
    private List<String> replaceGraphs;
    private String baseURI;
    private boolean forceSerial;
    private String type;
    private String format;
    private String data;
    private ParserSettings parserSettings = new ParserSettings();
    private String requestIdHeadersToForward;
    private String size;
    private long lastModified;
    private long imported;
    private long addedStatements;
    private long removedStatements;
    private int numReplacedGraphs;

    public ImportSettings() {
        this.message = "";
        this.status = ImportStatusService.ImportStatus.NONE;
        this.replaceGraphs = Collections.emptyList();
    }

    public void reset() {
        this.setStatus(ImportStatusService.ImportStatus.NONE);
        this.setMessage("");
        this.setContext("");
        this.setParserSettings(new ParserSettings());
        this.setReplaceGraphs(Collections.emptyList());
        this.setBaseURI(null);
        this.setLastModified(0L);
        this.setAddedStatements(0L);
        this.setRemovedStatements(0L);
        this.setNumReplacedGraphs(0);
        this.setAddedRemovedStatements(0L);
    }

    public ImportSettings forName(String name) {
        return new ImportSettings(this.context, this.replaceGraphs, this.baseURI, this.forceSerial, this.parserSettings, name, this.type, this.format, this.data, this.size, this.lastModified, this.imported, this.addedStatements, this.removedStatements);
    }

    public ImportSettings(String context, List<String> replaceGraphs, String baseURI, boolean forceSerial, ParserSettings parserSettings, String fileName, String type, String format, String data, String size, long lastModified, long imported, long addedStatements, long removedStatements) {
        this.name = fileName;
        this.baseURI = baseURI;
        this.context = context;
        this.replaceGraphs = replaceGraphs == null ? Collections.emptyList() : new ArrayList<String>(replaceGraphs);
        this.forceSerial = forceSerial;
        this.parserSettings = parserSettings == null ? new ParserSettings() : parserSettings;
        this.type = type;
        this.format = format;
        this.data = data;
        this.size = size;
        this.lastModified = lastModified;
        this.imported = imported;
        this.addedStatements = addedStatements;
        this.removedStatements = removedStatements;
        this.numReplacedGraphs = replaceGraphs == null ? 0 : replaceGraphs.size();
    }

    public ParserSettings getParserSettings() {
        return this.parserSettings;
    }

    public void setParserSettings(ParserSettings parserSettings) {
        this.parserSettings = parserSettings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImportStatusService.ImportStatus getStatus() {
        return this.status;
    }

    public void setStatus(ImportStatusService.ImportStatus status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @JsonIgnore
    public IRI[] getContextResources() {
        if ("default".equals(this.context)) {
            return new IRI[]{null};
        }
        if (StringUtils.isNotEmpty((CharSequence)this.context)) {
            return new IRI[]{SimpleValueFactory.getInstance().createIRI(this.context)};
        }
        return new IRI[0];
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<String> getReplaceGraphs() {
        return this.replaceGraphs;
    }

    public void setReplaceGraphs(List<String> replaceGraphs) {
        this.replaceGraphs = replaceGraphs;
    }

    public boolean isForceSerial() {
        return this.forceSerial;
    }

    public void setForceSerial(boolean forceSerial) {
        this.forceSerial = forceSerial;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @JsonIgnore
    public ParserConfig getParserConfig() {
        ParserConfig parserConfig = GraphDBParserConfig.newInstance();
        if (!this.parserSettings.isStopOnError()) {
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS);
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES);
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.VERIFY_LANGUAGE_TAGS);
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.VERIFY_URI_SYNTAX);
            parserConfig.addNonFatalError((RioSetting)BasicParserSettings.VERIFY_RELATIVE_URIS);
        }
        parserConfig.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)this.parserSettings.preserveBNodeIds);
        parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)this.parserSettings.verifyDataTypeValues);
        parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)this.parserSettings.failOnUnknownDataTypes);
        parserConfig.set((RioSetting)BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)this.parserSettings.normalizeDataTypeValues);
        parserConfig.set((RioSetting)BasicParserSettings.VERIFY_LANGUAGE_TAGS, (Object)this.parserSettings.verifyLanguageTags);
        parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES, (Object)this.parserSettings.failOnUnknownLanguageTags);
        parserConfig.set((RioSetting)BasicParserSettings.NORMALIZE_LANGUAGE_TAGS, (Object)this.parserSettings.normalizeLanguageTags);
        if (StringUtils.isNotEmpty((CharSequence)this.parserSettings.contextLink)) {
            JsonLDUtils.validateWhitelistedLink((String)this.parserSettings.contextLink);
            parserConfig.set(GraphDBJSONLDSettings.EXPAND_CONTEXT, (Object)JsonLDUtils.stringToURI((String)this.parserSettings.contextLink));
        }
        return parserConfig;
    }

    @JsonIgnore
    public String getRequestIdHeadersToForward() {
        return this.requestIdHeadersToForward;
    }

    public void setRequestIdHeadersToForward(String requestIdHeadersToForward) {
        this.requestIdHeadersToForward = requestIdHeadersToForward;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getImported() {
        return this.imported;
    }

    public void setImported(long imported) {
        this.imported = imported;
    }

    public long getAddedStatements() {
        return this.addedStatements;
    }

    public void setAddedStatements(long addedStatements) {
        this.addedStatements = addedStatements;
    }

    public long getRemovedStatements() {
        return this.removedStatements;
    }

    public void setRemovedStatements(long removedStatements) {
        this.removedStatements = removedStatements;
    }

    public int getNumReplacedGraphs() {
        return this.numReplacedGraphs;
    }

    public void setNumReplacedGraphs(int numReplacedGraphs) {
        this.numReplacedGraphs = numReplacedGraphs;
    }

    void setFileSize(File file) {
        if (this.type != null && this.type.equals("file") && file != null && file.exists()) {
            this.size = String.valueOf(file.length());
        }
    }

    void setFileSize(long fileSizeInBytes) {
        this.size = String.valueOf(fileSizeInBytes);
    }

    void setFileLastModified(File file) {
        if (this.type != null && this.type.equals("file") && file != null && file.exists()) {
            try {
                this.lastModified = file.lastModified();
            }
            catch (Exception e) {
                logger.error("Could not get last modified date and time.");
            }
        }
    }

    void setURLTEXTLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    void setFileImported() {
        this.imported = System.currentTimeMillis();
    }

    void setAddedRemovedStatements(long numberOfStatements) {
        if (numberOfStatements == 0L) {
            this.setAddedStatements(0L);
            this.setRemovedStatements(0L);
        }
        if (numberOfStatements < 0L) {
            this.setRemovedStatements(numberOfStatements);
            this.setAddedStatements(0L);
        } else {
            this.setAddedStatements(numberOfStatements);
            this.setRemovedStatements(0L);
        }
    }
}

