/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.impex.ParallelAwareImporter;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.graphdb.statistics.models.enums.OperationType;
import com.ontotext.trree.io.FileSystemHealth;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import common.exceptions.InsufficientDiskSpaceException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class ImportRunnableTask
implements Runnable {
    public static final String IMPORT_WAS_INTERRUPTED = "Import was interrupted";
    public static final String INVALID_RDF = "RDF Parse Error";
    public static final String COULD_NOT_IMPORT_FILE = "Could not import file";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final SemanticRepository repo;
    private final boolean isLocal;
    final RDFFormat fileFormat;
    final ImportSettings settings;
    private final ImportStatusService importStatusService;
    private boolean isRunning;
    private final Map<String, Map<String, ImportRunnableTask>> tasksToInterrupt;
    private Future<?> future;
    ParallelAwareImporter parallelAwareImporter;

    protected ImportRunnableTask(SemanticRepository repo, boolean isLocal, RDFFormat fileFormat, ImportSettings settings, ImportStatusService importStatusService, Map<String, Map<String, ImportRunnableTask>> tasksToInterrupt) {
        this.repo = repo;
        this.isLocal = isLocal;
        this.fileFormat = fileFormat;
        this.settings = settings;
        this.importStatusService = importStatusService;
        this.tasksToInterrupt = tasksToInterrupt;
    }

    protected abstract String getEntryName();

    protected abstract void load(ParallelAwareImporter var1) throws Exception;

    void interrupt() {
        this.importStatusService.update(this.repo.getRepositoryID(), this.getEntryName(), ImportStatusService.ImportStatus.INTERRUPTING, this.parallelAwareImporter);
        if (!this.isRunning || !this.isLocal) {
            if (this.future.cancel(true)) {
                this.tasksToInterrupt.get(this.repo.getRepositoryID()).remove(this.getEntryName());
                this.importStatusService.update(this.repo.getRepositoryID(), this.getEntryName(), ImportStatusService.ImportStatus.ERROR, IMPORT_WAS_INTERRUPTED, this.parallelAwareImporter);
            } else {
                this.logger.error("Could not interrupt import. Could not cancel future task for {}", (Object)this.getEntryName());
            }
        } else if (this.parallelAwareImporter != null) {
            this.parallelAwareImporter.interrupt();
        } else {
            this.logger.error("Could not interrupt import. Could not interrupt parallel importer for {}", (Object)this.getEntryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        long start = System.currentTimeMillis();
        try {
            FileSystemHealth.getInstance().canStartTransaction(this.repo.getRepositoryID());
            this.parallelAwareImporter = new ParallelAwareImporter(this.repo, this.settings);
            this.importStatusService.update(this.repo.getRepositoryID(), this.getEntryName(), ImportStatusService.ImportStatus.IMPORTING, this.parallelAwareImporter);
            String headers = this.settings.getRequestIdHeadersToForward();
            if (StringUtils.isNotEmpty((CharSequence)headers)) {
                MDC.put((String)"headers", (String)headers);
            }
            this.load(this.parallelAwareImporter);
            String interval = ImportRunnableTask.toHumanFormatMs(System.currentTimeMillis() - start);
            this.update(this.getEntryName(), String.format("Imported successfully in %s.", interval));
        }
        catch (CancellationException ce) {
            this.logger.info(IMPORT_WAS_INTERRUPTED);
            this.updateError(this.getEntryName(), IMPORT_WAS_INTERRUPTED);
        }
        catch (RDFParseException rpe) {
            this.logger.error("RDF Parse Error ", (Throwable)rpe);
            this.updateError(this.getEntryName(), "RDF Parse Error: " + rpe.getMessage());
        }
        catch (Error | Exception e) {
            this.logger.error(COULD_NOT_IMPORT_FILE, e);
            Throwable throwable = this.unwrapInsufficientDiskSpaceException(e);
            String message = this.cutExceptionMessage(throwable.getMessage());
            this.updateError(this.getEntryName(), message);
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
        finally {
            this.tasksToInterrupt.get(this.repo.getRepositoryID()).remove(this.getEntryName());
            this.isRunning = false;
            if (this.parallelAwareImporter != null) {
                this.parallelAwareImporter.close();
            }
            MDC.remove((String)"headers");
            this.updateImportStatistics(start);
        }
    }

    private Throwable unwrapInsufficientDiskSpaceException(Throwable throwable) {
        Throwable toUnwrwap = throwable;
        while (toUnwrwap.getCause() != null && !(toUnwrwap instanceof InsufficientDiskSpaceException)) {
            if (!((toUnwrwap = toUnwrwap.getCause()) instanceof InsufficientDiskSpaceException)) continue;
            return toUnwrwap;
        }
        return throwable;
    }

    private String cutExceptionMessage(String message) {
        if (message != null) {
            String[] rows = message.split("\n");
            message = Arrays.stream(rows).map(row -> row.length() > 160 ? row.substring(0, 160) + "..." : row).collect(Collectors.joining("\n"));
        } else {
            message = COULD_NOT_IMPORT_FILE;
        }
        return message;
    }

    protected void update(String fileName, String msg) {
        this.importStatusService.update(this.repo.getRepositoryID(), fileName, ImportStatusService.ImportStatus.DONE, msg, this.parallelAwareImporter);
    }

    protected void updateError(String fileName, String msg) {
        this.importStatusService.update(this.repo.getRepositoryID(), fileName, ImportStatusService.ImportStatus.ERROR, msg, this.parallelAwareImporter);
        if (this.parallelAwareImporter != null && StringUtils.isNotEmpty((CharSequence)this.parallelAwareImporter.getPersistFilename())) {
            this.importStatusService.update(this.repo.getRepositoryID(), this.parallelAwareImporter.getPersistFilename(), ImportStatusService.ImportStatus.ERROR, msg, this.parallelAwareImporter);
        }
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    private static String toHumanFormatMs(long milliseconds) {
        if (milliseconds < 1000L) {
            return "less than a second";
        }
        String human = DurationFormatUtils.formatDuration((long)milliseconds, (String)"d'd' H'h' m'm' s's'");
        while (human.startsWith("0") && !human.startsWith("0s")) {
            human = human.substring(3);
        }
        return human;
    }

    private void updateImportStatistics(long start) {
        if (this.repo.getRepository() instanceof MonitorRepository) {
            StatisticsListener statistics = ((MonitorRepository)this.repo.getRepository()).getOwlimSail().getStatistics();
            statistics.accumulateTime(OperationType.IMPORT, System.currentTimeMillis() - start);
        }
    }
}

