/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParserRegistry;

public class ImportFileLister {
    static Map<Path, RDFFormat> listRDFFiles(final Path startPath, final boolean includeDirectories) throws IOException {
        final TreeMap<Path, RDFFormat> files = new TreeMap<Path, RDFFormat>();
        final HashSet visitedSymbolicLinksToSkip = new HashSet();
        if (Files.isDirectory(startPath, new LinkOption[0])) {
            Files.walkFileTree(startPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    RDFFormat rdfFormat = ImportFileLister.getRDFFormat(file);
                    if (rdfFormat != null) {
                        files.put(file, rdfFormat);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (Files.isSymbolicLink(dir) && visitedSymbolicLinksToSkip.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (Files.isSymbolicLink(dir)) {
                        visitedSymbolicLinksToSkip.add(dir);
                    }
                    if (includeDirectories) {
                        this.addDirectories(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                private void addDirectories(Path dir) {
                    while (this.isValid(dir)) {
                        files.put(dir, null);
                        if (Files.isSymbolicLink(dir)) break;
                        dir = dir.getParent();
                    }
                }

                private boolean isValid(Path dir) {
                    return dir != null && !dir.equals(startPath) && !files.containsKey(dir);
                }
            });
        } else {
            RDFFormat rdfFormat = ImportFileLister.getRDFFormat(startPath);
            if (rdfFormat != null) {
                files.put(startPath, rdfFormat);
            }
        }
        return files;
    }

    static RDFFormat getRDFFormat(Path file) {
        String name = file.getFileName().toString();
        if (name.toLowerCase().endsWith(".gz")) {
            name = name.substring(0, name.length() - 3);
        } else if (name.toLowerCase().endsWith(".bz2")) {
            return null;
        }
        Optional fileFormatForFileName = RDFParserRegistry.getInstance().getFileFormatForFileName(name);
        return fileFormatForFileName.orElse(null);
    }
}

