/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.FileImportRunnableTask;
import com.ontotext.forest.impex.ImportController;
import com.ontotext.forest.impex.ImportFileLister;
import com.ontotext.forest.impex.ImportRunnableTask;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportTasksExecutor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.springframework.stereotype.Component;

@Component
public class FileTasksExecutor
extends ImportTasksExecutor<File> {
    public FileTasksExecutor() {
        super("import.server");
    }

    @Override
    protected ImportRunnableTask createTask(SemanticRepository repo, boolean isLocal, File importFile, String fileName, RDFFormat fileFormat, ImportSettings settings) {
        return new FileImportRunnableTask(repo, isLocal, importFile, fileName, fileFormat, settings, this.getStatusService(), this.tasks);
    }

    @Override
    protected void resetStatus(String repository, String name, String importDirectory) throws IOException {
        this.listFilesRecursively(repository, name, importDirectory);
    }

    private void listFilesRecursively(String repository, String name, String importDirectory) throws IOException {
        Path directory = Paths.get(importDirectory, name);
        if (directory.toFile().isDirectory()) {
            Set<Path> rdfFiles = ImportFileLister.listRDFFiles(directory, true).keySet();
            for (Path path : rdfFiles) {
                String fileName = path.toString().substring((importDirectory + "/").length());
                this.getStatusService().clear(repository, fileName);
                ImportController.subTasks.values().remove(fileName);
            }
        }
        this.getStatusService().clear(repository, name);
    }
}

