/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SecurityContext {
    @Nullable
    public String getUsername();

    @Nullable
    public <T> T getClaimValue(String var1, Class<T> var2);

    @NotNull
    public Stream<String> getAuthorities();

    default public boolean isAdmin() {
        return false;
    }

    public static SecurityContext empty() {
        return NoSecurityContext.INSTANCE;
    }

    public static SecurityContext of(String username, Map<String, Object> claims, Collection<String> authorities) {
        return new FixedSecurityContext(username, claims, authorities);
    }

    public static SecurityContext of(String username, Collection<String> authorities) {
        return new FixedSecurityContext(username, null, authorities);
    }

    public static class NoSecurityContext
    implements SecurityContext {
        private static final SecurityContext INSTANCE = new NoSecurityContext();

        @Override
        @Nullable
        public String getUsername() {
            return null;
        }

        @Override
        public <T> T getClaimValue(String claim, Class<T> valueType) {
            return null;
        }

        @Override
        @NotNull
        public Stream<String> getAuthorities() {
            return Stream.empty();
        }
    }

    public static class FixedSecurityContext
    implements SecurityContext {
        private final Collection<String> authorities;
        private final Map<String, Object> claims;
        private final String username;

        FixedSecurityContext(String username, Map<String, Object> claims, Collection<String> authorities) {
            this.username = username;
            this.claims = claims == null ? Map.of() : claims;
            this.authorities = authorities == null ? List.of() : authorities;
        }

        @Override
        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Override
        @Nullable
        public <T> T getClaimValue(String claim, Class<T> valueType) {
            return valueType.cast(this.claims.get(claim));
        }

        @Override
        @NotNull
        public Stream<String> getAuthorities() {
            return this.authorities.stream();
        }
    }
}

