/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import com.ontotext.models.yaml.exceptions.processing.YamlExceptionProcessor;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlExceptionProcessors {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlExceptionProcessors.class);
    private Map<Class, YamlExceptionProcessor> processors;

    public <E extends YAMLException> String process(E yamlException) {
        return Objects.requireNonNull(this.getProcessors().get(((Object)yamlException).getClass()), "Missing processor for " + ((Object)yamlException).getClass().getSimpleName()).process(yamlException);
    }

    private Map<Class, YamlExceptionProcessor> getProcessors() {
        if (this.processors == null) {
            HashMap extensions = new HashMap();
            PluginsManager.loadPlugins(YamlExceptionProcessor.class).forEach(processor -> extensions.put(processor.processes(), processor));
            LOGGER.trace("Loaded {} extensions are: {}", (Object)YamlExceptionProcessor.class.getName(), extensions.keySet());
            this.processors = Collections.unmodifiableMap(extensions);
        }
        return this.processors;
    }
}

