/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionParsingUtil;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionProcessor;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Objects;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.parser.ParserException;

public class ParserExceptionProcessor
implements YamlExceptionProcessor<ParserException> {
    @Override
    public Class<ParserException> processes() {
        return ParserException.class;
    }

    @Override
    public String process(ParserException yamlException) {
        String userMessage = null;
        if (ParserExceptionProcessor.isRelatedTo("flow node", yamlException)) {
            userMessage = ParserExceptionProcessor.buildMessage("yaml.syntax.expected.node.content.found.stream.end", yamlException);
        } else if (ParserExceptionProcessor.isRelatedTo("sequence", yamlException)) {
            userMessage = ParserExceptionProcessor.buildMessage("yaml.syntax.sequence.found.stream.end", yamlException);
        } else if (ParserExceptionProcessor.isRelatedTo("mapping", yamlException)) {
            userMessage = ParserExceptionProcessor.buildMappingMessage(yamlException);
        } else if (ParserExceptionProcessor.isRelatedTo("collection", yamlException)) {
            String ctxLocation = YamlExceptionParsingUtil.getLocationFromMark(yamlException.getContextMark());
            String problemLocation = YamlExceptionParsingUtil.getLocation((YAMLException)yamlException);
            userMessage = ErrorMessages.get("yaml.syntax.mixed.arrays.and.dictionaries", String.join((CharSequence)System.lineSeparator(), ctxLocation, problemLocation));
        }
        return (String)ObjectsUtil.getOrDefaultGet((Object)userMessage, () -> YamlExceptionParsingUtil.failedToProcess((YAMLException)yamlException));
    }

    private static boolean isRelatedTo(String context, ParserException exc) {
        String ctxMsg = Objects.toString(exc.getContext(), exc.getProblem());
        return ctxMsg.endsWith(context);
    }

    private static String buildMessage(String messageKey, ParserException exc) {
        String location = YamlExceptionParsingUtil.getLocation((YAMLException)exc);
        return ErrorMessages.get(messageKey, location);
    }

    private static String buildMappingMessage(ParserException exc) {
        String problem = exc.getProblem();
        if (problem.contains("got <stream end>")) {
            return ParserExceptionProcessor.buildMessage("yaml.syntax.mapping.found.stream.end", exc);
        }
        if (problem.contains("expected <block end>")) {
            String unexpected = YamlExceptionParsingUtil.getUnexpectedChar(problem);
            String location = YamlExceptionParsingUtil.getLocation((YAMLException)exc);
            return ErrorMessages.get("yaml.syntax.mapping.expected.block.end", unexpected, location);
        }
        return null;
    }
}

