/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionParsingUtil;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;

class CustomExceptionProcessor {
    private static final Pattern CUSTOM_ERROR_VALUE = Pattern.compile("(?<=\\$_)(.*)(?=_\\$)");

    private CustomExceptionProcessor() {
    }

    static String processConstructorCustomException(ConstructorException yamlException) {
        String problem = yamlException.getProblem();
        String message = null;
        if (problem.contains("expected enum")) {
            message = CustomExceptionProcessor.handleEnumError(yamlException, problem);
        } else if (problem.contains("expected boolean")) {
            message = CustomExceptionProcessor.handleBooleanError(yamlException, problem);
        } else if (problem.contains("propagate message as is")) {
            message = CustomExceptionProcessor.handleErrorWithMessage(yamlException, problem);
        }
        return (String)ObjectsUtil.getOrDefaultGet((Object)message, () -> YamlExceptionParsingUtil.failedToProcess((YAMLException)yamlException));
    }

    private static String handleEnumError(ConstructorException yamlException, String problem) {
        return ErrorMessages.get("yaml.syntax.invalid.enum.value", YamlExceptionParsingUtil.extractInfo(CUSTOM_ERROR_VALUE, problem), YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
    }

    private static String handleBooleanError(ConstructorException yamlException, String problem) {
        return ErrorMessages.get("yaml.syntax.found.nonboolean.value", YamlExceptionParsingUtil.extractInfo(CUSTOM_ERROR_VALUE, problem), YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
    }

    private static String handleErrorWithMessage(ConstructorException yamlException, String problem) {
        return YamlExceptionParsingUtil.extractInfo(CUSTOM_ERROR_VALUE, problem) + "\n" + YamlExceptionParsingUtil.getLocation((YAMLException)yamlException);
    }
}

