/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Role;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.yaml.exceptions.processing.CustomExceptionProcessor;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionParsingUtil;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionProcessor;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;

public class ConstructorExceptionProcessor
implements YamlExceptionProcessor<ConstructorException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstructorExceptionProcessor.class);
    private static final Pattern PROPERTY_NAME = Pattern.compile("(?<=Unable to find property )(.*)(?= on class)");
    private static final Pattern TAG_MATCHER = Pattern.compile("(?<=Can't construct a java object for scalar )(.*)(?=; exception)");
    private static final Pattern PROPERTY_ARGUMENT = Pattern.compile("(?<=Cannot create property=)(.*)(?= for JavaBean)");

    @Override
    public Class<ConstructorException> processes() {
        return ConstructorException.class;
    }

    @Override
    public String process(ConstructorException yamlException) {
        String message = null;
        String problem = yamlException.getProblem();
        if (this.isCharacteristicRelated(problem)) {
            message = this.handleCharacteristicError(yamlException, problem);
        } else if (problem.contains("Custom error: ")) {
            message = CustomExceptionProcessor.processConstructorCustomException(yamlException);
        } else if (problem.contains("Can't construct a java object for scalar")) {
            String tagStr = YamlExceptionParsingUtil.extractInfo(TAG_MATCHER, problem);
            message = ErrorMessages.get("yaml.syntax.expected.object.found.scalar", TagResolver.resolve(tagStr), YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
        } else if (this.isArgumentRelated(yamlException)) {
            message = this.handleArgumentError(yamlException);
        } else if (problem.contains(TagResolver.SOML_TAG.toString())) {
            message = ErrorMessages.get("yaml.syntax.invalid.schema.format", YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
        }
        return (String)ObjectsUtil.getOrDefaultGet((Object)message, () -> YamlExceptionParsingUtil.failedToProcess((YAMLException)yamlException));
    }

    private boolean isCharacteristicRelated(String message) {
        return StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"Unable to find property");
    }

    private boolean isArgumentRelated(ConstructorException yamlException) {
        Throwable nested = yamlException.getCause();
        while (nested instanceof ConstructorException) {
            nested = nested.getCause();
        }
        return nested instanceof IllegalArgumentException;
    }

    private String handleCharacteristicError(ConstructorException yamlException, String problem) {
        if (problem.contains(Shape.class.getName())) {
            return ErrorMessages.get("yaml.syntax.unexpected.object.property", YamlExceptionParsingUtil.extractInfo(PROPERTY_NAME, problem));
        }
        if (problem.contains(PropertyShape.class.getName())) {
            return ErrorMessages.get("yaml.syntax.unexpected.property.characteristic", YamlExceptionParsingUtil.extractInfo(PROPERTY_NAME, problem), YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
        }
        if (problem.contains(Role.class.getName())) {
            return ErrorMessages.get("yaml.syntax.unexpected.role.characteristic", YamlExceptionParsingUtil.extractInfo(PROPERTY_NAME, problem), YamlExceptionParsingUtil.getContextLocation((YAMLException)yamlException));
        }
        if (problem.contains(SomlSchema.class.getName())) {
            return ErrorMessages.get("yaml.syntax.unexpected.schema.characteristic", YamlExceptionParsingUtil.extractInfo(PROPERTY_NAME, problem));
        }
        return null;
    }

    private String handleArgumentError(ConstructorException yamlException) {
        Throwable parent = yamlException.getCause();
        Throwable nested = parent.getCause();
        while (nested instanceof ConstructorException) {
            parent = parent.getCause();
            nested = parent.getCause();
        }
        String message = nested.getMessage();
        String argument = message.substring(message.indexOf(34) + 1, message.indexOf(34, message.indexOf(34) + 1));
        String problemMark = ((ConstructorException)parent).getProblemMark().toString();
        return ErrorMessages.get("yaml.syntax.invalid.argument", argument, YamlExceptionParsingUtil.extractInfo(PROPERTY_ARGUMENT, parent.getMessage()), problemMark.substring(problemMark.indexOf("line")));
    }

    private static class TagResolver {
        private static final Tag SOML_TAG = new Tag(SomlSchema.class);
        private static final Map<String, String> TAGS = new HashMap<String, String>(14);

        private TagResolver() {
        }

        private static String resolve(String name) {
            String result = TAGS.get(name);
            if (result != null) {
                return result;
            }
            LOGGER.warn("Found unmapped tag or failed to resolve name: {}", (Object)name);
            return name;
        }

        static {
            TAGS.put(Tag.YAML.toString(), "yaml");
            TAGS.put(Tag.SET.toString(), "set");
            TAGS.put(Tag.PAIRS.toString(), "pairs");
            TAGS.put(Tag.OMAP.toString(), "map");
            TAGS.put(Tag.BINARY.toString(), "binary");
            TAGS.put(Tag.INT.toString(), "integer");
            TAGS.put(Tag.FLOAT.toString(), "float");
            TAGS.put(Tag.TIMESTAMP.toString(), "timestamp");
            TAGS.put(Tag.BOOL.toString(), "boolean");
            TAGS.put(Tag.NULL.toString(), "null");
            TAGS.put(Tag.STR.toString(), "string");
            TAGS.put(Tag.SEQ.toString(), "sequence");
            TAGS.put(Tag.MAP.toString(), "map");
            TAGS.put(SOML_TAG.toString(), "SOML");
        }
    }
}

