/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionParsingUtil;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionProcessor;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.composer.ComposerException;
import org.yaml.snakeyaml.error.YAMLException;

public class ComposerExceptionProcessor
implements YamlExceptionProcessor<ComposerException> {
    @Override
    public Class<ComposerException> processes() {
        return ComposerException.class;
    }

    @Override
    public String process(ComposerException yamlException) {
        String exceptionCtx = Objects.toString(yamlException.getContext(), yamlException.getProblem());
        if (exceptionCtx.contains("expected a single document")) {
            return ErrorMessages.get("yaml.syntax.soml.should.be.single.document", YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
        }
        if (exceptionCtx.contains("found undefined alias")) {
            String undefinedAlias = StringUtils.substringAfter((String)exceptionCtx, (String)"undefined alias ");
            return ErrorMessages.get("yaml.syntax.found.undefined.alias", undefinedAlias, YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
        }
        return YamlExceptionParsingUtil.failedToProcess((YAMLException)yamlException);
    }
}

