/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml;

import com.ontotext.models.yaml.OntoCustomConstructor;
import com.ontotext.models.yaml.OntoCustomRepresenter;
import com.ontotext.models.yaml.YamlProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlProcessorBuilder {
    private static final int CODE_POINT_LIMIT = 0xA00000;
    private static final int INITIAL_CAPACITY = 5;
    private final Class<?> root;
    private final Map<Class<?>, Collection<Property>> typesMapping;
    private boolean allowDuplicateKeys = false;

    public YamlProcessorBuilder(Class<?> root) {
        this.root = root;
        this.typesMapping = new HashMap();
    }

    public YamlProcessorBuilder addTypeDefinition(Class<?> inType, String property, Class<?> ... is) {
        this.typesMapping.computeIfAbsent(inType, k -> new ArrayList(5)).add(new Property(property, is));
        return this;
    }

    public YamlProcessorBuilder allowDuplicateKeys() {
        this.allowDuplicateKeys = true;
        return this;
    }

    public YamlProcessor build() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0xA00000);
        loaderOptions.setAllowDuplicateKeys(this.allowDuplicateKeys);
        OntoCustomConstructor constructor = new OntoCustomConstructor(this.root, loaderOptions);
        this.buildTypeDescriptions().forEach(arg_0 -> ((OntoCustomConstructor)constructor).addTypeDescription(arg_0));
        DumperOptions dumperOptions = this.initDumperOptions();
        OntoCustomRepresenter representer = new OntoCustomRepresenter(dumperOptions);
        Yaml yaml = new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions, loaderOptions);
        return new YamlProcessor(yaml);
    }

    private DumperOptions initDumperOptions() {
        return new DumperOptions();
    }

    private Stream<TypeDescription> buildTypeDescriptions() {
        return this.typesMapping.entrySet().stream().map(this.toTypeDescription());
    }

    private Function<Map.Entry<Class<?>, Collection<Property>>, TypeDescription> toTypeDescription() {
        return mapping -> {
            TypeDescription description = new TypeDescription((Class)mapping.getKey());
            ((Collection)mapping.getValue()).forEach(this.addRepresentation(description));
            return description;
        };
    }

    private Consumer<Property> addRepresentation(TypeDescription description) {
        return prop -> description.addPropertyParameters(prop.getName(), (Class[])prop.getRepresentedAs());
    }

    private static class Property {
        private final String propertyName;
        private final Class<?>[] representedAs;

        Property(String propertyName, Class<?>[] representedAs) {
            this.propertyName = propertyName;
            this.representedAs = representedAs;
        }

        String getName() {
            return this.propertyName;
        }

        Class<?>[] getRepresentedAs() {
            return this.representedAs;
        }
    }
}

