/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml;

import com.ontotext.models.search.Analysis;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class OntoCustomConstructor
extends Constructor {
    public OntoCustomConstructor(Class<?> root, LoaderOptions loaderOptions) {
        super(root, loaderOptions);
        this.yamlClassConstructors.put(NodeId.scalar, new CustomScalarConstructorProvider(this));
        this.yamlClassConstructors.put(NodeId.mapping, new CustomMappingConstructor(this));
        this.yamlConstructors.put(Tag.BOOL, new SomlBooleanValueConstructor());
    }

    private class CustomScalarConstructorProvider
    extends Constructor.ConstructScalar {
        private final List<CustomScalarConstructor> constructors = new ArrayList<CustomScalarConstructor>(2);

        private CustomScalarConstructorProvider(OntoCustomConstructor ontoCustomConstructor) {
            super((Constructor)ontoCustomConstructor);
            this.constructors.add(new LocalDateConstructor(ontoCustomConstructor));
            this.constructors.add(new EnumConstructor(ontoCustomConstructor));
        }

        public Object construct(Node node) {
            for (CustomScalarConstructor constructor : this.constructors) {
                if (!constructor.handles(node)) continue;
                return constructor.construct(node);
            }
            return super.construct(node);
        }
    }

    private class CustomMappingConstructor
    extends Constructor.ConstructMapping {
        private CustomMappingConstructor(OntoCustomConstructor ontoCustomConstructor) {
            super((Constructor)ontoCustomConstructor);
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            if (object instanceof Analysis) {
                try {
                    return super.constructJavaBean2ndStep(node, object);
                }
                catch (Exception exc) {
                    String message = this.getOrigin(exc).getMessage();
                    throw new YAMLException("Custom error: propagate message as is $_" + message + "_$");
                }
            }
            return super.constructJavaBean2ndStep(node, object);
        }

        private Throwable getOrigin(Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause == null) {
                return throwable;
            }
            return this.getOrigin(cause);
        }
    }

    private class SomlBooleanValueConstructor
    extends SafeConstructor.ConstructYamlBool {
        private SomlBooleanValueConstructor() {
            super((SafeConstructor)OntoCustomConstructor.this);
        }

        public Object construct(Node node) {
            if (!Boolean.class.equals((Object)node.getType())) {
                return super.construct(node);
            }
            String value = OntoCustomConstructor.this.constructScalar((ScalarNode)node);
            if (StringUtils.isBlank((CharSequence)value)) {
                return Boolean.FALSE;
            }
            switch (value.toLowerCase()) {
                case "true": {
                    return Boolean.TRUE;
                }
                case "false": {
                    return Boolean.FALSE;
                }
            }
            throw new YAMLException("Custom error: expected boolean $_" + value + "_$");
        }
    }

    private class EnumConstructor
    implements CustomScalarConstructor {
        private EnumConstructor(OntoCustomConstructor ontoCustomConstructor) {
        }

        @Override
        public boolean handles(Node node) {
            return Enum.class.isAssignableFrom(node.getType());
        }

        @Override
        public Object construct(Node node) {
            String value = ((ScalarNode)ScalarNode.class.cast(node)).getValue();
            try {
                return Enum.valueOf((Class)Class.class.cast(node.getType()), StringUtils.upperCase((String)value));
            }
            catch (IllegalArgumentException iae) {
                throw new YAMLException("Custom error: expected enum $_" + value + "_$");
            }
        }
    }

    private class LocalDateConstructor
    implements CustomScalarConstructor {
        private LocalDateConstructor(OntoCustomConstructor ontoCustomConstructor) {
        }

        @Override
        public boolean handles(Node node) {
            return LocalDate.class.equals((Object)node.getType());
        }

        @Override
        public Object construct(Node node) {
            return LocalDate.parse(((ScalarNode)ScalarNode.class.cast(node)).getValue());
        }
    }

    private static interface CustomScalarConstructor {
        public boolean handles(Node var1);

        public Object construct(Node var1);
    }
}

