/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.templates;

import com.ontotext.models.templates.BasicTemplate;
import com.ontotext.models.templates.PropertyRef;
import com.ontotext.models.templates.TemplateArgs;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public interface Template {
    public static final String ARG_NAME = "args";

    public static Template create(String name, String template) {
        return new BasicTemplate(name, template);
    }

    public String getName();

    public String get();

    public Map<String, TemplateArgs> getKeys();

    default public boolean hasArgs() {
        return !this.getKeys().isEmpty();
    }

    default public boolean optionalArgs() {
        return this.getKeys().values().stream().allMatch(TemplateArgs::isOptional);
    }

    default public Set<PropertyRef> getExternalPropertyBindings() {
        return Collections.emptySet();
    }

    public String apply(Object var1);

    public Template getParentTemplate();

    public void setParentTemplate(Template var1);

    public List<Template> getSubTemplates();

    public void addSubTemplate(Template var1);

    default public Stream<Template> streamTemplates() {
        return Stream.concat(Stream.of(this), this.getSubTemplates().stream().flatMap(Template::streamTemplates));
    }

    default public Template getRootTemplate() {
        if (this.getParentTemplate() == null) {
            return this;
        }
        return this.getParentTemplate().getRootTemplate();
    }

    public static void linkTemplates(Template parent, Template child) {
        if (parent != null && child != null && parent != child && !parent.getName().equals(child.getName())) {
            parent.addSubTemplate(child);
            child.setParentTemplate(parent);
        }
    }
}

