/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.templates;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class PropertyRef {
    private static final String SUBJECT = "_subject";
    private static final String VALUE = "_value";
    private final String varName;
    private final String[] segments;

    public PropertyRef(String varName) {
        this.varName = Objects.requireNonNull(varName, "reference path cannot be null");
        this.segments = varName.split("\\.");
    }

    public boolean isInternal() {
        return this.varName.startsWith("_");
    }

    public boolean isNested() {
        return this.segments.length > 1;
    }

    public boolean isSubjectBased() {
        return this.segments[0].equals(SUBJECT) || !this.segments[0].equals(VALUE);
    }

    public boolean isValueBased() {
        return this.segments[0].equals(VALUE);
    }

    public Stream<String> segments() {
        if (this.segments[0].equals(SUBJECT) || this.segments[0].equals(VALUE)) {
            return Arrays.stream(this.segments, 1, this.segments.length);
        }
        return Stream.of(this.segments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyRef)) {
            return false;
        }
        PropertyRef that = (PropertyRef)obj;
        return this.varName.equals(that.varName);
    }

    public int hashCode() {
        return Objects.hash(this.varName);
    }

    public String toString() {
        return this.varName;
    }
}

