/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.shacl;

import com.ontotext.models.shacl.ShaclNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ShaclContainerNode
implements ShaclNode {
    private final String name;
    private final boolean isBlank;
    private List<ShaclNode> subNodes = new LinkedList<ShaclNode>();

    protected ShaclContainerNode(String name, boolean isBlank) {
        this(name, isBlank, null);
    }

    public ShaclContainerNode(String name, boolean isBlank, ShaclNode shaclNode) {
        this.name = name;
        this.isBlank = isBlank;
        if (null != shaclNode) {
            this.subNodes.add(shaclNode);
        }
    }

    public ShaclContainerNode(ShaclContainerNode clone) {
        this.name = clone.getName();
        this.isBlank = clone.isBlank();
        this.subNodes = new LinkedList<ShaclNode>(clone.getSubNodes());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSubNodes(List<ShaclNode> subNodes) {
        this.subNodes = subNodes;
    }

    public List<ShaclNode> getSubNodes() {
        return this.subNodes;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public List<ShaclNode> appendToNodes(ShaclNode newNode) {
        this.subNodes.add(newNode);
        return this.subNodes;
    }

    @Override
    public Object getValue() {
        LinkedHashMap values = new LinkedHashMap();
        this.subNodes.forEach(node -> values.computeIfAbsent(node.getName(), key -> new ArrayList()).add(node.getValue()));
        return values;
    }

    @Override
    public void addValues(Object value) {
        if (value instanceof ShaclNode) {
            this.subNodes.add((ShaclNode)value);
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(this::addValues);
        } else {
            throw new IllegalArgumentException("Trying to insert a Non-SHACL node in a SHACL container");
        }
    }

    @Override
    public String toTurtle() {
        if (this.subNodes.isEmpty()) {
            throw new IllegalArgumentException("Empty SHACL container node detected.");
        }
        if (this.isBlank) {
            return this.subNodes.stream().map(ShaclNode::toTurtle).collect(Collectors.joining(""));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("sh").append(":").append(this.getName());
        builder.append(this.subNodes.stream().map(ShaclNode::toTurtle).collect(Collectors.joining("][", "( [", "] ) ;")));
        return builder.toString();
    }
}

