/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.shacl;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.ShaclTargetNode;
import com.ontotext.models.shacl.ConstraintContext;
import com.ontotext.models.shacl.Datatype;
import com.ontotext.models.shacl.Equals;
import com.ontotext.models.shacl.HasValue;
import com.ontotext.models.shacl.HasValueIn;
import com.ontotext.models.shacl.In;
import com.ontotext.models.shacl.LangIn;
import com.ontotext.models.shacl.MaxCount;
import com.ontotext.models.shacl.MaxExclusive;
import com.ontotext.models.shacl.MaxInclusive;
import com.ontotext.models.shacl.MaxLength;
import com.ontotext.models.shacl.MinCount;
import com.ontotext.models.shacl.MinExclusive;
import com.ontotext.models.shacl.MinInclusive;
import com.ontotext.models.shacl.MinLength;
import com.ontotext.models.shacl.Pattern;
import com.ontotext.models.shacl.PatternFlags;
import com.ontotext.models.shacl.QualifiedMaxCount;
import com.ontotext.models.shacl.QualifiedMinCount;
import com.ontotext.models.shacl.QualifiedValueShape;
import com.ontotext.models.shacl.ShaclNode;
import com.ontotext.models.shacl.ShapeReference;
import com.ontotext.models.shacl.UniqueLang;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public enum ShaclConstraint {
    DATATYPE(SHACL.DATATYPE, SHACL.DATATYPE_CONSTRAINT_COMPONENT, Datatype::new),
    FLAGS(SHACL.FLAGS, SHACL.PATTERN_CONSTRAINT_COMPONENT_FLAGS, ShaclConstraint::processFlags),
    HAS_VALUE(SHACL.HAS_VALUE, SHACL.HAS_VALUE_CONSTRAINT_COMPONENT, ShaclConstraint::processHasValue),
    MAX_COUNT(SHACL.MAX_COUNT, SHACL.MAX_COUNT_CONSTRAINT_COMPONENT, ShaclConstraint::processMaxCount),
    MAX_LENGTH(SHACL.MAX_LENGTH, SHACL.MAX_LENGTH_CONSTRAINT_COMPONENT, MaxLength::new),
    MIN_COUNT(SHACL.MIN_COUNT, SHACL.MIN_COUNT_CONSTRAINT_COMPONENT, ShaclConstraint::processMinCount),
    MIN_LENGTH(SHACL.MIN_LENGTH, SHACL.MIN_LENGTH_CONSTRAINT_COMPONENT, MinLength::new),
    NODE(SHACL.NODE, SHACL.NODE_CONSTRAINT_COMPONENT, ShapeReference::new),
    PATTERN(SHACL.PATTERN, SHACL.PATTERN_CONSTRAINT_COMPONENT, ShaclConstraint::processPattern),
    MIN_INCLUSIVE(SHACL.MIN_INCLUSIVE, SHACL.MIN_INCLUSIVE_CONSTRAINT_COMPONENT, MinInclusive::new),
    MAX_INCLUSIVE(SHACL.MAX_INCLUSIVE, SHACL.MAX_INCLUSIVE_CONSTRAINT_COMPONENT, MaxInclusive::new),
    MAX_EXCLUSIVE(SHACL.MAX_EXCLUSIVE, SHACL.MAX_EXCLUSIVE_CONSTRAINT_COMPONENT, MaxExclusive::new),
    MIN_EXCLUSIVE(SHACL.MIN_EXCLUSIVE, SHACL.MIN_EXCLUSIVE_CONSTRAINT_COMPONENT, MinExclusive::new),
    UNIQUE_LANG(SHACL.UNIQUE_LANG, SHACL.UNIQUE_LANG_CONSTRAINT_COMPONENT, UniqueLang::new),
    LANG_IN(SHACL.LANGUAGE_IN, SHACL.LANGUAGE_IN_CONSTRAINT_COMPONENT, LangIn::new),
    EQUALS(SHACL.EQUALS, SHACL.EQUALS_CONSTRAINT_COMPONENT, Equals::new),
    IN(SHACL.IN, SHACL.IN_CONSTRAINT_COMPONENT, In::new),
    HAS_VALUE_IN(DASH.hasValueIn, DASH.HasValueInConstraintComponent, HasValueIn::new),
    QUALIFIED_VALUE_SHAPE(SHACL.QUALIFIED_VALUE_SHAPE, SHACL.QUALIFIED_VALUE_SHAPE, ShaclConstraint::processQualifiedValueShape),
    QUALIFIED_MAX_COUNT(SHACL.QUALIFIED_MAX_COUNT, SHACL.QUALIFIED_MAX_COUNT_CONSTRAINT_COMPONENT, QualifiedMaxCount::new),
    QUALIFIED_MIN_COUNT(SHACL.QUALIFIED_MIN_COUNT, SHACL.QUALIFIED_MIN_COUNT_CONSTRAINT_COMPONENT, QualifiedMinCount::new);

    private static final Map<String, ShaclConstraint> constraintLookup;
    private final IRI name;
    private final IRI reportName;
    private final Function<ConstraintContext, ShaclNode> builder;

    private ShaclConstraint(IRI name, IRI reportName, Function<ConstraintContext, ShaclNode> builder) {
        this.name = name;
        this.reportName = reportName;
        this.builder = builder;
    }

    public IRI getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getLocalReportName() {
        return this.reportName.getLocalName();
    }

    public Function<ConstraintContext, ShaclNode> getBuilder() {
        return this.builder;
    }

    public static String toTurtleString(String rawString) {
        if (rawString.contains("\"")) {
            rawString = rawString.replace("\"", "\\\"");
        }
        if (rawString.contains("\n")) {
            rawString = rawString.replace("\n", "\\n");
        }
        if (rawString.contains("\r")) {
            rawString = rawString.replace("\r", "\\r");
        }
        return "\"" + rawString + "\"";
    }

    public static String toShaclTargetReference(PropertyShape somlProp, ShaclSchema shaclSchema) {
        ShaclTargetNode targetRef = shaclSchema.getShaclTargetNode(somlProp.getRange());
        String innerTurtle = targetRef.getShapeTypes().toTurtle();
        return "[ " + innerTurtle + " ]";
    }

    private static HasValue processHasValue(ConstraintContext context) {
        String normalizedValue = null;
        Object value = context.getConstraintValue();
        if (value instanceof String) {
            normalizedValue = Boolean.TRUE.equals(context.isTargetScalar()) ? StringUtils.wrapIfMissing((String)((String)value), (char)'\"') : (String)value;
        } else if (value instanceof Literal) {
            normalizedValue = ((Literal)value).getDatatype().getLocalName().equals(XSD.STRING.getLocalName()) ? StringUtils.wrapIfMissing((String)value.toString(), (char)'\"') : value.toString();
        }
        if (null == normalizedValue) {
            throw new IllegalArgumentException("Value for sh:hasValue has not been converted!");
        }
        return new HasValue(normalizedValue);
    }

    private static ShaclNode processQualifiedValueShape(ConstraintContext context) {
        Object value = context.getConstraintValue();
        if (!(value instanceof ShaclNode)) {
            throw new IllegalArgumentException(String.format("Trying to add a non-node value, %s, to a qualifiedValueShape!", value));
        }
        QualifiedValueShape valueShape = new QualifiedValueShape();
        valueShape.appendToNodes((ShaclNode)value);
        return valueShape;
    }

    public static ShaclConstraint forReport(String reportName) {
        if (null == reportName) {
            return null;
        }
        return constraintLookup.get(reportName);
    }

    private static ShaclNode processPattern(ConstraintContext context) {
        Object value = context.getConstraintValue();
        if (value instanceof String) {
            return new Pattern(ShaclConstraint.toTurtleString((String)value));
        }
        if (value instanceof List && !((List)value).isEmpty() && null != ((List)value).get(0)) {
            return new Pattern(ShaclConstraint.toTurtleString((String)((List)value).get(0)));
        }
        return null;
    }

    private static ShaclNode processFlags(ConstraintContext context) {
        Object value = context.getConstraintValue();
        if (value instanceof String) {
            return new PatternFlags(ShaclConstraint.toTurtleString((String)value));
        }
        if (value instanceof List && ((List)value).size() > 1 && null != ((List)value).get(1)) {
            return new PatternFlags(ShaclConstraint.toTurtleString((String)((List)value).get(1)));
        }
        return null;
    }

    private static ShaclNode processMinCount(ConstraintContext context) {
        Object value = context.getConstraintValue();
        if (value instanceof String) {
            return new MinCount(Integer.parseInt((String)value));
        }
        return new MinCount((Integer)value);
    }

    private static ShaclNode processMaxCount(ConstraintContext context) {
        Object value = context.getConstraintValue();
        if ("inf".equals(value)) {
            return null;
        }
        if (value instanceof String) {
            return new MaxCount(Integer.parseInt((String)value));
        }
        return new MaxCount((Integer)value);
    }

    public boolean isLengthConstraint() {
        return this.getLocalName().equals(MAX_LENGTH.getLocalName()) || this.getLocalName().equals(MIN_LENGTH.getLocalName());
    }

    static {
        constraintLookup = new HashMap<String, ShaclConstraint>();
        for (ShaclConstraint constraint : ShaclConstraint.values()) {
            constraintLookup.put(constraint.getLocalReportName(), constraint);
        }
    }
}

