/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.security;

import com.ontotext.models.RoleAction;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.SimpleActionFilter;
import com.ontotext.models.security.Role;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ModelRestrictions {
    private final String modelId;
    private final Map<String, Map<RoleActionType, Set<SimpleActionFilter>>> actions = new LinkedHashMap<String, Map<RoleActionType, Set<SimpleActionFilter>>>(8);
    private final Map<String, Map<RoleActionType, Set<SimpleActionFilter>>> notActions = new LinkedHashMap<String, Map<RoleActionType, Set<SimpleActionFilter>>>(4);
    private final Map<String, Set<RoleAction>> actionsMapping = new LinkedHashMap<String, Set<RoleAction>>();
    private final Map<String, Set<RoleAction>> notActionsMapping = new LinkedHashMap<String, Set<RoleAction>>();

    ModelRestrictions(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    void addAction(RoleAction action) {
        this.insertAction(action, this.actions);
        this.mapAction(action, this.actionsMapping);
    }

    void addNotAction(RoleAction notAction) {
        this.insertAction(notAction, this.notActions);
        this.mapAction(notAction, this.notActionsMapping);
    }

    private void insertAction(RoleAction action, Map<String, Map<RoleActionType, Set<SimpleActionFilter>>> mapping) {
        String role = action.getContainedIn().getName();
        Set filters = mapping.computeIfAbsent(role, k -> new EnumMap(RoleActionType.class)).computeIfAbsent(action.getActionType(), k -> new HashSet(2, 0.95f));
        if (action.getActionFilter() != null) {
            filters.add(action.getActionFilter());
        }
    }

    private void mapAction(RoleAction action, Map<String, Set<RoleAction>> mapping) {
        String role = action.getContainedIn().getName();
        mapping.computeIfAbsent(role, pred -> new LinkedHashSet(2, 0.95f)).add(action);
    }

    boolean hasAction(Set<Role> roles, RoleActionType type, Consumer<SimpleActionFilter> filterConsumer) {
        return this.hasRestriction(this.actions, roles, type, filterConsumer);
    }

    boolean hasNotAction(Set<Role> roles, RoleActionType type, Consumer<SimpleActionFilter> filterConsumer) {
        return this.hasRestriction(this.notActions, roles, type, filterConsumer);
    }

    public Set<String> getAllRoles() {
        return this.actionsMapping.keySet();
    }

    public Map<String, Set<RoleAction>> getAllRoleActions() {
        return this.actionsMapping;
    }

    public Map<String, Set<RoleAction>> getReadRoleActions() {
        return this.getFilteredActions(RoleActionType.READ);
    }

    public Map<String, Set<RoleAction>> getWriteRoleActions() {
        return this.getFilteredActions(RoleActionType.WRITE);
    }

    public Map<String, Set<RoleAction>> getDeleteRoleActions() {
        return this.getFilteredActions(RoleActionType.DELETE);
    }

    private Map<String, Set<RoleAction>> getFilteredActions(RoleActionType actionType) {
        return this.actionsMapping.entrySet().stream().filter(entry -> this.isRoleActionAllowed((Set)entry.getValue(), actionType)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, ModelRestrictions.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        };
    }

    private boolean hasRestriction(Map<String, Map<RoleActionType, Set<SimpleActionFilter>>> roleActionsMapping, Set<Role> roles, RoleActionType type, Consumer<SimpleActionFilter> filterConsumer) {
        if (!roleActionsMapping.isEmpty()) {
            boolean allow = false;
            for (Role role : roles) {
                Map<RoleActionType, Set<SimpleActionFilter>> actionTypes = roleActionsMapping.get(role.getName());
                if (actionTypes == null || !ModelRestrictions.isActionAllowed(actionTypes, type)) continue;
                this.consumeIfNotNull(actionTypes, type, filterConsumer);
                this.consumeIfNotNull(actionTypes, RoleActionType.ALL, filterConsumer);
                allow = true;
            }
            return allow;
        }
        return false;
    }

    private void consumeIfNotNull(Map<RoleActionType, Set<SimpleActionFilter>> actionTypes, RoleActionType type, Consumer<SimpleActionFilter> filterConsumer) {
        Set<SimpleActionFilter> filters = actionTypes.get((Object)type);
        if (filters != null) {
            filters.forEach(filterConsumer);
        }
    }

    private static boolean isActionAllowed(Map<RoleActionType, Set<SimpleActionFilter>> types, RoleActionType type) {
        return types.containsKey((Object)type) || types.containsKey((Object)RoleActionType.ALL);
    }

    private boolean isRoleActionAllowed(Set<RoleAction> types, RoleActionType type) {
        return types.stream().map(RoleAction::getActionType).anyMatch(actionType -> actionType.equals((Object)type) || RoleActionType.ALL.equals(actionType));
    }
}

