/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.search;

import com.ontotext.models.ModelTracker;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.search.Analysis;
import com.ontotext.models.search.ImmutableSearchConfig;
import com.ontotext.models.search.Type;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class SearchConfig
implements TrackedModel,
YamlRepresentable {
    public static final SearchConfig DEFAULT = ImmutableSearchConfig.getInstance();
    public static final String INDEX_FIELD = "index";
    public static final String NESTED_FIELD = "nested";
    public static final String FILTER_FIELD = "filter";
    public static final String ANALYSIS_FIELD = "analysis";
    public static final String CRON_FIELD = "cron";
    public static final String TYPE_FIELD = "type";
    private Index index;
    private String filter;
    private Analysis analysis;
    private String cron;
    private Boolean nested;
    private Type type;
    private ModelTracker tracker = ModelTracker.notTracked();

    public SearchConfig() {
        this.tracker = ModelTracker.tracked();
    }

    public SearchConfig(boolean notTracked) {
    }

    public SearchConfig(SearchConfig copy) {
        this();
        this.index = copy.index;
        this.nested = copy.nested;
        this.filter = copy.filter;
        this.type = Type.parse(copy.type);
        if (copy.analysis != null) {
            this.analysis = new Analysis(copy.getAnalysis());
        }
        this.cron = copy.cron;
        this.copyTrackInformation(copy);
        this.stopTracking();
    }

    public static SearchConfig fromMap(Map search) {
        if (search == null) {
            return null;
        }
        SearchConfig config = new SearchConfig();
        config.setIndex((Index)((Object)search.get(INDEX_FIELD)));
        config.setNested((Boolean)search.get(NESTED_FIELD));
        config.setFilter((String)search.get(FILTER_FIELD));
        config.setAnalysis(Analysis.fromMap((Map)search.get(ANALYSIS_FIELD)));
        config.setCron((String)search.get(CRON_FIELD));
        config.setType(Type.parse(search.get(TYPE_FIELD)));
        return config;
    }

    private void copyTrackInformation(SearchConfig copy) {
        if (copy.isTracked(INDEX_FIELD)) {
            this.tracker.trackModelEntry(INDEX_FIELD);
        }
        if (copy.isTracked(FILTER_FIELD)) {
            this.tracker.trackModelEntry(FILTER_FIELD);
        }
        if (copy.isTracked(ANALYSIS_FIELD)) {
            this.tracker.trackModelEntry(ANALYSIS_FIELD);
        }
        if (copy.isTracked(CRON_FIELD)) {
            this.tracker.trackModelEntry(CRON_FIELD);
        }
        if (copy.isTracked(NESTED_FIELD)) {
            this.tracker.trackModelEntry(NESTED_FIELD);
        }
        if (copy.isTracked(TYPE_FIELD)) {
            this.tracker.trackModelEntry(TYPE_FIELD);
        }
    }

    public void merge(SearchConfig other) {
        if (other == null) {
            return;
        }
        this.index = (Index)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.index), (Object)((Object)other.index)));
        this.nested = (Boolean)ObjectUtils.defaultIfNull((Object)this.nested, (Object)other.nested);
        this.filter = (String)ObjectUtils.defaultIfNull((Object)this.filter, (Object)other.filter);
        if (!this.isSearchable()) {
            return;
        }
        if (this.analysis == null) {
            if (other.analysis != null) {
                this.analysis = new Analysis(other.analysis);
            }
        } else {
            this.analysis.merge(other.analysis);
        }
        if (this.type == null) {
            if (other.type != null) {
                this.type = Type.parse(other.type);
            }
        } else {
            this.type.merge(other.type);
        }
        this.cron = (String)ObjectUtils.defaultIfNull((Object)this.cron, (Object)other.cron);
    }

    public boolean isSearchable() {
        return Index.TRUE.equals((Object)this.getIndex()) || this.getIndex() == null && this.nested == null && (this.analysis != null && this.isTracked(ANALYSIS_FIELD) || this.type != null && this.isTracked(TYPE_FIELD));
    }

    public void setIndex(Index index) {
        this.index = index;
        this.tracker.trackValue(INDEX_FIELD, (Object)index);
    }

    public Index getIndex() {
        return this.index == null ? null : this.index.getActualValue();
    }

    public Boolean isNested() {
        return this.nested != null && this.nested != false;
    }

    public void setNested(Boolean nested) {
        this.nested = nested;
        this.tracker.trackValue(NESTED_FIELD, nested);
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(Analysis analysis) {
        this.analysis = analysis;
        this.tracker.trackValue(ANALYSIS_FIELD, analysis);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.tracker.trackValue(FILTER_FIELD, filter);
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
        this.tracker.trackValue(CRON_FIELD, cron);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.filter, this.analysis, this.cron});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchConfig other = (SearchConfig)obj;
        return Objects.equals((Object)this.index, (Object)other.index) && Objects.equals(this.nested, other.nested) && Objects.equals(this.filter, other.filter) && Objects.equals(this.analysis, other.analysis) && Objects.equals(this.cron, other.cron) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        return new YamlPrinter(configuration).newLine().addString(INDEX_FIELD, (Object)this.index, 4).addString(NESTED_FIELD, this.nested, 4).addString(FILTER_FIELD, this.filter, 4).addString(ANALYSIS_FIELD, this.analysis, 4).addString(CRON_FIELD, this.cron, 4).addYaml(TYPE_FIELD, this.type, 4).asString();
    }

    public String toString() {
        return String.format("{index=%s, nested=%s, filter=%s, analysis=%s, cron=%s, type=%s}", new Object[]{this.index, this.nested, this.filter, this.analysis, this.cron, this.type});
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        if (this.analysis != null) {
            this.analysis.clearTrackedInformation();
        }
        if (this.type != null) {
            this.type.clearTrackedInformation();
        }
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        if (this.analysis != null) {
            this.analysis.startTracking();
        }
        if (this.type != null) {
            this.type.startTracking();
        }
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        if (this.analysis != null) {
            this.analysis.stopTracking();
        }
        if (this.type != null) {
            this.type.stopTracking();
        }
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = Type.parse(type);
        this.tracker.trackValue(TYPE_FIELD, type);
    }

    public static enum Index {
        TRUE,
        FALSE,
        YES(TRUE),
        NO(FALSE);

        private final Index actualValue;

        private Index() {
            this.actualValue = this;
        }

        private Index(Index actualValue) {
            this.actualValue = actualValue;
        }

        Index getActualValue() {
            return this.actualValue;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

