/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.sanitizing;

import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.StringManipulation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SchemaSanitizerUtils {
    private static final Pattern SANITIZABLE_CHARS = Pattern.compile("[.-]");

    private SchemaSanitizerUtils() {
    }

    public static String sanitizeValue(String value) {
        Pair<String, String> pair = SchemaSanitizerUtils.convertIfSanitizable(value);
        return pair != null ? (String)pair.getRight() : value;
    }

    public static Pair<String, String> convertIfSanitizable(String value) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)value) && (matcher = SANITIZABLE_CHARS.matcher(value)).find()) {
            String sanitizedValue = matcher.replaceAll("_");
            return Pair.of((Object)value, (Object)sanitizedValue);
        }
        return null;
    }

    public static <V, M extends Map<String, V>> Map<String, String> sanitizeMap(M map, OperationResponse report) {
        HashMap<String, Set<String>> ambiguous = new HashMap<String, Set<String>>();
        Map<String, List<String>> gqlNamesMapping = SchemaSanitizerUtils.getGraphQlMapping(map);
        Map<String, String> sanitizedValues = map.keySet().stream().map(SchemaSanitizerUtils::convertIfSanitizable).filter(Objects::nonNull).map(SchemaSanitizerUtils.collectAmbiguous(ambiguous, gqlNamesMapping)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (v1, v2) -> v1));
        SchemaSanitizerUtils.reportAmbuguousIfAny(ambiguous, report);
        if (!report.isValid()) {
            return Collections.emptyMap();
        }
        sanitizedValues.forEach((val, sanitizedVal) -> map.put(sanitizedVal, map.remove(val)));
        return sanitizedValues;
    }

    private static <V, M extends Map<String, V>> Map<String, List<String>> getGraphQlMapping(M map) {
        return map.keySet().stream().collect(Collectors.groupingBy(StringManipulation::replaceColonWithUnderscore, Collectors.toList()));
    }

    private static UnaryOperator<Pair<String, String>> collectAmbiguous(Map<String, Set<String>> ambiguous, Map<String, List<String>> map) {
        return pair -> {
            String gqlName = StringManipulation.replaceColonWithUnderscore((String)((String)pair.getRight()));
            Set set = ambiguous.computeIfAbsent(gqlName, val -> new HashSet(2));
            set.add((String)pair.getLeft());
            if (map.containsKey(gqlName)) {
                set.addAll((Collection)map.get(gqlName));
            }
            return pair;
        };
    }

    private static void reportAmbuguousIfAny(Map<String, Set<String>> ambiguous, OperationResponse report) {
        ambiguous.forEach((sanitized, values) -> report.addErrorMessageIf(values.size() > 1, "schema.sanitizing.detected.ambiguous.names", values, sanitized));
    }

    public static String resolveIfPrefixed(String name, Map<String, String> namespaces, Map<String, String> sanitizedNames) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            String[] parts = name.split(":", 2);
            if (parts.length == 1) {
                return (String)ObjectsUtil.getOrDefault((Object)sanitizedNames.get(parts[0]), (Object)parts[0]);
            }
            if (parts.length == 2) {
                String prefix = (String)ObjectsUtil.getOrDefault((Object)namespaces.get(parts[0]), (Object)parts[0]);
                String sanitizedName = (String)ObjectsUtil.getOrDefault((Object)sanitizedNames.get(parts[1]), (Object)parts[1]);
                return prefix + ":" + sanitizedName;
            }
        }
        return null;
    }

    @Nullable
    public static String keyToDisplayLabel(String key) {
        int index = key.lastIndexOf(58);
        if (index > 0) {
            key = key.substring(index + 1);
        }
        String[] strings = StringUtils.splitByCharacterTypeCamelCase((String)key);
        StringBuilder builder = new StringBuilder();
        for (String item : strings) {
            if (!Character.isLetterOrDigit(item.charAt(0))) continue;
            builder.append(StringUtils.capitalize((String)item)).append(' ');
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }
}

