/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.query.AbstractExpressionTerm;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import java.util.Objects;

public class Node
extends AbstractExpressionTerm<Expression> {
    private final String property;
    private final Shape shape;
    private final PropertyShape propertyShape;
    private boolean isUCase = false;

    public Node(String property, Shape shape, PropertyShape propertyShape, boolean isUCase, Expression value) {
        super(value == null ? new And() : value);
        this.property = property;
        this.shape = shape;
        this.propertyShape = propertyShape;
        this.isUCase = isUCase;
    }

    public Node(String property, Shape shape, PropertyShape propertyShape, Expression value) {
        this(property, shape, propertyShape, false, value);
    }

    public Node(String property, Shape shape, PropertyShape propertyShape) {
        super(new ExpressionCollection());
        this.property = property;
        this.shape = shape;
        this.propertyShape = propertyShape;
    }

    public Node append(ExpressionTerm<?> term) {
        ((Expression)this.getValue()).addTerm(term);
        return this;
    }

    public Node setSubExpression(Expression subExpression) {
        this.setValue(subExpression);
        return this;
    }

    @Override
    public String getName() {
        return this.property;
    }

    public Shape getShape() {
        return this.shape;
    }

    public PropertyShape getPropertyShape() {
        return this.propertyShape;
    }

    @Override
    public <R, C extends ExpressionVisitorContext> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public Node deepCopy() {
        return new Node(this.property, this.shape, this.propertyShape, this.isUCase, (Expression)this.getValueCopy());
    }

    public boolean isExistsCheck() {
        Expression expression = (Expression)this.getValue();
        return (expression instanceof And || expression instanceof ExpressionCollection) && expression.getTerms().isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node that = (Node)obj;
        return Objects.equals(this.getPropertyShape().getRdfProperty(), that.getPropertyShape().getRdfProperty()) && Objects.equals(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPropertyShape().getRdfProperty(), this.getValue());
    }

    public boolean isUCase() {
        return this.isUCase;
    }

    public void setIsUCase(boolean isPropertyUcase) {
        this.isUCase = isPropertyUcase;
    }
}

