/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.LangValidator;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class LangFilter {
    private static final Pattern INVALID_SEPARATORS = Pattern.compile("[^-~,\\w]", 256);
    private static final String BROWSER = "BROWSER";
    private static final Pattern BROWSER_EXTRACT_PATTERN = Pattern.compile("\\[BROWSER:(.+)]");
    private static final String LANG = "lang";
    private static final String INVALID_MULTIPLE_WILDCARD_TOKENS = "literal.invalid.multipleWildcardTokens";
    private static final String ANY_LANG = "~";
    private final FilterType type;
    private List<Token> tokens = new ArrayList<Token>();
    private ExpressionValue<?> expression;
    private BrowserTokenGroup browserToken;

    public LangFilter(String value, FilterType type) {
        this.type = type;
        this.parseValue(value);
    }

    LangFilter(List<Token> tokens, FilterType type) {
        this.tokens.addAll(tokens);
        this.type = type;
    }

    private void parseValue(String value) {
        int index;
        value = this.checkAndParseBrowser(value);
        value = this.checkAndParseAll(value);
        value = this.checkAndParseUniq(value);
        value = StringUtils.trimToEmpty((String)value);
        this.tokens.addAll(LangFilter.parseTokens(value));
        if (this.browserToken != null && (index = this.tokens.indexOf(BrowserTokenGroup.EMPTY)) >= 0) {
            this.tokens.set(index, this.browserToken);
        }
        this.type.validate(this.tokens);
    }

    private String checkAndParseBrowser(String value) {
        Matcher matcher = BROWSER_EXTRACT_PATTERN.matcher(value);
        if (matcher.find()) {
            String langsToParse = matcher.group(1);
            List<Token> browserTokens = LangFilter.parseTokens(langsToParse);
            this.browserToken = new BrowserTokenGroup(browserTokens);
            return matcher.replaceAll(BROWSER);
        }
        return value;
    }

    private static List<Token> parseTokens(String value) {
        LangFilter.checkForInvalidSeparators(value);
        String[] split = value.split(",");
        if (split.length == 0) {
            throw BaseToken.createInvalidLangError(value);
        }
        return Arrays.stream(split).map(BaseToken::parse).collect(Collectors.toList());
    }

    private static void checkForInvalidSeparators(String value) {
        Matcher matcher = INVALID_SEPARATORS.matcher(value);
        if (!matcher.find()) {
            return;
        }
        LinkedHashSet<String> invalidSeparators = new LinkedHashSet<String>();
        int lastMatch = 0;
        while (matcher.find(lastMatch)) {
            invalidSeparators.add(matcher.group());
            lastMatch = matcher.end();
        }
        String errorMessageId = invalidSeparators.size() == 1 ? "literal.invalid.separator" : "literal.invalid.separators";
        throw new IllegalArgumentException(ErrorMessages.get(errorMessageId, String.join((CharSequence)"', '", invalidSeparators), value));
    }

    private String checkAndParseUniq(String value) {
        int index = value.indexOf("UNIQ");
        if (index >= 0 && value.length() != index + 4) {
            throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.invalidPlaceForUniq"));
        }
        if (index > 0) {
            char prefix = value.charAt(index - 1);
            if (prefix == '-' && index > 2 && value.charAt(index - 2) != ';' || prefix != '-' && prefix != ';') {
                throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.invalidSeparatorForUniq"));
            }
            if (prefix == '-') {
                --index;
            }
            if (index <= 0 || value.charAt(index - 1) != ';') {
                return value;
            }
            this.tokens.add(new UniqueToken(prefix == '-'));
            return value.substring(0, --index);
        }
        return value;
    }

    private String checkAndParseAll(String value) {
        boolean fetchAll = value.startsWith("ALL");
        if (fetchAll) {
            if (this.isInFilterMode()) {
                throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfAllDuringFiltering"));
            }
            LinkedList<Token> tokenList = new LinkedList<Token>();
            if (value.length() > 3) {
                if (value.charAt(3) != ':' || value.length() == 4) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.all"));
                }
                int groupEnd = (value = value.substring(4)).indexOf(59);
                if (groupEnd > 0) {
                    String allGroup = value.substring(0, groupEnd);
                    tokenList.addAll(LangFilter.parseTokens(allGroup));
                    value = value.substring(groupEnd + 1);
                } else {
                    tokenList.addAll(LangFilter.parseTokens(value));
                }
            } else {
                value = "";
            }
            this.tokens.add(new AllTokenGroup(tokenList));
        }
        return value;
    }

    public boolean isFetchAll() {
        return this.tokens.stream().anyMatch(AllTokenGroup.class::isInstance);
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void validate(FilterType filterType) {
        filterType.validate(this.tokens);
    }

    public static LangFilter parse(String filter) {
        return new LangFilter(filter, FilterType.NO_FILTER);
    }

    public static LangFilter parseForFilter(String filter) {
        return new LangFilter(filter, FilterType.FILTER);
    }

    public static LangFilter parseForFetching(String filter) {
        return new LangFilter(filter, FilterType.FETCH);
    }

    public static LangValidator parseForValidation(String validate) {
        if (StringUtils.isBlank((CharSequence)validate)) {
            return LangValidator.ALWAYS_VALID;
        }
        return new LangValidator(new LangFilter((String)validate, (FilterType)FilterType.VALIDATE).tokens);
    }

    public static LangValidator parseForImplicit(String implicit) {
        return new LangValidator(new LangFilter((String)implicit, (FilterType)FilterType.IMPLICIT).tokens);
    }

    public static LangFilter parseForOrderByLiteral(String pattern) {
        return new LangFilter(pattern, FilterType.ORDER_BY_LITERAL);
    }

    public static LangFilter parseForLiteralOrder(String pattern) {
        return new LangFilter(pattern, FilterType.LITERAL_ORDER_BY);
    }

    public static String applyUserLanguages(String lang, String userLang) {
        if (lang == null) {
            return "";
        }
        String updatedUserLang = StringUtils.trimToNull((String)userLang);
        int idx = lang.indexOf(BROWSER);
        if (updatedUserLang == null) {
            if (idx > 0 && lang.charAt(idx - 1) == '[') {
                return lang;
            }
            if (idx >= 0) {
                return LangFilter.removeBrowserKeyWord(lang);
            }
            return lang;
        }
        if (idx == 0 || idx > 0 && lang.charAt(idx - 1) != '[') {
            return lang.replace(BROWSER, "[BROWSER:" + userLang + "]");
        }
        return lang;
    }

    public static Optional<String> prepareForLanguageOrdering(String lang, String userLang) {
        if (lang == null) {
            return Optional.empty();
        }
        String updatedUserLang = StringUtils.trimToNull((String)userLang);
        int idx = lang.indexOf(BROWSER);
        if (idx < 0) {
            return Optional.of(lang);
        }
        if (updatedUserLang == null) {
            return Optional.ofNullable(StringUtils.trimToNull((String)LangFilter.removeBrowserKeyWord(lang)));
        }
        if (BROWSER.equals(lang)) {
            return Optional.ofNullable(StringUtils.trimToNull((String)userLang));
        }
        LangFilter original = LangFilter.parse(lang);
        LangFilter user = LangFilter.parse(userLang);
        LinkedList<Token> tokens = new LinkedList<Token>(original.tokens);
        LinkedList<Token> userTokens = new LinkedList<Token>(user.tokens);
        Token browserToken = tokens.stream().filter(token -> token.getType() == TokenType.BROWSER).findFirst().orElseThrow(IllegalArgumentException::new);
        int browserIdx = tokens.indexOf(browserToken);
        userTokens.removeAll(tokens);
        tokens.remove(browserIdx);
        tokens.addAll(browserIdx, userTokens);
        return Optional.of(Token.toString(tokens));
    }

    private static String removeBrowserKeyWord(String lang) {
        int idx = lang.indexOf(BROWSER);
        if (idx < 0) {
            return lang;
        }
        if (lang.equals(BROWSER)) {
            return "";
        }
        int length = BROWSER.length();
        if (idx == 0) {
            return lang.substring(length + 1);
        }
        if (lang.length() == idx + length) {
            return lang.substring(0, idx - 1);
        }
        char previousSeparator = lang.charAt(idx - 1);
        char nextSeparator = lang.charAt(idx + length);
        int newSeparator = 44;
        if (previousSeparator != nextSeparator) {
            if (previousSeparator == ':') {
                newSeparator = 58;
            } else if (nextSeparator == ';') {
                newSeparator = 59;
            }
            if ("ALL:".equals(lang.substring(0, idx)) && nextSeparator == ';') {
                return StringUtils.trimToEmpty((String)lang.substring(idx + length + 1));
            }
        }
        return lang.replace(previousSeparator + BROWSER + nextSeparator, "" + (char)newSeparator);
    }

    public static String convertAcceptLanguageToInternalFormat(String userLang) {
        if (StringUtils.isBlank((CharSequence)userLang)) {
            return null;
        }
        return Locale.LanguageRange.parse(userLang).stream().map(Locale.LanguageRange::getRange).distinct().map(LangFilter::convertToInternalFormat).collect(Collectors.joining(","));
    }

    private static String convertToInternalFormat(String langToken) {
        if ("*".equals(langToken)) {
            return ANY_LANG;
        }
        int separatorIdx = langToken.indexOf(45);
        if (separatorIdx < 0) {
            return langToken + ANY_LANG;
        }
        if (separatorIdx < 2) {
            return langToken;
        }
        return langToken + ANY_LANG;
    }

    public void applyFilterTo(Map<String, Object> expression) {
        expression.remove(LANG);
        try {
            this.combineFiltersAndNegations(expression);
        }
        finally {
            this.tokens.stream().filter(UniqueToken.class::isInstance).map(UniqueToken.class::cast).forEach(token -> token.applyTo(expression));
        }
    }

    private void combineFiltersAndNegations(Map<String, Object> expression) {
        LinkedList<Object> terms = new LinkedList<Object>();
        List<Token> leastRestrictiveFilters = this.getLeastRestrictiveFilters();
        this.appendFilters(expression, terms, leastRestrictiveFilters);
    }

    private void appendFilters(Map<String, Object> expression, List<Object> terms, List<Token> leastRestrictiveFilters) {
        terms.addAll(leastRestrictiveFilters.stream().filter(Token::isInclusion).flatMap(Token::toExpression).collect(Collectors.toList()));
        this.appendExclusions(terms);
        if (!terms.isEmpty()) {
            if (terms.size() == 1) {
                expression.put(LANG, terms.get(0));
            } else {
                expression.put(LANG, Collections.singletonMap("OR", terms));
            }
        }
    }

    private List<Token> expandUserPreferredLangs(List<Token> positiveTokens) {
        if (this.browserToken != null) {
            if (!positiveTokens.contains(this.browserToken)) {
                return positiveTokens;
            }
            List userTokens = this.browserToken.tokens;
            positiveTokens.removeAll(userTokens);
            int index = positiveTokens.indexOf(this.browserToken);
            positiveTokens.remove(index);
            positiveTokens.addAll(index, userTokens);
        }
        return positiveTokens;
    }

    private void appendExclusions(List<Object> terms) {
        List<Object> exclusions = this.getExclusions();
        if (!exclusions.isEmpty()) {
            Map<String, Object> exclusionsPart = exclusions.size() == 1 ? Collections.singletonMap("NOT", exclusions.get(0)) : Collections.singletonMap("NOT", Collections.singletonMap("OR", exclusions));
            if (terms.isEmpty()) {
                terms.add(exclusionsPart);
            } else {
                Map<String, ArrayList<Object>> termPart = terms.size() == 1 ? terms.get(0) : Collections.singletonMap("OR", new ArrayList<Object>(terms));
                terms.clear();
                terms.add(Collections.singletonMap("AND", Arrays.asList(termPart, exclusionsPart)));
            }
        }
    }

    private List<Object> getExclusions() {
        return this.tokens.stream().filter(Token::isExclusion).flatMap(Token::toExpression).collect(Collectors.toList());
    }

    private List<Token> getLeastRestrictiveFilters() {
        List<Token> positiveTokens = this.tokens.stream().filter(Token::isInclusion).collect(Collectors.toList());
        List<Token> updatedTokens = this.expandUserPreferredLangs(positiveTokens);
        updatedTokens.removeIf(token -> updatedTokens.stream().anyMatch(token::isNarrowerThan));
        return updatedTokens;
    }

    public void setExpression(ExpressionValue<?> expression) {
        this.expression = expression;
    }

    public ExpressionValue getExpression() {
        return this.expression;
    }

    public boolean isFetchAnyValue() {
        return this.tokens.stream().allMatch(AnyValueToken.class::isInstance);
    }

    public Stream<String> filterLanguageTags(Collection<String> langTags) {
        LinkedHashSet<String> langs = new LinkedHashSet<String>(langTags);
        List<Token> tokensCopy = LangFilter.filterOutExclusions(langs, this.tokens);
        boolean fetchAll = this.isFetchAll();
        tokensCopy.removeIf(token -> token.getType() == TokenType.ALL);
        if (tokensCopy.isEmpty()) {
            return langs.stream();
        }
        return tokensCopy.stream().flatMap(token -> token.matchValue(langs, fetchAll)).filter(Objects::nonNull);
    }

    private static List<Token> filterOutExclusions(Set<String> langs, List<Token> tokens) {
        LinkedList<Token> tokensCopy = new LinkedList<Token>(tokens);
        Iterator tokenIterator = tokensCopy.iterator();
        while (tokenIterator.hasNext()) {
            Token token = (Token)tokenIterator.next();
            if (!token.isExclusion()) continue;
            token.applyExclusion(langs);
            tokenIterator.remove();
        }
        return tokensCopy;
    }

    public boolean isInFilterMode() {
        return this.type == FilterType.FILTER;
    }

    public String toString() {
        return Token.toString(this.tokens);
    }

    private static Predicate<Token> notIn(Class ... types) {
        return token -> {
            for (Class type : types) {
                if (!type.isInstance(token)) continue;
                return false;
            }
            return true;
        };
    }

    public static enum FilterType {
        NO_FILTER(FilterType.applyGeneralRules()),
        FILTER(FilterType.applyGeneralRules().andThen(FilterType.forbidAnyInFiltering()).andThen(FilterType.checkForInvalidUseOfAny())),
        FETCH(FilterType.applyGeneralRules().andThen(FilterType.checkForInvalidUseOfAny()).andThen(FilterType.invalidUseOfAllGrouping())),
        VALIDATE(FilterType.applyGeneralRules()),
        IMPLICIT(FilterType.applyGeneralRules().andThen(FilterType.checkOnlySingleExactToken())),
        LITERAL_ORDER_BY(FilterType.applyGeneralRules().andThen(FilterType.checkForInvalidUseOfAny().andThen(FilterType.applyOrderRules()))),
        ORDER_BY_LITERAL(FilterType.applyGeneralRules().andThen(FilterType.checkForInvalidUseOfAny().andThen(FilterType.applyOrderByRules())));

        private final Consumer<List<Token>> validateFunction;

        private FilterType(Consumer<List<Token>> validateFunction) {
            this.validateFunction = validateFunction;
        }

        public void validate(List<Token> tokens) {
            this.validateFunction.accept(tokens);
        }

        private static Consumer<List<Token>> applyGeneralRules() {
            return FilterType.checkForDuplicateLangUse();
        }

        private static Consumer<List<Token>> checkForDuplicateLangUse() {
            return tokens -> {
                Map<String, List<Token>> duplicateCheck = tokens.stream().collect(Collectors.groupingBy(Object::toString));
                duplicateCheck.values().removeIf(items -> items.size() == 1);
                String value = String.join((CharSequence)", ", duplicateCheck.keySet());
                String messageKey = null;
                if (duplicateCheck.size() == 1) {
                    messageKey = "literal.invalid.duplicateLang";
                } else if (duplicateCheck.size() > 1) {
                    messageKey = "literal.invalid.duplicateLangs";
                }
                if (messageKey != null) {
                    throw new IllegalArgumentException(ErrorMessages.get(messageKey, value));
                }
            };
        }

        private static Consumer<List<Token>> forbidAnyInFiltering() {
            return tokens -> {
                if (tokens.stream().noneMatch(UniqueToken.class::isInstance)) {
                    if (tokens.stream().anyMatch(AnyValueToken.class::isInstance)) {
                        throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfANYDuringFiltering"));
                    }
                }
            };
        }

        private static Consumer<List<Token>> applyOrderByRules() {
            return tokens -> {
                if (tokens.stream().noneMatch(UniqueToken.class::isInstance)) {
                    if (tokens.stream().anyMatch(AnyValueToken.class::isInstance)) {
                        throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfANYDuringOrdering", Token.toString(tokens)));
                    }
                }
                if (tokens.stream().allMatch(Token::isExclusion)) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.onlyExclusions", Token.toString(tokens)));
                }
                if (tokens.stream().anyMatch(AllTokenGroup.class::isInstance)) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfALLDuringOrdering", Token.toString(tokens)));
                }
            };
        }

        private static Consumer<List<Token>> applyOrderRules() {
            return tokens -> {
                if (tokens.stream().noneMatch(AllTokenGroup.class::isInstance)) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.requiredUseOfALLDuringOrdering", Token.toString(tokens)));
                }
            };
        }

        private static Consumer<List<Token>> checkForInvalidUseOfAny() {
            return tokens -> {
                if (tokens.stream().noneMatch(AllTokenGroup.class::isInstance) || tokens.size() <= 1) {
                    return;
                }
                Optional<Token> anyValue = tokens.stream().filter(AnyValueToken.class::isInstance).findFirst();
                anyValue.ifPresent(value -> tokens.stream().filter(Token::isInclusion).filter(LangFilter.notIn(AnyValueToken.class, AllTokenGroup.class)).findFirst().ifPresent(subsumedValue -> {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfANY", subsumedValue, value));
                }));
                Optional<Token> anyLangValue = tokens.stream().filter(AnyLangMatchToken.class::isInstance).findFirst();
                anyLangValue.ifPresent(value -> tokens.stream().filter(Token::isInclusion).filter(LangFilter.notIn(AnyLangMatchToken.class, AllTokenGroup.class)).findFirst().filter(LangFilter.notIn(EmptyLangToken.class)).ifPresent(subsumedValue -> {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfANY", subsumedValue, value));
                }));
            };
        }

        private static Consumer<List<Token>> checkOnlySingleExactToken() {
            return tokens -> {
                if (tokens.size() > 1) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.multipleImplicitValues", Token.toString(tokens)));
                }
                Predicate<Token> forbiddenImplicitValues = token -> token.isExclusion() || token.getType() != TokenType.EXACT_MATCH && token.getType() != TokenType.NO_LANG;
                Predicate<Token> doesNotHaveLanguage = token -> {
                    Locale locale = Locale.forLanguageTag(token.toString());
                    return StringUtils.isBlank((CharSequence)locale.getLanguage());
                };
                String notAllowedValues = tokens.stream().filter(forbiddenImplicitValues.and(doesNotHaveLanguage)).map(Object::toString).collect(Collectors.joining(","));
                if (!notAllowedValues.isEmpty()) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.implicitValue", notAllowedValues));
                }
            };
        }

        private static Consumer<List<Token>> invalidUseOfAllGrouping() {
            return tokens -> {
                Optional<AllTokenGroup> all = tokens.stream().filter(AllTokenGroup.class::isInstance).map(AllTokenGroup.class::cast).findFirst();
                if (!all.isPresent()) {
                    return;
                }
                List tokensCopy = tokens.stream().filter(LangFilter.notIn(AllTokenGroup.class, BrowserTokenGroup.class)).collect(Collectors.toList());
                List allTokensCopy = all.get().tokens.stream().filter(LangFilter.notIn(BrowserTokenGroup.class)).collect(Collectors.toList());
                if (!allTokensCopy.isEmpty() && !tokensCopy.equals(allTokensCopy)) {
                    throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfAllGrouping"));
                }
            };
        }
    }

    private static class BrowserTokenGroup
    extends BaseTokenGroup {
        static final Token EMPTY = new BrowserTokenGroup(Collections.emptyList());

        public BrowserTokenGroup(List<Token> tokens) {
            super(TokenType.BROWSER, tokens);
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return otherToken instanceof AnyLangMatchToken || otherToken instanceof AnyValueToken;
        }

        @Override
        public String toString() {
            if (this.tokens.isEmpty()) {
                return LangFilter.BROWSER;
            }
            return "[" + super.toString() + "]";
        }
    }

    public static interface Token {
        public String getValue();

        public TokenType getType();

        public boolean isExclusion();

        default public boolean isInclusion() {
            return !this.isExclusion();
        }

        public Stream<String> matchValue(Collection<String> var1, boolean var2);

        public void applyExclusion(Collection<String> var1);

        public Stream<Map<String, Object>> toExpression();

        public boolean isNarrowerThan(Token var1);

        public Optional<String> getLanguage();

        default public String getIdentifier() {
            return this.getLanguage().orElse(this.getType().toString());
        }

        public static String toString(List<Token> tokens) {
            AllTokenGroup all = tokens.stream().filter(AllTokenGroup.class::isInstance).map(AllTokenGroup.class::cast).findFirst().orElse(null);
            if (all != null) {
                String tokensExceptAll = tokens.stream().filter(token -> token != all && !all.tokens.contains(token)).map((Function<Token, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/ontotext/models/query/LangFilter$Token;)Ljava/lang/String;)()).collect(Collectors.joining(","));
                if (tokensExceptAll.isEmpty() || "ANY".equals(tokensExceptAll)) {
                    return all.toString();
                }
                return all.toString() + ";" + tokensExceptAll;
            }
            return tokens.stream().map((Function<Token, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/ontotext/models/query/LangFilter$Token;)Ljava/lang/String;)()).collect(Collectors.joining(","));
        }
    }

    private static abstract class BaseToken
    implements Token {
        static final String LITERAL_INVALID_LANGTAG_ERROR = "literal.invalid.langtag";
        String value;
        boolean negation;

        BaseToken(String value, boolean negation) {
            this.value = value;
            this.negation = negation;
        }

        static Token parse(String token) {
            boolean negation = (token = token.toLowerCase()).startsWith("-");
            if (negation) {
                token = token.substring(1);
            }
            if (token.isEmpty() || "any".equals(token)) {
                return new AnyValueToken(token, negation);
            }
            if ("none".equals(token)) {
                return new EmptyLangToken(negation);
            }
            if ("uniq".equals(token)) {
                return new UniqueToken(negation);
            }
            if ("browser".equals(token)) {
                return BrowserTokenGroup.EMPTY;
            }
            if (!token.contains(LangFilter.ANY_LANG)) {
                return new ExactMatchToken(token, negation);
            }
            if (token.equals(LangFilter.ANY_LANG)) {
                return new AnyLangMatchToken(negation);
            }
            if (token.startsWith(LangFilter.ANY_LANG)) {
                if (token.endsWith(LangFilter.ANY_LANG)) {
                    return new ContainsToken(StringUtils.truncate((String)token, (int)1, (int)(token.length() - 2)), negation);
                }
                String value = token.substring(1);
                BaseToken.shouldBeginWithalphaNumeric(value);
                return new EndsWithToken(value, negation);
            }
            if (token.endsWith(LangFilter.ANY_LANG)) {
                return new StartWithToken(token.substring(0, token.length() - 1), negation);
            }
            token = token.replaceAll("~+", LangFilter.ANY_LANG);
            return new LangMatchToken(token, negation);
        }

        private static void shouldBeginWithalphaNumeric(String value) {
            int firstChar = value.indexOf(0);
            if (!Character.isAlphabetic(firstChar) && !Character.isDigit(value.charAt(0))) {
                throw BaseToken.createInvalidLangError(value);
            }
        }

        static void validateLangToken(String value) {
            if (!LangValidator.isValidLanguageTag(value)) {
                throw BaseToken.createInvalidLangError(value);
            }
        }

        static IllegalArgumentException createInvalidLangError(String value) {
            return new IllegalArgumentException(ErrorMessages.get(LITERAL_INVALID_LANGTAG_ERROR, value));
        }

        static List<Locale.LanguageRange> parseLanguageRange(String value, String valueToReport) {
            try {
                return Locale.LanguageRange.parse(value);
            }
            catch (IllegalArgumentException iae) {
                throw BaseToken.createInvalidLangError(valueToReport);
            }
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isExclusion() {
            return this.negation;
        }

        @Override
        public boolean isInclusion() {
            return !this.negation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BaseToken token = (BaseToken)obj;
            return this.negation == token.negation && Objects.equals(this.value, token.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.negation);
        }

        public String toString() {
            return (this.negation ? "-" : "") + this.value;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            return Stream.empty();
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        static String extractLang(String value) {
            Locale locale = new Locale.Builder().setLanguageTag(value).build();
            return StringUtils.trimToNull((String)locale.getLanguage());
        }
    }

    private static class UniqueToken
    extends BaseToken {
        UniqueToken(boolean negation) {
            super("UNIQ", negation);
        }

        @Override
        public TokenType getType() {
            return TokenType.UNIQUE;
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return false;
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            return Stream.empty();
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
        }

        void applyTo(Map<String, Object> expression) {
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(expression);
            expression.clear();
            if (this.negation) {
                HashMap<String, LinkedHashMap<String, Object>> subFilter = new HashMap<String, LinkedHashMap<String, Object>>();
                subFilter.put("UNIQ_LANG", copy);
                expression.put("NOT", subFilter);
            } else {
                expression.put("UNIQ_LANG", copy);
            }
        }
    }

    private static class AllTokenGroup
    extends BaseTokenGroup {
        public AllTokenGroup(List<Token> tokens) {
            super(TokenType.ALL, tokens);
        }

        @Override
        public Stream<String> matchValue(Collection<String> langTags, boolean matchAll) {
            LinkedHashSet<String> langs = new LinkedHashSet<String>(langTags);
            List<Token> tokensCopy = LangFilter.filterOutExclusions(langs, this.tokens);
            if (tokensCopy.isEmpty()) {
                return langs.stream();
            }
            return tokensCopy.stream().flatMap(token -> token.matchValue(langs, true));
        }
    }

    private static class AnyValueToken
    extends BaseToken {
        AnyValueToken(boolean negation) {
            this("ANY", negation);
        }

        AnyValueToken(String value, boolean negation) {
            super("ANY", negation);
            if (negation && value.isEmpty()) {
                throw AnyValueToken.createInvalidLangError("-");
            }
            if (negation) {
                throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.negativeAny"));
            }
        }

        @Override
        public TokenType getType() {
            return TokenType.ANY;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            return null;
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return false;
        }

        @Override
        public String toString() {
            return "ANY";
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            if (matchAll) {
                return langs.stream();
            }
            if (langs.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of(langs.iterator().next());
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
        }
    }

    public static enum TokenType {
        EXACT_MATCH,
        ANY,
        ANY_LANG,
        NO_LANG,
        START_WITH,
        END_WITH,
        CONTAINS,
        MATCH,
        UNIQUE,
        ALL,
        BROWSER;

    }

    private static class LangMatchToken
    extends WildCardToken {
        private final String startWith;
        private final String endWith;

        LangMatchToken(String value, boolean negation) {
            super(value, negation, LangMatchToken.parseLanguageRange(LangMatchToken.getRangesFor(value), value));
            String[] parts = value.split(LangFilter.ANY_LANG);
            this.startWith = parts[0];
            this.endWith = parts[1];
        }

        private static String getRangesFor(String value) {
            String[] parts = value.split(LangFilter.ANY_LANG);
            if (parts.length != 2) {
                throw new IllegalArgumentException(ErrorMessages.get(LangFilter.INVALID_MULTIPLE_WILDCARD_TOKENS, value));
            }
            return value.replace(LangFilter.ANY_LANG, "-*-");
        }

        @Override
        public TokenType getType() {
            return TokenType.MATCH;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            LinkedHashMap<String, String> exp = new LinkedHashMap<String, String>();
            exp.put("STRSTARTS", this.startWith);
            exp.put("STRENDS", this.endWith);
            return Stream.of(exp);
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return otherToken instanceof AnyValueToken || otherToken instanceof AnyLangMatchToken;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LangMatchToken)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            LangMatchToken that = (LangMatchToken)obj;
            return Objects.equals(this.startWith, that.startWith) && Objects.equals(this.endWith, that.endWith);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.startWith, this.endWith);
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.of(this.value);
        }
    }

    private static class ContainsToken
    extends WildCardToken {
        ContainsToken(String value, boolean negation) {
            super(value, negation, ContainsToken.parseLanguageRange(ContainsToken.getRangesFor(value), value));
        }

        private static String getRangesFor(String value) {
            if (value.isEmpty()) {
                throw new IllegalArgumentException(ErrorMessages.get(LangFilter.INVALID_MULTIPLE_WILDCARD_TOKENS, "~~"));
            }
            if (value.contains(LangFilter.ANY_LANG)) {
                throw new IllegalArgumentException(ErrorMessages.get(LangFilter.INVALID_MULTIPLE_WILDCARD_TOKENS, value));
            }
            return String.format("%s-*, *-%s, *-%s-*", value, value, value);
        }

        @Override
        public TokenType getType() {
            return TokenType.CONTAINS;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            LinkedHashMap<String, String> exp = new LinkedHashMap<String, String>();
            exp.put("CONTAINS", this.getValue());
            return Stream.of(exp);
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return otherToken instanceof AnyValueToken || otherToken instanceof AnyLangMatchToken;
        }

        @Override
        public String toString() {
            return (this.negation ? "-" : "") + LangFilter.ANY_LANG + this.value + LangFilter.ANY_LANG;
        }
    }

    private static class EndsWithToken
    extends WildCardToken {
        EndsWithToken(String value, boolean negation) {
            super(value, negation, EndsWithToken.parseLanguageRange(EndsWithToken.getRangesFor(value), value));
        }

        private static String getRangesFor(String value) {
            if (value.contains(LangFilter.ANY_LANG)) {
                throw new IllegalArgumentException(ErrorMessages.get(LangFilter.INVALID_MULTIPLE_WILDCARD_TOKENS, value));
            }
            return value + ",*-" + value;
        }

        @Override
        public TokenType getType() {
            return TokenType.END_WITH;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            LinkedHashMap<String, String> exp = new LinkedHashMap<String, String>();
            exp.put("STRENDS", this.getValue());
            return Stream.of(exp);
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return otherToken instanceof AnyValueToken || otherToken instanceof AnyLangMatchToken;
        }

        @Override
        public String toString() {
            return (this.negation ? "-" : "") + LangFilter.ANY_LANG + this.value;
        }
    }

    private static class StartWithToken
    extends WildCardToken {
        private final String language;

        StartWithToken(String value, boolean negation) {
            super(value, negation, StartWithToken.parseLanguageRange(StartWithToken.getRangesFor(value), value));
            if (!"i".equals(value) && !"x".equals(value)) {
                StartWithToken.validateLangToken(value);
                this.language = StartWithToken.extractLang(value);
            } else {
                this.language = null;
            }
        }

        private static String getRangesFor(String value) {
            if (value.contains(LangFilter.ANY_LANG)) {
                throw new IllegalArgumentException(ErrorMessages.get(LangFilter.INVALID_MULTIPLE_WILDCARD_TOKENS, value));
            }
            return value + "," + value + "-*";
        }

        @Override
        public TokenType getType() {
            return TokenType.START_WITH;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            LinkedHashMap<String, String> exp = new LinkedHashMap<String, String>();
            exp.put("STRSTARTS", this.getValue());
            return Stream.of(exp);
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return otherToken instanceof AnyValueToken || otherToken instanceof AnyLangMatchToken;
        }

        @Override
        public String toString() {
            return super.toString() + LangFilter.ANY_LANG;
        }

        @Override
        public Optional<String> getLanguage() {
            if (this.language == null) {
                return Optional.of(this.value);
            }
            return Optional.of(this.language);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StartWithToken)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            StartWithToken that = (StartWithToken)obj;
            return Objects.equals(this.language, that.language);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.language);
        }
    }

    private static abstract class WildCardToken
    extends BaseToken {
        private final List<Locale.LanguageRange> range;

        WildCardToken(String value, boolean negation, List<Locale.LanguageRange> range) {
            super(value, negation);
            this.range = range;
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            if (this.negation) {
                return Stream.empty();
            }
            List<String> orderedLangs = Locale.filterTags(this.range, langs);
            if (orderedLangs.isEmpty()) {
                return Stream.empty();
            }
            if (matchAll) {
                return orderedLangs.stream();
            }
            return Stream.of(orderedLangs.get(0));
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
            if (this.negation) {
                List<String> orderedLangs = Locale.filterTags(this.range, langs);
                langs.removeIf(orderedLangs::contains);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WildCardToken)) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            WildCardToken that = (WildCardToken)obj;
            return this.range.equals(that.range);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.range);
        }
    }

    private static class EmptyLangToken
    extends BaseToken {
        EmptyLangToken(boolean negation) {
            super("NONE", negation);
        }

        @Override
        public TokenType getType() {
            return TokenType.NO_LANG;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            return Stream.of(Collections.singletonMap("NOT", Collections.singletonMap("STRSTARTS", "*")));
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            if (this.equals(otherToken)) {
                return false;
            }
            return otherToken instanceof AnyValueToken;
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            if (!this.negation && langs.contains("")) {
                return Stream.of("");
            }
            return Stream.empty();
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
            if (this.negation) {
                langs.remove("");
            }
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.of("");
        }
    }

    private static class AnyLangMatchToken
    extends BaseToken {
        AnyLangMatchToken(boolean negation) {
            super(LangFilter.ANY_LANG, negation);
        }

        @Override
        public TokenType getType() {
            return TokenType.ANY_LANG;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            return Stream.of(Collections.singletonMap("STRSTARTS", "*"));
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            if (this.equals(otherToken) || otherToken instanceof EmptyLangToken) {
                return false;
            }
            return otherToken instanceof AnyValueToken;
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            if (this.negation) {
                return Stream.empty();
            }
            Stream.Builder<String> builder = Stream.builder();
            for (String lang : langs) {
                if (!StringUtils.isNotEmpty((CharSequence)lang)) continue;
                builder.add(lang);
                if (matchAll) continue;
                break;
            }
            return builder.build();
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
            if (this.negation) {
                langs.removeIf(value -> !value.isEmpty());
            }
        }
    }

    private static class ExactMatchToken
    extends BaseToken {
        ExactMatchToken(String value, boolean negation) {
            super(value, negation);
            this.validateValue();
        }

        @Override
        public TokenType getType() {
            return TokenType.EXACT_MATCH;
        }

        private void validateValue() {
            if ("all".equals(this.value)) {
                throw new IllegalArgumentException(ErrorMessages.get("literal.invalid.useOfAll"));
            }
            ExactMatchToken.validateLangToken(this.value);
            Locale locale = Locale.forLanguageTag(this.value);
            String language = locale.getLanguage();
            if ((StringUtils.isEmpty((CharSequence)language) || "und".equals(language)) && locale.getExtensionKeys().isEmpty()) {
                throw ExactMatchToken.createInvalidLangError(this.value);
            }
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            LinkedHashMap<String, String> exp = new LinkedHashMap<String, String>();
            exp.put("EQ", this.getValue());
            return Stream.of(exp);
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            if (this.equals(otherToken)) {
                return false;
            }
            if (otherToken instanceof AnyLangMatchToken) {
                return true;
            }
            return otherToken instanceof StartWithToken && this.getValue().startsWith(otherToken.getValue());
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            if (!this.negation && langs.contains(this.value)) {
                return Stream.of(this.value);
            }
            return Stream.empty();
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
            if (this.negation) {
                langs.remove(this.value);
            }
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.of(this.value.split("\\W", 2)[0]);
        }
    }

    private static abstract class BaseTokenGroup
    implements TokenGroup {
        List<Token> tokens = new LinkedList<Token>();
        final TokenType type;

        public BaseTokenGroup(TokenType type, List<Token> tokens) {
            this.type = type;
            this.tokens.addAll(tokens);
        }

        @Override
        public List<Token> getTokens() {
            return this.tokens;
        }

        @Override
        public String getValue() {
            return this.tokens.stream().map(Objects::toString).collect(Collectors.joining(","));
        }

        @Override
        public TokenType getType() {
            return this.type;
        }

        @Override
        public boolean isExclusion() {
            return false;
        }

        @Override
        public Stream<String> matchValue(Collection<String> langs, boolean matchAll) {
            return this.tokens.stream().flatMap(token -> token.matchValue(langs, matchAll));
        }

        @Override
        public void applyExclusion(Collection<String> langs) {
        }

        @Override
        public boolean isNarrowerThan(Token otherToken) {
            return false;
        }

        @Override
        public Stream<Map<String, Object>> toExpression() {
            return Stream.empty();
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        public String toString() {
            return String.valueOf((Object)this.getType()) + (String)(this.tokens.isEmpty() ? "" : ":" + this.getValue());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseTokenGroup)) {
                return false;
            }
            BaseTokenGroup that = (BaseTokenGroup)obj;
            return this.tokens.equals(that.tokens) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tokens, this.type});
        }
    }

    public static interface TokenGroup
    extends Token {
        public List<Token> getTokens();
    }
}

