/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionTraverserContext;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.TraversalControl;
import com.ontotext.models.query.Value;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Collection;
import java.util.function.BiFunction;

public class FilterExpressionTraverser {
    private static final PreOrderTraverser PRE_ORDER_TRAVERSER = new PreOrderTraverser();

    private FilterExpressionTraverser() {
    }

    public static void traversePreOrder(ExpressionValue<?> root, ExpressionVisitor<TraversalControl, ExpressionTraverserContext> visitor) {
        FilterExpressionTraverser.traversePreOrder(root, visitor, new ExpressionTraverserContext());
    }

    public static <E extends ExpressionTraverserContext> void traversePreOrder(ExpressionValue<?> root, ExpressionVisitor<TraversalControl, E> visitor, E context) {
        TraversalControl control = TraversalControl.RERUN;
        while (control == TraversalControl.RERUN) {
            control = root.accept(PRE_ORDER_TRAVERSER, new TraversalContext<E>(visitor, context));
        }
    }

    private static class PreOrderTraverser
    extends AbstractExpressionVisitor<TraversalControl, TraversalContext> {
        private PreOrderTraverser() {
        }

        @Override
        public TraversalControl visit(Node target, TraversalContext context) {
            return this.visitNodeAndThen(target, context, (node, ctx) -> ((Expression)node.getValue()).accept(this, ctx));
        }

        @Override
        public TraversalControl visit(Value target, TraversalContext context) {
            return this.visitNodeAndThen(target, context, (node, ctx) -> TraversalControl.CONTINUE);
        }

        @Override
        protected TraversalControl visitExpression(Expression target, TraversalContext context) {
            return this.visitNodeAndThen(target, context, this::traverseCollectionOfSubExpressions);
        }

        @Override
        protected TraversalControl visitExpressionTerm(ExpressionTerm target, TraversalContext context) {
            return this.visitNodeAndThen(target, context, this::traverseExpressionTerm);
        }

        private TraversalControl traverseExpressionTerm(ExpressionTerm node, TraversalContext ctx) {
            if (node.getValue() instanceof ExpressionValue) {
                return ((ExpressionValue)node.getValue()).accept(this, ctx);
            }
            if (node.getValue() instanceof Collection) {
                return this.traverseCollectionOfSubExpressions(node, ctx);
            }
            return TraversalControl.CONTINUE;
        }

        private TraversalControl traverseCollectionOfSubExpressions(ExpressionValue node, TraversalContext ctx) {
            for (Object item : (Collection)node.getValue()) {
                if (!(item instanceof ExpressionValue)) continue;
                TraversalControl control = ((ExpressionValue)item).accept(this, ctx);
                if (control == TraversalControl.CANCEL) {
                    throw new IllegalStateException("TraversalControl.CANCEL not expected during expression traversal: " + String.valueOf(item));
                }
                if (control == TraversalControl.CONTINUE) continue;
                return control;
            }
            return TraversalControl.CONTINUE;
        }

        private <E extends ExpressionValue<?>> TraversalControl visitNodeAndThen(E target, TraversalContext<?> context, BiFunction<E, TraversalContext, TraversalControl> subNodeAction) {
            TraversalControl control = context.handleNode(target);
            if ((control = (TraversalControl)((Object)ObjectsUtil.getOrDefault((Object)((Object)control), (Object)((Object)TraversalControl.CONTINUE)))) == TraversalControl.CONTINUE) {
                control = subNodeAction.apply(target, context);
            }
            context.popLastNode();
            if (control == TraversalControl.CANCEL) {
                return TraversalControl.CONTINUE;
            }
            return control;
        }
    }

    static class TraversalContext<E extends ExpressionTraverserContext>
    implements ExpressionVisitorContext {
        private final ExpressionVisitor<TraversalControl, E> visitor;
        private final E context;

        TraversalContext(ExpressionVisitor<TraversalControl, E> visitor, E context) {
            this.visitor = visitor;
            this.context = context;
        }

        TraversalControl handleNode(ExpressionValue<?> target) {
            ((ExpressionTraverserContext)this.context).push(target);
            return target.accept(this.visitor, this.context);
        }

        void popLastNode() {
            ((ExpressionTraverserContext)this.context).pop();
        }
    }
}

