/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.IdSelector;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.Order;
import com.ontotext.models.subscriptions.SubscriptionOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Arguments
extends LinkedHashMap<String, Object> {
    public static final String ID = "ID";
    public static final String ORDER = "orderBy";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";
    public static final String WHERE = "where";
    public static final String MUTATION_DATA = "objects";
    public static final String LANG_VALUE = "value";
    public static final String LANG = "lang";
    public static final String ORDER_DIRECTION = "dir";
    public static final String INHERITED_ORDER_BY = "inheritedOrderBy";
    public static final String USER_LANGUAGES = "Accept-Language";
    public static final String SUBSCRIPTION_OP = "subscriptionOp";
    public static final String GRAPH = "graph";
    public static final String INCLUDE_INFERRED = "includeInferred";
    public static final String EXPAND_OVER_OWL_SAME_AS = "expandOwlSameAs";
    public static final String REPOSITORY = "repository";
    public static final String USING = "using";
    public static final String USING_NAMED = "usingNamed";
    public static final String WITH = "with";
    public static final String FROM = "from";
    public static final String FROM_NAMED = "fromNamed";
    public static final String ERRORS_FORMAT = "errorsFormat";

    public Arguments() {
    }

    public Arguments(Map<? extends String, ?> map) {
        super(map);
    }

    public Optional<List<String>> getId() {
        return Optional.ofNullable((List)this.get(ID));
    }

    public void setId(Object id) {
        if (id == null) {
            this.remove(ID);
        } else if (id instanceof String) {
            this.put(ID, Collections.singletonList(id));
        } else if (id instanceof Collection) {
            this.put(ID, new ArrayList((Collection)id));
        } else {
            throw new IllegalArgumentException("ID argument could be a 'String' or 'java.util.Collection' but got: " + String.valueOf(id));
        }
    }

    public List<String> resolveId() {
        return this.getWhere().map(IdSelector::extractAndRemoveIds).orElseGet(Collections::emptyList);
    }

    public Optional<Long> getLimit() {
        return Optional.ofNullable((Long)this.get(LIMIT));
    }

    public void setLimit(long limit) {
        this.put(LIMIT, limit);
    }

    public Optional<Long> getOffset() {
        return Optional.ofNullable((Long)this.get(OFFSET));
    }

    public void setOffset(long offset) {
        this.put(OFFSET, offset);
    }

    public Optional<List<Order>> getOrder() {
        return Optional.ofNullable((List)this.get(ORDER));
    }

    public void setOrder(List<Order> order) {
        if (order == null) {
            this.remove(ORDER);
        } else {
            this.put(ORDER, order);
        }
    }

    public <E> Optional<ExpressionValue<E>> getWhere() {
        return Optional.ofNullable((ExpressionValue)this.get(WHERE));
    }

    public void setWhere(ExpressionValue<?> expression) {
        if (expression == null) {
            this.remove(WHERE);
        } else {
            this.put(WHERE, expression);
        }
    }

    public Optional<List<Change>> getChanges() {
        return Optional.ofNullable((List)this.get(MUTATION_DATA));
    }

    public void setChanges(List<Change> changes) {
        if (changes == null) {
            this.remove(MUTATION_DATA);
        } else {
            this.put(MUTATION_DATA, changes);
        }
    }

    public Optional<LangFilter> getLangFilter() {
        Object value = this.get(LANG);
        if (value instanceof LangFilter) {
            return Optional.of((LangFilter)value);
        }
        return Optional.empty();
    }

    public Optional<String> getLangFilterPreference() {
        Object value = this.get(LANG);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public void setLangFilter(LangFilter filter) {
        if (filter == null) {
            this.remove(LANG);
        } else {
            this.put(LANG, filter);
        }
    }

    public void setLangFilterPreference(String preference) {
        if (preference == null) {
            this.remove(LANG);
        } else {
            this.put(LANG, preference);
        }
    }

    public <E> Optional<ExpressionValue<E>> getLangValueFilter() {
        return Optional.ofNullable((ExpressionValue)this.get(LANG_VALUE));
    }

    public void setLangValueFilter(ExpressionValue<?> valueFilter) {
        if (valueFilter == null) {
            this.remove(LANG_VALUE);
        } else {
            this.put(LANG_VALUE, valueFilter);
        }
    }

    public void setOrderDirection(Object direction) {
        if (direction == null) {
            this.remove(ORDER_DIRECTION);
        } else if (direction instanceof Boolean) {
            this.put(ORDER_DIRECTION, direction);
        } else if (direction instanceof String) {
            this.put(ORDER_DIRECTION, "asc".equalsIgnoreCase((String)direction));
        }
    }

    public Optional<Boolean> isAscendingOrder() {
        return Optional.ofNullable((Boolean)this.get(ORDER_DIRECTION));
    }

    public SubscriptionOp getSubscriptionOp() {
        return this.getOrDefault(SUBSCRIPTION_OP, SubscriptionOp.READ);
    }

    public Optional<String> getGraph() {
        Object value = this.get(GRAPH);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public void setGraph(String graph) {
        if (graph == null) {
            this.remove(GRAPH);
        } else {
            this.put(GRAPH, graph);
        }
    }

    public Optional<Boolean> getIncludeInferred() {
        Object value = this.get(INCLUDE_INFERRED);
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        return Optional.empty();
    }

    public void setIncludeInferred(Boolean includeInferred) {
        if (includeInferred == null) {
            this.remove(INCLUDE_INFERRED);
        } else {
            this.put(INCLUDE_INFERRED, includeInferred);
        }
    }

    public Optional<Boolean> getExpandOverOwlSameAs() {
        Object value = this.get(EXPAND_OVER_OWL_SAME_AS);
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        return Optional.empty();
    }

    public void setExpandOverOwlSameAs(Boolean expandOverOwlSameAs) {
        if (expandOverOwlSameAs == null) {
            this.remove(EXPAND_OVER_OWL_SAME_AS);
        } else {
            this.put(EXPAND_OVER_OWL_SAME_AS, expandOverOwlSameAs);
        }
    }

    public Optional<String> getRepository() {
        Object value = this.get(REPOSITORY);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public void setRepository(String repository) {
        if (repository == null) {
            this.remove(REPOSITORY);
        } else {
            this.put(REPOSITORY, repository);
        }
    }

    public Optional<Collection<String>> getFrom() {
        Object value = this.get(FROM);
        return Arguments.getAsCollection(value);
    }

    public Optional<Collection<String>> getFromNamed() {
        Object value = this.get(FROM_NAMED);
        return Arguments.getAsCollection(value);
    }

    public Optional<Collection<String>> getUsing() {
        Object value = this.get(USING);
        return Arguments.getAsCollection(value);
    }

    public Optional<Collection<String>> getUsingNamed() {
        Object value = this.get(USING_NAMED);
        return Arguments.getAsCollection(value);
    }

    public Optional<String> getWith() {
        Object value = this.get(WITH);
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public boolean isInheritedOrderBy() {
        return this.containsKey(INHERITED_ORDER_BY);
    }

    public boolean fromContains(String graphName) {
        return this.getFrom().filter(collection -> collection.contains(graphName)).isPresent();
    }

    public boolean isFromExplainGraph() {
        return this.fromContains("http://www.ontotext.com/explain");
    }

    public boolean isFromSparqlGraph() {
        return this.fromContains("http://www.ontotext.com/sparql");
    }

    public void setAsInheritedOrderBy() {
        this.put(INHERITED_ORDER_BY, Boolean.TRUE);
    }

    public Optional<Boolean> shouldCompactErrors() {
        Object value = this.get(ERRORS_FORMAT);
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        return Optional.empty();
    }

    private static Optional<Collection<String>> getAsCollection(Object value) {
        if (value instanceof Collection) {
            return Optional.of((Collection)value);
        }
        if (value instanceof String) {
            return Optional.of(Collections.singletonList((String)value));
        }
        return Optional.empty();
    }
}

