/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.query.AbstractExpressionTerm;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

abstract class AbstractExpression
extends AbstractExpressionTerm<List<ExpressionTerm>>
implements Expression {
    AbstractExpression() {
        super(new LinkedList());
    }

    AbstractExpression(List<ExpressionTerm> termContainer) {
        super(termContainer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractExpression)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractExpression that = (AbstractExpression)obj;
        return this.getTerms().equals(that.getTerms());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTerms());
    }

    @Override
    public String toString() {
        return "{" + this.getName() + ": " + String.valueOf(this.getTerms()) + "}";
    }

    protected void checkForAtLeastOneTerm() {
        if (this.getTerms().isEmpty()) {
            throw new IllegalStateException(ErrorMessages.get("invalidOperand.minimum.one.term", this.getName()));
        }
    }

    protected void checkForAtLeastTwoTerms() {
        if (this.getTerms().size() < 2) {
            throw new IllegalStateException(ErrorMessages.get("invalidOperand.minimum.two.terms", this.getName(), this.getTerms()));
        }
    }
}

