/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation.data.generation;

import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.mutation.data.generation.DataGenerationContext;
import com.ontotext.models.mutation.data.generation.DataGenerator;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.subscriptions.Subscription;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TypeDataGenerator
implements DataGenerator {
    private static final int UNAMBIGUOUS_TYPES_LIMIT = 1;

    @Override
    public OperationResponse visit(Query query, DataGenerationContext context) {
        return new OperationResponse();
    }

    @Override
    public OperationResponse visit(Selection selection, DataGenerationContext context) {
        return new OperationResponse();
    }

    @Override
    public OperationResponse visit(CreateMutation mutation, DataGenerationContext context) {
        return this.handleMutation(mutation, context);
    }

    @Override
    public OperationResponse visit(UpdateMutation mutation, DataGenerationContext context) {
        return this.handleMutation(mutation, context);
    }

    @Override
    public OperationResponse visit(DeleteMutation deleteMutation, DataGenerationContext context) {
        return new OperationResponse();
    }

    @Override
    public OperationResponse visit(Subscription subscription, DataGenerationContext context) {
        return new OperationResponse();
    }

    private OperationResponse handleMutation(Mutation mutation, DataGenerationContext context) {
        OperationResponse response = new OperationResponse();
        if (context.getOptions().isEnabled(this.getClass())) {
            SomlSchema schema = context.getSomlSchema();
            mutation.getChanges().stream().filter(change -> change.getType() == OperationType.CREATE).forEach(change -> this.attemptTypeGeneration((Change)change, schema, response));
        }
        return response;
    }

    private void attemptTypeGeneration(Change change, SomlSchema schema, OperationResponse response) {
        Shape shape = change.getShape();
        Set<String> definedDescriptors = TypeDataGenerator.getDefinedDescriptors(change, shape, schema);
        HashMap<String, Set<String>> typeChanges = new HashMap<String, Set<String>>();
        HashSet<String> addedProps = new HashSet<String>();
        this.tryToGenerate(shape, schema, definedDescriptors, addedProps, TypeDataGenerator.generateTypeOnSuccess(typeChanges), TypeDataGenerator.addWarningOnFailure(change, response));
        List<SourceLocation> location = Collections.singletonList(change.getSourceLocation());
        typeChanges.forEach((name, values) -> change.addPropertyValue((String)name, values, location));
    }

    private static Set<String> getDefinedDescriptors(Change change, Shape shape, SomlSchema schema) {
        Set<String> descriptors = schema.getObjects().getSoTypeDescriptors();
        return change.getChanges().stream().map(PropertyChange::getName).map(name -> TypeDataGenerator.getRdfProperty(shape, schema, name)).filter(descriptors::contains).collect(Collectors.toSet());
    }

    private static String getRdfProperty(Shape shape, SomlSchema schema, String propChangeName) {
        return shape.getProperty(propChangeName).map(PropertyShape::getRdfProperty).orElseGet(() -> {
            String shortIri = schema.getPrefixes().nameToShortIri(propChangeName);
            return shape.getProperty(shortIri).map(PropertyShape::getRdfProperty).orElse(shortIri);
        });
    }

    private static BiConsumer<String, List<String>> generateTypeOnSuccess(Map<String, Set<String>> typeChanges) {
        return (typeProp, types) -> {
            String typePropName = "rdf:type".equals(typeProp) ? "type" : typeProp;
            typeChanges.computeIfAbsent(typePropName, key -> new HashSet()).addAll(types);
        };
    }

    private static Consumer<List<String>> addWarningOnFailure(Change change, OperationResponse response) {
        return ambiguousTypes -> {
            Shape shape = change.getShape();
            String typeProp = shape.getTypeProp();
            response.addWarningMessage("data.generation.ambiguous.types", shape.getId(), typeProp, ambiguousTypes, typeProp);
        };
    }

    private void tryToGenerate(Shape shape, SomlSchema schema, Set<String> definedDescriptors, Set<String> addedProps, BiConsumer<String, List<String>> onSuccess, Consumer<List<String>> onErrors) {
        List<String> types;
        String typePropIri;
        if (!(shape.isIgnoredType() || definedDescriptors.contains(typePropIri = shape.getTypePropIri()) || (types = shape.getTypeAsList()).isEmpty() || addedProps.contains(shape.getTypeProp()))) {
            if (types.size() > 1) {
                onErrors.accept(types);
            } else {
                onSuccess.accept(shape.getTypeProp(), types);
            }
            addedProps.add(shape.getTypeProp());
        }
        this.tryToGenerateForParent(shape, schema, definedDescriptors, addedProps, onSuccess, onErrors);
    }

    private void tryToGenerateForParent(Shape shape, SomlSchema schema, Set<String> descriptors, Set<String> addedProps, BiConsumer<String, List<String>> onSuccess, Consumer<List<String>> onErrors) {
        List<String> parents = shape.getInheritsAsList();
        if (parents.isEmpty()) {
            return;
        }
        for (String parentId : parents) {
            Shape parent = (Shape)schema.getObjects().get(parentId);
            this.tryToGenerate(parent, schema, descriptors, addedProps, onSuccess, onErrors);
        }
    }
}

