/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation;

import com.ontotext.models.Constraint;
import com.ontotext.models.OperationType;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.ChangePreconditions;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.FilteredSelection;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.PassThroughInputValueConverter;
import com.ontotext.models.query.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Change {
    private String id;
    private final String transactionId = UUID.randomUUID().toString();
    private final OperationType type;
    private final Shape shape;
    private List<PropertyChange> changes = new LinkedList<PropertyChange>();
    private ChangePreconditions preconditions;
    private Map<String, List<FilteredSelection>> filteredObjects = new LinkedHashMap<String, List<FilteredSelection>>();
    private SourceLocation sourceLocation;
    private InputValueConverter inputValueConverter;
    private final SomlSchema schema;
    private final Prefixes prefixes;
    private List<Change> nestedChanges = new LinkedList<Change>();
    private Set<Constraint> constraints;
    private String collectChangesIn;
    private String graph;

    public Change(String id, OperationType type, Shape shape, SourceLocation sourceLocation) {
        this(id, type, shape, sourceLocation, new PassThroughInputValueConverter());
    }

    public Change(String id, OperationType type, Shape shape, SourceLocation sourceLocation, InputValueConverter propertyValueConverter) {
        this.id = id;
        this.type = type;
        this.shape = shape;
        this.sourceLocation = sourceLocation;
        this.inputValueConverter = propertyValueConverter;
        this.schema = shape.getContainedIn().getContainedIn();
        this.prefixes = this.schema.getPrefixes();
    }

    public Change copyShallow() {
        Change copy = new Change(this.id, this.type, this.shape, this.sourceLocation, this.inputValueConverter);
        if (this.preconditions != null) {
            copy.preconditions = new ChangePreconditions(this.preconditions.getParentChange(), this.preconditions);
            copy.preconditions.getPreconditionSelection().setSelection(this.preconditions.getPreconditionSelection().getSelection());
        }
        copy.nestedChanges.addAll(this.nestedChanges);
        copy.constraints = this.constraints;
        copy.filteredObjects.putAll(this.filteredObjects);
        copy.graph = this.graph;
        return copy;
    }

    public static Change forCreate(String id, Shape shape) {
        return new Change(id, OperationType.CREATE, shape, null);
    }

    public static Change forUpdate(String id, Shape shape) {
        return new Change(id, OperationType.UPDATE, shape, null);
    }

    public static Change forDelete(String id) {
        return new Change(id, OperationType.DELETE, null, null);
    }

    public Change addPropertyFromMap(String name, Map<String, Object> propertyMap) {
        return this.addPropertyFromMap(name, propertyMap, Collections.emptyList());
    }

    public Change addPropertyFromMap(String name, Map<String, Object> propertyMap, List<SourceLocation> sourceLocations) {
        return this.addToChanges(PropertyChange.fromMap(name, propertyMap, this.converter(name), sourceLocations));
    }

    public Change addPropertyValue(String name, Object valueToAdd) {
        return this.addPropertyValue(name, valueToAdd, Collections.emptyList());
    }

    public Change addPropertyValue(String name, Object valueToAdd, List<SourceLocation> sourceLocations) {
        return this.addToChanges(PropertyChange.add(name, valueToAdd, this.converter(name), sourceLocations));
    }

    public Change updatePropertyValue(String name, Object value, Object patch) {
        return this.updatePropertyValue(name, value, patch, Collections.emptyList());
    }

    public Change updatePropertyValue(String name, Object value, Object patch, List<SourceLocation> sourceLocations) {
        return this.addToChanges(PropertyChange.update(name, value, patch, this.converter(name), sourceLocations));
    }

    public Change replacePropertyValue(String name, Object value) {
        return this.replacePropertyValue(name, value, Collections.emptyList());
    }

    public Change replacePropertyValue(String name, Object value, List<SourceLocation> sourceLocations) {
        return this.addToChanges(PropertyChange.replace(name, value, this.converter(name), sourceLocations));
    }

    public Change deletePropertyValue(String name, Object patch) {
        return this.deletePropertyValue(name, patch, Collections.emptyList());
    }

    public Change deletePropertyValue(String name, Object patch, List<SourceLocation> sourceLocations) {
        return this.addToChanges(PropertyChange.delete(name, patch, this.converter(name), sourceLocations));
    }

    public Change deleteAllPropertyValues(String name) {
        return this.deleteAllPropertyValues(name, Collections.emptyList());
    }

    public Change deleteAllPropertyValues(String name, List<SourceLocation> sourceLocations) {
        return this.addToChanges(PropertyChange.delete(name, null, this.converter(name), sourceLocations));
    }

    public Change mergePropertyValue(String name, Object value, SourceLocation sourceLocation) {
        Optional<PropertyChange> oldChange = this.changes.stream().filter(propChange -> propChange.getName().equals(name)).findFirst();
        if (!oldChange.isPresent() || oldChange.get().hasValue() && oldChange.get().getRawValue().equals(value)) {
            return this;
        }
        this.changes.remove(oldChange.get());
        return this.addToChanges(PropertyChange.mergePropertyValues(oldChange.get(), value, sourceLocation));
    }

    private UnaryOperator<Object> converter(String name) {
        ScalarType scalarType = this.resolveScalarType(name);
        return value -> this.inputValueConverter.convertComplexValue(value, scalarType);
    }

    private ScalarType resolveScalarType(String name) {
        PropertyShape property = this.shape.getProperty(this.prefixes.nameToShortIri(name)).orElseThrow(() -> new IllegalArgumentException("Unknown property " + name));
        if (property.isScalarType()) {
            return property.getScalarType();
        }
        return (ScalarType)this.schema.getTypes().get("iri");
    }

    private Change addToChanges(PropertyChange change) {
        this.changes.add(change);
        return this;
    }

    public Change addObjectFilter(String name, ExpressionValue<?> value) {
        this.filteredObjects.computeIfAbsent(name, list -> new LinkedList()).add(new FilteredSelection(value));
        return this;
    }

    public Map<String, List<FilteredSelection>> getAllFilteredObjects() {
        return this.filteredObjects;
    }

    public List<FilteredSelection> getFilterForObject(String name) {
        return this.filteredObjects.getOrDefault(name, new ArrayList());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Optional<String> getEntityId() {
        if (ReferenceId.isNotReferenceId(this.id)) {
            return Optional.of(this.id);
        }
        if (this.hasPreconditions()) {
            if (Objects.nonNull(this.getPreconditions().getActualChangeId())) {
                return Optional.of(this.getPreconditions().getActualChangeId());
            }
            if (this.getPreconditions().getIdSelection().size() == 1) {
                return Optional.of(this.getPreconditions().getIdSelection().get(0));
            }
        }
        return Optional.empty();
    }

    public Optional<String> getNewEntityId() {
        return this.getChanges().stream().filter(propertyChange -> propertyChange.getName().equals("id")).filter(PropertyChange::hasValue).map(PropertyChange::getRawValue).map(Object::toString).findFirst();
    }

    public boolean matchId(String id) {
        return this.getNewEntityId().filter(Predicate.isEqual(id)).isPresent() || this.getEntityId().filter(Predicate.isEqual(id)).isPresent();
    }

    public OperationType getType() {
        return this.type;
    }

    public List<PropertyChange> getChanges() {
        return this.changes;
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public void transformChanges(UnaryOperator<PropertyChange> transformer) {
        Objects.requireNonNull(transformer);
        ListIterator<PropertyChange> li = this.changes.listIterator();
        while (li.hasNext()) {
            PropertyChange newValue = (PropertyChange)transformer.apply(li.next());
            if (newValue == null) {
                li.remove();
                continue;
            }
            li.set(newValue);
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public SomlSchema getSchema() {
        return this.shape.getContainedIn().getContainedIn();
    }

    public PropertyShape getPropertyChangeShape(String property) {
        return this.shape.getProperty(this.shape.getContainedIn().getContainedIn().getPrefixes().nameToShortIri(property)).orElseThrow(IllegalArgumentException::new);
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public String toString() {
        return new StringBuilder(90).append("Change{").append("id='").append(this.id).append('\'').append(", type=").append((Object)this.type).append(", changes=").append(this.changes).append(", constraints=").append(this.constraints).append('}').toString();
    }

    public ChangePreconditions getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(ChangePreconditions preconditions) {
        this.preconditions = preconditions;
        if (preconditions != null && preconditions.getParentChange() != null) {
            preconditions.getParentChange().addNestedChange(this);
        }
    }

    public boolean hasPreconditions() {
        return this.preconditions != null && this.preconditions.hasPreconditions();
    }

    public boolean isRootChange() {
        return this.preconditions == null || !this.preconditions.isNestedChange();
    }

    public List<Change> getNestedChanges() {
        return this.nestedChanges;
    }

    public void addNestedChange(Change change) {
        this.nestedChanges.add(change);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean hasConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
    }

    public String getCollectChangesIn() {
        return this.collectChangesIn != null ? this.collectChangesIn : this.transactionId;
    }

    public void setCollectChangesIn(String collectChangesIn) {
        this.collectChangesIn = collectChangesIn;
    }

    public String getGraph() {
        return this.graph;
    }

    public Change setGraph(String graph) {
        this.graph = graph;
        this.nestedChanges.forEach(change -> change.setGraph(graph));
        return this;
    }

    public boolean removeIfEmpty() {
        if (this.getType() == OperationType.DELETE) {
            return false;
        }
        if (this.isEmpty() && this.nestedChanges.isEmpty()) {
            if (this.preconditions == null || this.preconditions.getParentChange() == null) {
                return true;
            }
            this.preconditions.getParentChange().nestedChanges.remove(this);
            return true;
        }
        return false;
    }
}

