/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateParser;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class TemplateParsers {
    private static List<TemplateParser> parsers;

    private TemplateParsers() {
    }

    public static boolean isApplicable(String template) {
        return TemplateParsers.getParsers().stream().anyMatch(templateParser -> templateParser.isApplicable(template));
    }

    @NotNull
    public static Template parse(String name, String template) {
        for (TemplateParser templateParser : TemplateParsers.getParsers()) {
            Optional<Template> parsedTemplate = templateParser.parse(name, template);
            if (!parsedTemplate.isPresent()) continue;
            return parsedTemplate.get();
        }
        return Template.create(name, template);
    }

    static List<TemplateParser> getParsers() {
        if (parsers == null) {
            parsers = PluginsManager.loadPlugins(TemplateParser.class);
        }
        return parsers;
    }
}

