/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.extensions.TemplateParsers;
import com.ontotext.models.templates.PropertyRef;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateParseException;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.plugin.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Order(value=2200)
public class SparqlTemplatesGeneratorExtension
implements SchemaExtension {
    @Override
    public void postBaseSchemaMergeProcessing(SomlSchema somlSchema) {
        Prefixes prefixes = somlSchema.getPrefixes();
        for (PropertyShape property2 : somlSchema.getProperties().values()) {
            if (!StringUtils.isNotBlank((CharSequence)property2.getRdfProp()) || !property2.isSparqlTemplate() || property2.getSparqlTemplate() != null) continue;
            SparqlTemplatesGeneratorExtension.parseSparqlTemplate(property2.getName(), property2.getRdfProp(), property2::setSparqlTemplate);
        }
        Shapes objects = somlSchema.getObjects();
        for (Shape shape : objects.values()) {
            if (shape.isHierarchyInvalid() || Boolean.TRUE.equals(shape.isSynthetic())) continue;
            SparqlTemplatesGeneratorExtension.checkShape(shape);
            shape.getProps().values().stream().filter(PropertyShape::isSparqlTemplate).filter(propertyShape -> propertyShape.getSparqlTemplate() == null).forEach(property -> SparqlTemplatesGeneratorExtension.parseSparqlTemplate(SparqlTemplatesGeneratorExtension.buildName(prefixes, shape.getId(), property.getName()), property.getRdfProp(), property::setSparqlTemplate));
            this.checkExternalTemplateProperties(shape);
        }
        for (Shape shape : objects.values()) {
            if (shape.isHierarchyInvalid() || Boolean.TRUE.equals(shape.isSynthetic()) || shape.getInherits() == null) continue;
            shape.getAllProperties().values().stream().filter(PropertyShape::isSparqlTemplate).filter(propertyShape -> propertyShape.getSparqlTemplate() == null).forEach(property -> property.setSparqlTemplate(this.resolveParentTemplate(shape, (PropertyShape)property)));
            shape.getAllProperties().values().stream().filter(PropertyShape::isSparqlTemplate).filter(propertyShape -> propertyShape.getSparqlTemplate() != null).forEach(childProp -> Template.linkTemplates(this.resolveParentTemplate(shape, (PropertyShape)childProp), childProp.getSparqlTemplate()));
            this.checkExternalTemplateProperties(shape);
        }
    }

    private void checkExternalTemplateProperties(Shape shape) {
        new ArrayList(shape.getAllProperties().values()).stream().filter(PropertyShape::isSparqlTemplate).filter(prop -> prop.getSparqlTemplate() != null).filter(prop -> !prop.getSparqlTemplate().getExternalPropertyBindings().isEmpty()).forEach(prop -> this.checkExternalTemplateProperties(shape, (PropertyShape)prop));
    }

    private void checkExternalTemplateProperties(Shape shape, PropertyShape prop) {
        Set<PropertyRef> propertyRefs = prop.getSparqlTemplate().getExternalPropertyBindings();
        for (PropertyRef ref : propertyRefs) {
            if (ref.isSubjectBased() && !ref.isInternal()) {
                this.createNestedProperties(shape, ref);
                continue;
            }
            if (!ref.isValueBased()) continue;
            Shape rangeShape = prop.getRangeShape();
            this.createNestedProperties(rangeShape, ref);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createNestedProperties(Shape shape, PropertyRef ref) {
        List<String> segments = ref.segments().collect(Collectors.toList());
        String localProperty = (String)segments.get(0);
        Optional<PropertyShape> property = shape.getProperty(localProperty);
        if (property.isEmpty()) {
            if (segments.size() != 1) throw new InvalidSchemaException("Variable " + String.valueOf(ref) + " points to non existing relation");
            this.createProperty(shape, localProperty);
            return;
        } else {
            if (segments.size() <= 1) return;
            this.createNestedPropertyIfNeeded(ref, segments, property.get());
        }
    }

    private void createNestedPropertyIfNeeded(PropertyRef ref, List<String> segments, PropertyShape property) {
        String nestedProperty;
        Shape rangeShape = property.getRangeShape();
        Optional<PropertyShape> nestedRelation = rangeShape.getProperty(nestedProperty = segments.get(1));
        if (nestedRelation.isEmpty()) {
            if (segments.size() == 2) {
                this.createProperty(rangeShape, nestedProperty);
            } else {
                throw new InvalidSchemaException("Variable " + String.valueOf(ref) + " points to non existing relation in " + rangeShape.getId());
            }
        }
    }

    private void createProperty(Shape shape, String propName) {
        PropertyShape property = PropertyShape.create(propName, "string", null, "1");
        property.setScalarType((ScalarType)shape.getContainedIn().getContainedIn().getTypes().get("string"));
        property.setReadOnly(true);
        property.setRestrictive(true);
        property.setDefaults();
        shape.addProperty(property);
    }

    private Template resolveParentTemplate(Shape current, PropertyShape property) {
        return current.forEachParentShape().map(parent -> parent.getProperty(property.getName()).map(PropertyShape::getSparqlTemplate).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static void checkShape(Shape shape) {
        Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
        if (SparqlUtil.isSparqlTemplate((String)shape.getNameIri()) && shape.getNameTemplate() == null) {
            SparqlTemplatesGeneratorExtension.parseSparqlTemplate(SparqlTemplatesGeneratorExtension.buildName(prefixes, shape.getId(), "name"), shape.getNameIri(), shape::setNameTemplate);
        }
        if (SparqlUtil.isSparqlTemplate((String)shape.getTypePropIri()) && shape.getTypePropTemplate() == null) {
            SparqlTemplatesGeneratorExtension.parseSparqlTemplate(SparqlTemplatesGeneratorExtension.buildName(prefixes, shape.getId(), "typeProp"), shape.getTypePropIri(), shape::setTypePropTemplate);
        }
    }

    private static void parseSparqlTemplate(String name, String property, Consumer<Template> update) {
        try {
            update.accept(TemplateParsers.parse(name, property));
        }
        catch (TemplateParseException templateParseException) {
            // empty catch block
        }
    }

    private static String buildName(Prefixes prefixes, String ... path) {
        return Arrays.stream(path).map(prefixes::toName).collect(Collectors.joining("."));
    }
}

