/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.extensions.SparqlValidator;
import com.ontotext.soaas.common.CachingSupplier;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.plugin.Order;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@Order(value=1200)
public class PropertyRdfPropSparqlFragmentExtension
implements SchemaExtension {
    private static final Pattern SELECT_PATTERN = Pattern.compile("\\b[sS][eE][lL][eE][cC][tT]\\b");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("\\W([\\w-]+:)");
    private static final Supplier<SparqlValidator> VALIDATOR = new CachingSupplier(SparqlValidator::resolve);

    @Override
    public void postBaseSchemaMergeProcessing(SomlSchema somlSchema) {
        BinaryOperator<String> queryBuilder = PropertyRdfPropSparqlFragmentExtension.queryBuilder(somlSchema.getPrefixes());
        String baseIri = somlSchema.getPrefixes().getBaseIri().orElse("");
        for (PropertyShape property2 : somlSchema.getProperties().values()) {
            if (!StringUtils.isNotBlank((CharSequence)property2.getRdfProp()) || !property2.isSparqlTemplate()) continue;
            this.checkSparqlTemplate(property2.getRdfProp(), queryBuilder, baseIri, property2::setRdfProp);
        }
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.isHierarchyInvalid() || Boolean.TRUE.equals(shape.isSynthetic()) || shape.isUnion()) continue;
            this.checkShape(shape, queryBuilder, baseIri);
            shape.getAllProperties().values().stream().distinct().filter(property -> StringUtils.isNotBlank((CharSequence)property.getRdfProp())).filter(PropertyShape::isSparqlTemplate).forEach(property -> this.checkSparqlTemplate(property.getRdfProp(), queryBuilder, baseIri, property::setRdfProp));
        }
    }

    private void checkShape(Shape shape, BinaryOperator<String> queryBuilder, String baseIri) {
        if (SparqlUtil.isSparqlTemplate((String)shape.getNameIri())) {
            this.checkSparqlTemplate(shape.getNameIri(), queryBuilder, baseIri, shape::setNameIri);
        }
        if (SparqlUtil.isSparqlTemplate((String)shape.getTypePropIri())) {
            this.checkSparqlTemplate(shape.getTypePropIri(), queryBuilder, baseIri, shape::setTypePropIri);
        }
    }

    private void checkSparqlTemplate(String property, BinaryOperator<String> queryBuilder, String baseIri, Consumer<String> update) {
        try {
            VALIDATOR.get().validate((String)queryBuilder.apply(property, ""), baseIri);
        }
        catch (SparqlValidator.QuerySyntaxError qve) {
            try {
                VALIDATOR.get().validate((String)queryBuilder.apply(property, "."), baseIri);
                update.accept(property + ".");
            }
            catch (SparqlValidator.QuerySyntaxError querySyntaxError) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BinaryOperator<String> queryBuilder(Prefixes prefixes) {
        StringBuilder queryBuilder = new StringBuilder();
        prefixes.getBaseIri().ifPresent(baseIri -> queryBuilder.append("BASE <").append((String)baseIri).append(">"));
        prefixes.forEach((prefix, namespace) -> queryBuilder.append("PREFIX ").append((String)prefix).append(": <").append((String)namespace).append(">"));
        queryBuilder.append("SELECT * WHERE {\n");
        String queryTemplate = queryBuilder.toString();
        return (template, suffix) -> {
            template = PropertyRdfPropSparqlFragmentExtension.normalizePrefixes((String)template);
            if (SELECT_PATTERN.matcher((CharSequence)(template = SparqlUtil.escapeExternalPropertyBindings((String)template))).find()) {
                template = "{" + (String)template + "}";
            }
            return queryTemplate + (String)template + suffix + " <urn:a> <urn:b> <urn:c>}";
        };
    }

    private static String normalizePrefixes(String fragmentBody) {
        Matcher matcher = PREFIX_PATTERN.matcher(fragmentBody);
        int start = 0;
        while (matcher.find(start)) {
            String prefix = matcher.group(1);
            if (prefix.contains("-")) {
                fragmentBody = fragmentBody.replace(prefix, prefix.replace('-', '_'));
            }
            start = matcher.end(1);
        }
        return fragmentBody;
    }
}

