/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.Configs;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SparqlFederatedServicesPriority;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.soaas.plugin.Order;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Order(value=2500)
public class FederatedSparqlServiceResolver
implements SchemaExtension {
    private static final String SERVICES_KEY = "sparql.federated.services.";
    private static final String GDB_SERVICES_KEY = "graphdb.sparql.federated.services.";
    private ConfigurationResolver resolver;

    @Override
    public boolean canHandle(SomlSchema soml) {
        return Boolean.FALSE.equals(soml.getInternal()) || !"/soml/soml-rbac".equals(soml.getId());
    }

    @Override
    public void process(SomlSchema somlSchema) {
        Configs configs = somlSchema.getConfig();
        Map<String, String> federatedServices = configs.getSparqlFederatedServices().orElse(Map.of());
        SparqlFederatedServicesPriority priority = configs.getSparqlFederatedServicesPriority().orElse(SparqlFederatedServicesPriority.CONFIG_FIRST);
        for (Shape shape : somlSchema.getObjects().values()) {
            String service;
            String serviceKey = shape.getSparqlFederatedService();
            if (serviceKey == null || federatedServices.isEmpty() && this.resolver == null || (service = this.resolveService(federatedServices, serviceKey, priority)) == null || service.isEmpty()) continue;
            shape.setServiceAddress(service);
        }
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.getServiceAddress() != null) continue;
            shape.resolveCommonServiceAddress().ifPresent(shape::setServiceAddress);
        }
    }

    private String resolveService(Map<String, String> federatedServices, String serviceKey, SparqlFederatedServicesPriority priority) {
        String localConfig = StringUtils.trimToNull((String)federatedServices.get(serviceKey));
        if (priority == SparqlFederatedServicesPriority.CONFIG_FIRST) {
            if (this.resolver != null) {
                String resolved = this.resolver.resolve(GDB_SERVICES_KEY + serviceKey, String.class, null);
                if (resolved != null) {
                    return resolved;
                }
                return this.resolver.resolve(SERVICES_KEY + serviceKey, String.class, localConfig);
            }
            return localConfig;
        }
        if (priority == SparqlFederatedServicesPriority.MODEL_FIRST) {
            if (localConfig != null) {
                return localConfig;
            }
            if (this.resolver != null) {
                String resolved = this.resolver.resolve(GDB_SERVICES_KEY + serviceKey, String.class, null);
                if (resolved != null) {
                    return resolved;
                }
                return this.resolver.resolve(SERVICES_KEY + serviceKey, String.class, null);
            }
            return null;
        }
        return null;
    }

    @Override
    public void configure(ConfigurationResolver resolver) {
        this.resolver = resolver;
    }
}

