/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.search.SearchConfig;
import com.ontotext.models.search.Type;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.plugin.Order;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;

@Order(value=1005)
public class CalculatePropertiesSearchConfiguration
implements SchemaExtension {
    private static final String ID = "id";
    private static final List<String> TYPE_OVERRIDE_FORBIDDEN = Arrays.asList("id", "name", "type");

    @Override
    public boolean canHandle(SomlSchema soml) {
        return Boolean.FALSE.equals(soml.getInternal()) || !"/soml/soml-rbac".equals(soml.getId());
    }

    @Override
    public void process(SomlSchema soml) {
        Shapes shapes = soml.getObjects();
        this.processSchemaProperties(soml);
        HashSet<String> processedShapes = new HashSet<String>();
        for (Shape shape : shapes.values()) {
            if (this.isShapeSearchable(shape, shapes)) {
                this.processProperties(shape, soml);
                continue;
            }
            this.copySearchableFromParentProperties(shape, processedShapes);
            if (!shape.hasSearchableProperties()) continue;
            shape.getProperty(ID).filter(id -> !id.isSearchable()).ifPresent(id -> {
                SearchConfig newConfig = new SearchConfig(true);
                newConfig.setIndex(SearchConfig.Index.TRUE);
                newConfig.setType(new Type(true));
                newConfig.merge(id.getSearch());
                id.setSearch(newConfig);
            });
        }
    }

    private void copySearchableFromParentProperties(Shape shape, Set<String> processedShapes) {
        if (processedShapes.contains(shape.getId())) {
            return;
        }
        processedShapes.add(shape.getId());
        if (shape.isHierarchyInvalid()) {
            return;
        }
        if (shape.getInherits() == null) {
            return;
        }
        shape.forEachParent(parentShape -> {
            this.copySearchableFromParentProperties((Shape)parentShape, processedShapes);
            BiConsumer<String, PropertyShape> propHandler = (propName, property) -> parentShape.getProperty((String)propName).ifPresent(parentProp -> {
                if (property.getSearch() == null) {
                    property.setSearch(this.buildSearchConfig(parentProp.getSearchSafe().getIndex()));
                } else {
                    property.getSearch().merge(parentProp.getSearchSafe());
                }
            });
            shape.getAllProperties().forEach(propHandler);
            shape.getProps().forEach(propHandler);
        });
    }

    private void processSchemaProperties(SomlSchema soml) {
        Integer globalConfigNestingLvl = this.getGlobalConfigNestingLevel(soml);
        if (globalConfigNestingLvl == null) {
            return;
        }
        for (PropertyShape property : soml.getProperties().values()) {
            if (!this.isObjectProperty(soml, property)) continue;
            SearchConfig search = property.getSearch();
            if (search == null) {
                SearchConfig config = this.buildSearchConfig(null);
                config.getType().setNestingLevel(globalConfigNestingLvl);
                property.setSearch(config);
                continue;
            }
            this.setTypeWithNestingLevel(globalConfigNestingLvl, search);
        }
    }

    private boolean isObjectProperty(SomlSchema soml, PropertyShape property) {
        return soml.getObjects().get(property.getRange()) != null;
    }

    private void setTypeWithNestingLevel(Integer nestingLevel, SearchConfig searchConfig) {
        if (searchConfig.getType() == null || !searchConfig.isTracked("type")) {
            Type type = new Type("nested");
            type.setNestingLevel((Integer)ObjectsUtil.getOrDefault((Object)nestingLevel, (Object)0));
            searchConfig.setType(type);
        } else if (searchConfig.getType().getNestingLevel() == null || !searchConfig.getType().isTracked("nestingLevel")) {
            searchConfig.getType().setNestingLevel(nestingLevel);
        }
    }

    private boolean isShapeSearchable(Shape shape, Shapes shapes) {
        return this.isSearchable(shape) && shapes.isTracked(shape.getId()) && !shape.isSystem() && !shape.isUnion();
    }

    private boolean isSearchable(Shape shape) {
        return shape.isSearchable() || shape.getSearchSafe().isNested() != false;
    }

    private void processProperties(Shape shape, SomlSchema soml) {
        Integer globalConfigNestingLvl = this.getGlobalConfigNestingLevel(soml);
        for (PropertyShape property : shape.getAllProperties().values()) {
            SearchConfig propSearch = property.getSearch();
            SearchConfig.Index index = this.calculateIndex(property.getName(), shape);
            if (propSearch == null) {
                property.setSearch(this.buildSearchConfig(index));
            } else if (propSearch.getIndex() == null) {
                propSearch.setIndex(index);
            }
            this.syncSearchTypeNameForScalarProperty(property, shape, soml);
            if (globalConfigNestingLvl == null || !this.isObjectProperty(soml, property)) continue;
            this.setTypeWithNestingLevel(globalConfigNestingLvl, property.getSearch());
        }
    }

    private Integer getGlobalConfigNestingLevel(SomlSchema soml) {
        return soml.getConfig().getSearch().map(SearchConfig::getType).map(Type::getNestingLevel).orElse(null);
    }

    private SearchConfig.Index calculateIndex(String propertyName, Shape shape) {
        if (shape.isSearchable()) {
            return shape.getSearch().getIndex();
        }
        return this.checkInHierarchy(propertyName, shape).orElse(shape.getSearch().getIndex());
    }

    private Optional<SearchConfig.Index> checkInHierarchy(String propertyName, Shape shape) {
        return shape.getParents().map(parent -> parent.getProperty(propertyName).map(prop -> prop.getSearchSafe().getIndex()).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    private SearchConfig buildSearchConfig(SearchConfig.Index index) {
        SearchConfig config = new SearchConfig(true);
        config.setIndex(index);
        config.setType(new Type(true));
        return config;
    }

    private void syncSearchTypeNameForScalarProperty(PropertyShape property, Shape shape, SomlSchema soml) {
        Type shapeSearchType = shape.getSearch().getType();
        if (shapeSearchType == null || this.isObjectProperty(soml, property) || property.isScalarType() && property.getScalarType().isLangStringSupported() || TYPE_OVERRIDE_FORBIDDEN.contains(property.getName())) {
            return;
        }
        SearchConfig searchConfig = property.getSearch();
        if (searchConfig.getType() == null || !searchConfig.isTracked("type")) {
            searchConfig.setType(new Type(shapeSearchType.getName()));
        }
    }
}

