/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.soaas.plugin.Order;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

@Order(value=999999999)
public class BaseShapeCharacteristicsOverrider
implements SchemaExtension {
    @Override
    public boolean canHandle(SomlSchema soml) {
        return Boolean.FALSE.equals(soml.getInternal()) || !"/soml/soml-rbac".equals(soml.getId());
    }

    @Override
    public void process(SomlSchema soml) {
        Shapes shapes = soml.getObjects();
        shapes.values().stream().filter(this.isOverridable(shapes)).forEach(this::overrideCharacteristics);
    }

    private Predicate<Shape> isOverridable(Shapes shapes) {
        return shape -> shapes.isTracked(shape.getId()) && !shape.isSystem() && !shape.isUnion();
    }

    private void overrideCharacteristics(Shape shape) {
        this.overrideNameCharacteristics(shape);
    }

    private void overrideNameCharacteristics(Shape shape) {
        String name = shape.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        shape.getProperty(name).ifPresent(propRef -> this.transferNonNullable("name", shape, (PropertyShape)propRef));
    }

    private void transferNonNullable(String propertyName, Shape shape, PropertyShape propRef) {
        shape.getProperty(propertyName).ifPresent(nameShape -> nameShape.setNonNullable(propRef.isNonNullable()));
    }
}

